/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.http.fileupload.UploadContext;

public class ServletRequestContext
implements UploadContext {
    private final HttpServletRequest request;

    public ServletRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    public long contentLength() {
        long size2;
        try {
            size2 = Long.parseLong(this.request.getHeader("Content-length"));
        }
        catch (NumberFormatException e) {
            size2 = this.request.getContentLength();
        }
        return size2;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

