/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileUtils {
    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(directory)) {
            FileUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            String message2 = "Unable to delete directory " + String.valueOf(directory) + ".";
            throw new IOException(message2);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message2 = String.valueOf(directory) + " does not exist";
            throw new IllegalArgumentException(message2);
        }
        if (!directory.isDirectory()) {
            String message3 = String.valueOf(directory) + " is not a directory";
            throw new IllegalArgumentException(message3);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + String.valueOf(directory));
        }
        IOException exception2 = null;
        for (File file2 : files) {
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException ioe) {
                exception2 = ioe;
            }
        }
        if (null != exception2) {
            throw exception2;
        }
    }

    public static void forceDelete(File file2) throws IOException {
        if (file2.isDirectory()) {
            FileUtils.deleteDirectory(file2);
        } else {
            boolean filePresent = file2.exists();
            if (!file2.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + String.valueOf(file2));
                }
                String message2 = "Unable to delete file: " + String.valueOf(file2);
                throw new IOException(message2);
            }
        }
    }

    public static void forceDeleteOnExit(File file2) throws IOException {
        if (file2.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file2);
        } else {
            file2.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        directory.deleteOnExit();
        if (!FileUtils.isSymlink(directory)) {
            FileUtils.cleanDirectoryOnExit(directory);
        }
    }

    private static void cleanDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            String message2 = String.valueOf(directory) + " does not exist";
            throw new IllegalArgumentException(message2);
        }
        if (!directory.isDirectory()) {
            String message3 = String.valueOf(directory) + " is not a directory";
            throw new IllegalArgumentException(message3);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + String.valueOf(directory));
        }
        IOException exception2 = null;
        for (File file2 : files) {
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException ioe) {
                exception2 = ioe;
            }
        }
        if (null != exception2) {
            throw exception2;
        }
    }

    public static void forceMkdir(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                String message2 = "File " + String.valueOf(directory) + " exists and is not a directory. Unable to create directory.";
                throw new IOException(message2);
            }
        } else if (!directory.mkdirs() && !directory.isDirectory()) {
            String message3 = "Unable to create directory " + String.valueOf(directory);
            throw new IOException(message3);
        }
    }

    public static void forceMkdirParent(File file2) throws IOException {
        File parent = file2.getParentFile();
        if (parent == null) {
            return;
        }
        FileUtils.forceMkdir(parent);
    }

    public static boolean isSymlink(File file2) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("File must not be null");
        }
        if (File.separatorChar == '\\') {
            return false;
        }
        File fileInCanonicalDir = null;
        if (file2.getParent() == null) {
            fileInCanonicalDir = file2;
        } else {
            File canonicalDir = file2.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file2.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }
}

