/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.BitSet;
import java.util.Date;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieProcessorBase;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.SameSiteCookies;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.parser.Cookie;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class Rfc6265CookieProcessor
extends CookieProcessorBase {
    private static final Log log;
    private static final StringManager sm;
    private static final BitSet domainValid;

    @Override
    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public void parseCookieHeader(MimeHeaders headers, ServerCookies serverCookies) {
        if (headers == null) {
            return;
        }
        int pos2 = headers.findHeader("Cookie", 0);
        while (pos2 >= 0) {
            MessageBytes cookieValue = headers.getValue(pos2);
            if (cookieValue != null && !cookieValue.isNull()) {
                if (cookieValue.getType() != 2) {
                    if (log.isDebugEnabled()) {
                        Exception e = new Exception();
                        log.debug(sm.getString("rfc6265CookieProcessor.expectedBytes"), e);
                    }
                    cookieValue.toBytes();
                }
                if (log.isTraceEnabled()) {
                    log.trace("Cookies: Parsing b[]: " + cookieValue.toString());
                }
                ByteChunk bc = cookieValue.getByteChunk();
                Cookie.parseCookie(bc.getBytes(), bc.getStart(), bc.getLength(), serverCookies);
            }
            ++pos2;
            pos2 = headers.findHeader("Cookie", pos2);
        }
    }

    @Override
    public String generateHeader(jakarta.servlet.http.Cookie cookie, HttpServletRequest request) {
        String cookieSameSite;
        String path2;
        String domain;
        int maxAge;
        StringBuffer header = new StringBuffer();
        header.append(cookie.getName());
        header.append('=');
        String value2 = cookie.getValue();
        if (value2 != null && value2.length() > 0) {
            this.validateCookieValue(value2);
            header.append(value2);
        }
        if ((maxAge = cookie.getMaxAge()) > -1) {
            header.append("; Max-Age=");
            header.append(maxAge);
            header.append("; Expires=");
            if (maxAge == 0) {
                header.append(ANCIENT_DATE);
            } else {
                ((DateFormat)COOKIE_DATE_FORMAT.get()).format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), header, new FieldPosition(0));
            }
        }
        if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
            this.validateDomain(domain);
            header.append("; Domain=");
            header.append(domain);
        }
        if ((path2 = cookie.getPath()) != null && path2.length() > 0) {
            this.validatePath(path2);
            header.append("; Path=");
            header.append(path2);
        }
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if ((cookieSameSite = cookie.getAttribute("SameSite")) == null) {
            SameSiteCookies sameSiteCookiesValue = this.getSameSiteCookies();
            if (!sameSiteCookiesValue.equals((Object)SameSiteCookies.UNSET)) {
                header.append("; SameSite=");
                header.append(sameSiteCookiesValue.getValue());
            }
        } else {
            header.append("; SameSite=");
            header.append(cookieSameSite);
        }
        String cookiePartitioned = cookie.getAttribute("Partitioned");
        if (cookiePartitioned == null) {
            if (this.getPartitioned()) {
                header.append("; Partitioned");
            }
        } else if (Boolean.parseBoolean(cookiePartitioned)) {
            header.append("; Partitioned");
        }
        block13: for (Map.Entry<String, String> entry : cookie.getAttributes().entrySet()) {
            switch (entry.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": 
                case "SameSite": 
                case "Partitioned": {
                    continue block13;
                }
            }
            this.validateAttribute(entry.getKey(), entry.getValue());
            header.append("; ");
            header.append(entry.getKey());
            header.append('=');
            header.append(entry.getValue());
        }
        return header.toString();
    }

    private void validateCookieValue(String value2) {
        int start2 = 0;
        int end2 = value2.length();
        if (end2 > 1 && value2.charAt(0) == '\"' && value2.charAt(end2 - 1) == '\"') {
            start2 = 1;
            --end2;
        }
        char[] chars2 = value2.toCharArray();
        for (int i2 = start2; i2 < end2; ++i2) {
            char c = chars2[i2];
            if (c >= '!' && c != '\"' && c != ',' && c != ';' && c != '\\' && c != '\u007f') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidCharInValue", Integer.toString(c)));
        }
    }

    private void validateDomain(String domain) {
        int prev = -1;
        int cur = -1;
        char[] chars2 = domain.toCharArray();
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            prev = cur;
            cur = chars2[i2];
            if (!domainValid.get(cur)) {
                throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
            }
            if (prev != 45 || cur != 46) continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
        }
        if (cur == 46 || cur == 45) {
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
        }
    }

    private void validatePath(String path2) {
        char[] chars2;
        for (char ch : chars2 = path2.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidPath", path2));
        }
    }

    private void validateAttribute(String name2, String value2) {
        char[] chars2;
        if (!HttpParser.isToken(name2)) {
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidAttributeName", name2));
        }
        for (char ch : chars2 = value2.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidAttributeValue", name2, value2));
        }
    }

    static {
        int c;
        log = LogFactory.getLog(Rfc6265CookieProcessor.class);
        sm = StringManager.getManager(Rfc6265CookieProcessor.class.getPackage().getName());
        domainValid = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

