/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

public class RequestUtil {
    private RequestUtil() {
    }

    public static String normalize(String path2) {
        return RequestUtil.normalize(path2, true);
    }

    public static String normalize(String path2, boolean replaceBackSlash) {
        int index2;
        if (path2 == null) {
            return null;
        }
        Object normalized = path2;
        if (replaceBackSlash && ((String)normalized).indexOf(92) >= 0) {
            normalized = ((String)normalized).replace('\\', '/');
        }
        if (!((String)normalized).startsWith("/")) {
            normalized = "/" + (String)normalized;
        }
        boolean addedTrailingSlash = false;
        if (((String)normalized).endsWith("/.") || ((String)normalized).endsWith("/..")) {
            normalized = (String)normalized + "/";
            addedTrailingSlash = true;
        }
        while ((index2 = ((String)normalized).indexOf("//")) >= 0) {
            normalized = ((String)normalized).substring(0, index2) + ((String)normalized).substring(index2 + 1);
        }
        while ((index2 = ((String)normalized).indexOf("/./")) >= 0) {
            normalized = ((String)normalized).substring(0, index2) + ((String)normalized).substring(index2 + 2);
        }
        while ((index2 = ((String)normalized).indexOf("/../")) >= 0) {
            if (index2 == 0) {
                return null;
            }
            int index22 = ((String)normalized).lastIndexOf(47, index2 - 1);
            normalized = ((String)normalized).substring(0, index22) + ((String)normalized).substring(index2 + 3);
        }
        if (((String)normalized).length() > 1 && addedTrailingSlash) {
            normalized = ((String)normalized).substring(0, ((String)normalized).length() - 1);
        }
        return normalized;
    }

    public static boolean isSameOrigin(HttpServletRequest request, String origin) {
        StringBuilder target2 = new StringBuilder();
        String scheme = request.getScheme();
        if (scheme == null) {
            return false;
        }
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        target2.append(scheme);
        target2.append("://");
        String host = request.getServerName();
        if (host == null) {
            return false;
        }
        target2.append(host);
        int port = request.getServerPort();
        if (target2.length() == origin.length()) {
            if (("http".equals(scheme) || "ws".equals(scheme)) && port != 80 || ("https".equals(scheme) || "wss".equals(scheme)) && port != 443) {
                target2.append(':');
                target2.append(port);
            }
        } else {
            target2.append(':');
            target2.append(port);
        }
        return origin.equals(target2.toString());
    }

    public static boolean isValidOrigin(String origin) {
        URI originURI;
        if (origin.contains("%")) {
            return false;
        }
        if ("null".equals(origin)) {
            return true;
        }
        if (origin.startsWith("file://")) {
            return true;
        }
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return originURI.getScheme() != null;
    }
}

