/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.http.MimeHeaderField;
import org.apache.tomcat.util.http.NamesEnumerator;
import org.apache.tomcat.util.http.ValuesEnumerator;
import org.apache.tomcat.util.res.StringManager;

public class MimeHeaders {
    public static final int DEFAULT_HEADER_SIZE = 8;
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.http");
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private int limit = -1;

    public void setLimit(int limit2) {
        this.limit = limit2;
        if (limit2 > 0 && this.headers.length > limit2 && this.count < limit2) {
            MimeHeaderField[] tmp = new MimeHeaderField[limit2];
            System.arraycopy(this.headers, 0, tmp, 0, this.count);
            this.headers = tmp;
        }
    }

    public void recycle() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.headers[i2].recycle();
        }
        this.count = 0;
    }

    @Deprecated
    public void clear() {
        this.recycle();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== MimeHeaders ===");
        Enumeration<String> e = this.names();
        while (e.hasMoreElements()) {
            String n = e.nextElement();
            Enumeration<String> ev = this.values(n);
            while (ev.hasMoreElements()) {
                pw.print(n);
                pw.print(" = ");
                pw.println(ev.nextElement());
            }
        }
        return sw.toString();
    }

    public Map<String, String> toMap() {
        if (this.count == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (int i2 = 0; i2 < this.count; ++i2) {
            String name2 = this.headers[i2].getName().toStringType();
            String value2 = this.headers[i2].getValue().toStringType();
            result2.merge(name2, value2, StringUtils::join);
        }
        return result2;
    }

    public void filter(Set<String> allowedHeaders) {
        int j = -1;
        for (int i2 = 0; i2 < this.count; ++i2) {
            String name2 = this.headers[i2].getName().toStringType();
            if (!allowedHeaders.contains(name2) || ++j == i2) continue;
            this.headers[j] = this.headers[i2];
        }
        this.count = ++j;
    }

    public void duplicate(MimeHeaders source2) throws IOException {
        for (int i2 = 0; i2 < source2.size(); ++i2) {
            MimeHeaderField mhf = this.createHeader();
            mhf.getName().duplicate(source2.getName(i2));
            mhf.getValue().duplicate(source2.getValue(i2));
        }
    }

    public int size() {
        return this.count;
    }

    public MessageBytes getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public MessageBytes getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public int findHeader(String name2, int starting) {
        for (int i2 = starting; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name2)) continue;
            return i2;
        }
        return -1;
    }

    public Enumeration<String> names() {
        return new NamesEnumerator(this);
    }

    public Enumeration<String> values(String name2) {
        return new ValuesEnumerator(this, name2);
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        if (this.limit > -1 && this.count >= this.limit) {
            throw new IllegalStateException(sm.getString("headers.maxCountFail", this.limit));
        }
        int len = this.headers.length;
        if (this.count >= len) {
            int newLength = this.count * 2;
            if (this.limit > 0 && newLength > this.limit) {
                newLength = this.limit;
            }
            MimeHeaderField[] tmp = new MimeHeaderField[newLength];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public MessageBytes addValue(String name2) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name2);
        return mh.getValue();
    }

    public MessageBytes addValue(byte[] b2, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(b2, startN, len);
        return mhf.getValue();
    }

    public MessageBytes setValue(String name2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name2)) continue;
            for (int j = i2 + 1; j < this.count; ++j) {
                if (!this.headers[j].getName().equalsIgnoreCase(name2)) continue;
                this.removeHeader(j--);
            }
            return this.headers[i2].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name2);
        return mh.getValue();
    }

    public MessageBytes getValue(String name2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name2)) continue;
            return this.headers[i2].getValue();
        }
        return null;
    }

    public MessageBytes getUniqueValue(String name2) {
        MessageBytes result2 = null;
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name2)) continue;
            if (result2 == null) {
                result2 = this.headers[i2].getValue();
                continue;
            }
            throw new IllegalArgumentException();
        }
        return result2;
    }

    public String getHeader(String name2) {
        MessageBytes mh = this.getValue(name2);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name2)) continue;
            this.removeHeader(i2--);
        }
    }

    public void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        System.arraycopy(this.headers, idx + 1, this.headers, idx, this.count - idx - 1);
        this.headers[this.count - 1] = mh;
        --this.count;
    }
}

