/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.util.http.ConcurrentDateFormat;

public final class FastHttpDateFormat {
    private static final int CACHE_SIZE = Integer.getInteger("org.apache.tomcat.util.http.FastHttpDateFormat.CACHE_SIZE", 1000);
    private static final String DATE_RFC5322 = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String DATE_OBSOLETE_RFC850 = "EEEEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String DATE_OBSOLETE_ASCTIME = "EEE MMMM d HH:mm:ss yyyy";
    private static final ConcurrentDateFormat FORMAT_RFC5322;
    private static final ConcurrentDateFormat FORMAT_OBSOLETE_RFC850;
    private static final ConcurrentDateFormat FORMAT_OBSOLETE_ASCTIME;
    private static final ConcurrentDateFormat[] httpParseFormats;
    private static volatile long currentDateGenerated;
    private static String currentDate;
    private static final Map<Long, String> formatCache;
    private static final Map<String, Long> parseCache;

    public static String getCurrentDate() {
        long now2 = System.currentTimeMillis();
        if (Math.abs(now2 - currentDateGenerated) > 1000L) {
            currentDate = FORMAT_RFC5322.format(new Date(now2));
            currentDateGenerated = now2;
        }
        return currentDate;
    }

    public static String formatDate(long value2) {
        Long longValue = value2;
        String cachedDate = formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = FORMAT_RFC5322.format(new Date(value2));
        FastHttpDateFormat.updateFormatCache(longValue, newDate);
        return newDate;
    }

    public static long parseDate(String value2) {
        Long cachedDate = parseCache.get(value2);
        if (cachedDate != null) {
            return cachedDate;
        }
        long date2 = -1L;
        for (int i2 = 0; date2 == -1L && i2 < httpParseFormats.length; ++i2) {
            try {
                date2 = httpParseFormats[i2].parse(value2).getTime();
                FastHttpDateFormat.updateParseCache(value2, date2);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date2;
    }

    private static void updateFormatCache(Long key2, String value2) {
        if (value2 == null) {
            return;
        }
        if (formatCache.size() > CACHE_SIZE) {
            formatCache.clear();
        }
        formatCache.put(key2, value2);
    }

    private static void updateParseCache(String key2, Long value2) {
        if (value2 == null) {
            return;
        }
        if (parseCache.size() > CACHE_SIZE) {
            parseCache.clear();
        }
        parseCache.put(key2, value2);
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        FORMAT_RFC5322 = new ConcurrentDateFormat(DATE_RFC5322, Locale.US, tz);
        FORMAT_OBSOLETE_RFC850 = new ConcurrentDateFormat(DATE_OBSOLETE_RFC850, Locale.US, tz);
        FORMAT_OBSOLETE_ASCTIME = new ConcurrentDateFormat(DATE_OBSOLETE_ASCTIME, Locale.US, tz);
        httpParseFormats = new ConcurrentDateFormat[]{FORMAT_RFC5322, FORMAT_OBSOLETE_RFC850, FORMAT_OBSOLETE_ASCTIME};
        currentDateGenerated = 0L;
        currentDate = null;
        formatCache = new ConcurrentHashMap<Long, String>(CACHE_SIZE);
        parseCache = new ConcurrentHashMap<String, Long>(CACHE_SIZE);
    }
}

