/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import jakarta.servlet.SessionTrackingMode;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public class SessionConfig {
    private Integer sessionTimeout;
    private String cookieName;
    private final Map<String, String> cookieAttributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final EnumSet<SessionTrackingMode> sessionTrackingModes = EnumSet.noneOf(SessionTrackingMode.class);

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String sessionTimeout) {
        this.sessionTimeout = Integer.valueOf(sessionTimeout);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieDomain() {
        return this.getCookieAttribute("Domain");
    }

    public void setCookieDomain(String cookieDomain) {
        this.setCookieAttribute("Domain", cookieDomain);
    }

    public String getCookiePath() {
        return this.getCookieAttribute("Path");
    }

    public void setCookiePath(String cookiePath) {
        this.setCookieAttribute("Path", cookiePath);
    }

    public String getCookieComment() {
        return this.getCookieAttribute("Comment");
    }

    public void setCookieComment(String cookieComment) {
        this.setCookieAttribute("Comment", cookieComment);
    }

    public Boolean getCookieHttpOnly() {
        String httpOnly = this.getCookieAttribute("HttpOnly");
        if (httpOnly == null) {
            return null;
        }
        return Boolean.valueOf(httpOnly);
    }

    public void setCookieHttpOnly(String cookieHttpOnly) {
        this.setCookieAttribute("HttpOnly", cookieHttpOnly);
    }

    public Boolean getCookieSecure() {
        String secure = this.getCookieAttribute("Secure");
        if (secure == null) {
            return null;
        }
        return Boolean.valueOf(secure);
    }

    public void setCookieSecure(String cookieSecure) {
        this.setCookieAttribute("Secure", cookieSecure);
    }

    public Integer getCookieMaxAge() {
        String maxAge = this.getCookieAttribute("Max-Age");
        if (maxAge == null) {
            return null;
        }
        return Integer.valueOf(maxAge);
    }

    public void setCookieMaxAge(String cookieMaxAge) {
        this.setCookieAttribute("Max-Age", cookieMaxAge);
    }

    public Map<String, String> getCookieAttributes() {
        return this.cookieAttributes;
    }

    public void setCookieAttribute(String name2, String value2) {
        this.cookieAttributes.put(name2, value2);
    }

    public String getCookieAttribute(String name2) {
        return this.cookieAttributes.get(name2);
    }

    public EnumSet<SessionTrackingMode> getSessionTrackingModes() {
        return this.sessionTrackingModes;
    }

    public void addSessionTrackingMode(String sessionTrackingMode) {
        this.sessionTrackingModes.add(SessionTrackingMode.valueOf(sessionTrackingMode));
    }
}

