/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import org.apache.tomcat.util.descriptor.web.WebRuleSet;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.digester.CallMethodRule;

final class LifecycleCallbackRule
extends CallMethodRule {
    private final boolean postConstruct;

    LifecycleCallbackRule(String methodName, int paramCount, boolean postConstruct) {
        super(methodName, paramCount);
        this.postConstruct = postConstruct;
    }

    @Override
    public void end(String namespace, String name2) throws Exception {
        Object[] params2 = (Object[])this.digester.peekParams();
        if (params2 != null && params2.length == 2) {
            WebXml webXml = (WebXml)this.digester.peek();
            if (this.postConstruct) {
                if (webXml.getPostConstructMethods().containsKey(params2[0])) {
                    throw new IllegalArgumentException(WebRuleSet.sm.getString("webRuleSet.postconstruct.duplicate", params2[0]));
                }
            } else if (webXml.getPreDestroyMethods().containsKey(params2[0])) {
                throw new IllegalArgumentException(WebRuleSet.sm.getString("webRuleSet.predestroy.duplicate", params2[0]));
            }
        }
        super.end(namespace, name2);
    }
}

