/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.util.ArrayList;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.CallMethodRule;
import org.xml.sax.SAXException;

final class CallMethodMultiRule
extends CallMethodRule {
    final int multiParamIndex;

    CallMethodMultiRule(String methodName, int paramCount, int multiParamIndex) {
        super(methodName, paramCount);
        this.multiParamIndex = multiParamIndex;
    }

    @Override
    public void end(String namespace, String name2) throws Exception {
        Object[] parameters2 = null;
        if (this.paramCount > 0) {
            parameters2 = (Object[])this.digester.popParams();
        } else {
            parameters2 = new Object[]{};
            super.end(namespace, name2);
        }
        ArrayList multiParams = (ArrayList)parameters2[this.multiParamIndex];
        Object[] paramValues = new Object[this.paramTypes.length];
        for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
            if (i2 == this.multiParamIndex) continue;
            paramValues[i2] = parameters2[i2] == null || parameters2[i2] instanceof String && !String.class.isAssignableFrom(this.paramTypes[i2]) ? IntrospectionUtils.convert((String)parameters2[i2], this.paramTypes[i2]) : parameters2[i2];
        }
        Object target2 = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target2 == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[CallMethodRule]{");
            sb.append("");
            sb.append("} Call target is null (");
            sb.append("targetOffset=");
            sb.append(this.targetOffset);
            sb.append(",stackdepth=");
            sb.append(this.digester.getCount());
            sb.append(')');
            throw new SAXException(sb.toString());
        }
        if (multiParams == null) {
            paramValues[this.multiParamIndex] = null;
            IntrospectionUtils.callMethodN(target2, this.methodName, paramValues, this.paramTypes);
            return;
        }
        for (Object param : multiParams) {
            paramValues[this.multiParamIndex] = param == null || param instanceof String && !String.class.isAssignableFrom(this.paramTypes[this.multiParamIndex]) ? IntrospectionUtils.convert((String)param, this.paramTypes[this.multiParamIndex]) : param;
            IntrospectionUtils.callMethodN(target2, this.methodName, paramValues, this.paramTypes);
            StringBuilder code = this.digester.getGeneratedCode();
            if (code == null) continue;
            code.append(this.digester.toVariableName(target2)).append('.').append(this.methodName);
            code.append('(');
            for (int i3 = 0; i3 < paramValues.length; ++i3) {
                if (i3 > 0) {
                    code.append(", ");
                }
                if (paramValues[i3] instanceof String) {
                    code.append("\"").append(paramValues[i3].toString()).append("\"");
                    continue;
                }
                code.append(this.digester.toVariableName(paramValues[i3]));
            }
            code.append(");");
            code.append(System.lineSeparator());
        }
    }
}

