/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorHandler
implements ErrorHandler {
    private static final StringManager sm = StringManager.getManager(Constants.PACKAGE_NAME);
    private final List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private final List<SAXParseException> warnings = new ArrayList<SAXParseException>();

    @Override
    public void error(SAXParseException exception2) throws SAXException {
        this.errors.add(exception2);
    }

    @Override
    public void fatalError(SAXParseException exception2) throws SAXException {
        throw exception2;
    }

    @Override
    public void warning(SAXParseException exception2) throws SAXException {
        this.warnings.add(exception2);
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public void logFindings(Log log3, String source2) {
        for (SAXParseException e : this.getWarnings()) {
            log3.warn(sm.getString("xmlErrorHandler.warning", e.getMessage(), source2));
        }
        for (SAXParseException e : this.getErrors()) {
            log3.warn(sm.getString("xmlErrorHandler.error", e.getMessage(), source2));
        }
    }
}

