/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public final class StringUtils {
    private static final String EMPTY_STRING = "";

    private StringUtils() {
    }

    public static String join(String a, String b2) {
        return StringUtils.join(new String[]{a, b2});
    }

    public static String join(String[] array2) {
        if (array2 == null) {
            return EMPTY_STRING;
        }
        return StringUtils.join(Arrays.asList(array2));
    }

    public static void join(String[] array2, char separator, StringBuilder sb) {
        if (array2 == null) {
            return;
        }
        StringUtils.join(Arrays.asList(array2), separator, sb);
    }

    public static String join(Collection<String> collection) {
        return StringUtils.join(collection, ',');
    }

    public static String join(Collection<String> collection, char separator) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder result2 = new StringBuilder();
        StringUtils.join(collection, separator, result2);
        return result2.toString();
    }

    public static void join(Iterable<String> iterable, char separator, StringBuilder sb) {
        StringUtils.join(iterable, separator, (T x) -> x, sb);
    }

    public static <T> void join(T[] array2, char separator, Function<T, String> function, StringBuilder sb) {
        if (array2 == null) {
            return;
        }
        StringUtils.join(Arrays.asList(array2), separator, function, sb);
    }

    public static <T> void join(Iterable<T> iterable, char separator, Function<T, String> function, StringBuilder sb) {
        if (iterable == null) {
            return;
        }
        boolean first2 = true;
        for (T value2 : iterable) {
            if (first2) {
                first2 = false;
            } else {
                sb.append(separator);
            }
            sb.append(function.apply(value2));
        }
    }

    public static String[] splitCommaSeparated(String s2) {
        if (s2 == null || s2.length() == 0) {
            return new String[0];
        }
        String[] splits = s2.split(",");
        for (int i2 = 0; i2 < splits.length; ++i2) {
            splits[i2] = splits[i2].trim();
        }
        return splits;
    }
}

