/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.res.StringManager;

public class StringCache {
    private static final Log log = LogFactory.getLog(StringCache.class);
    private static final StringManager sm = StringManager.getManager(StringCache.class);
    protected static boolean byteEnabled = Boolean.getBoolean("tomcat.util.buf.StringCache.byte.enabled");
    protected static boolean charEnabled = Boolean.getBoolean("tomcat.util.buf.StringCache.char.enabled");
    protected static int trainThreshold = Integer.getInteger("tomcat.util.buf.StringCache.trainThreshold", 20000);
    protected static int cacheSize = Integer.getInteger("tomcat.util.buf.StringCache.cacheSize", 200);
    protected static final int maxStringSize = Integer.getInteger("tomcat.util.buf.StringCache.maxStringSize", 128);
    protected static final HashMap<ByteEntry, int[]> bcStats = new HashMap(cacheSize);
    protected static int bcCount = 0;
    protected static volatile ByteEntry[] bcCache = null;
    protected static final HashMap<CharEntry, int[]> ccStats = new HashMap(cacheSize);
    protected static int ccCount = 0;
    protected static volatile CharEntry[] ccCache = null;
    protected static int accessCount = 0;
    protected static int hitCount = 0;

    public int getCacheSize() {
        return cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        StringCache.cacheSize = cacheSize;
    }

    public boolean getByteEnabled() {
        return byteEnabled;
    }

    public void setByteEnabled(boolean byteEnabled) {
        StringCache.byteEnabled = byteEnabled;
    }

    public boolean getCharEnabled() {
        return charEnabled;
    }

    public void setCharEnabled(boolean charEnabled) {
        StringCache.charEnabled = charEnabled;
    }

    public int getTrainThreshold() {
        return trainThreshold;
    }

    public void setTrainThreshold(int trainThreshold) {
        StringCache.trainThreshold = trainThreshold;
    }

    public int getAccessCount() {
        return accessCount;
    }

    public int getHitCount() {
        return hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        hitCount = 0;
        accessCount = 0;
        HashMap<Object, int[]> hashMap = bcStats;
        synchronized (hashMap) {
            bcCache = null;
            bcCount = 0;
        }
        hashMap = ccStats;
        synchronized (hashMap) {
            ccCache = null;
            ccCount = 0;
        }
    }

    public static String toString(ByteChunk bc) {
        try {
            return StringCache.toString(bc, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ByteChunk bc, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) throws CharacterCodingException {
        if (bcCache == null) {
            String value2 = bc.toStringInternal(malformedInputAction, unmappableCharacterAction);
            if (byteEnabled && value2.length() < maxStringSize) {
                HashMap<ByteEntry, int[]> hashMap = bcStats;
                synchronized (hashMap) {
                    if (bcCache != null) {
                        return value2;
                    }
                    if (bcCount > trainThreshold) {
                        long t1 = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList> tempMap = new TreeMap<Integer, ArrayList>();
                        for (Map.Entry<ByteEntry, int[]> item : bcStats.entrySet()) {
                            ByteEntry entry = item.getKey();
                            int[] countA = item.getValue();
                            Integer count2 = countA[0];
                            tempMap.computeIfAbsent(count2, k -> new ArrayList()).add(entry);
                        }
                        int size2 = bcStats.size();
                        if (size2 > cacheSize) {
                            size2 = cacheSize;
                        }
                        ByteEntry[] tempbcCache = new ByteEntry[size2];
                        ByteChunk tempChunk = new ByteChunk();
                        int n = 0;
                        while (n < size2) {
                            Object key2 = tempMap.lastKey();
                            ArrayList list2 = (ArrayList)tempMap.get(key2);
                            for (int i2 = 0; i2 < list2.size() && n < size2; ++n, ++i2) {
                                ByteEntry entry = (ByteEntry)list2.get(i2);
                                tempChunk.setBytes(entry.name, 0, entry.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempbcCache, n);
                                if (insertPos == n) {
                                    tempbcCache[n + 1] = entry;
                                    continue;
                                }
                                System.arraycopy(tempbcCache, insertPos + 1, tempbcCache, insertPos + 2, n - insertPos - 1);
                                tempbcCache[insertPos + 1] = entry;
                            }
                            tempMap.remove(key2);
                        }
                        bcCount = 0;
                        bcStats.clear();
                        bcCache = tempbcCache;
                        if (log.isDebugEnabled()) {
                            long t2 = System.currentTimeMillis();
                            log.debug(sm.getString("stringCache.byteTime", t2 - t1));
                        }
                    } else {
                        ++bcCount;
                        ByteEntry entry = new ByteEntry();
                        entry.value = value2;
                        int[] count3 = bcStats.get(entry);
                        if (count3 == null) {
                            int end2 = bc.getEnd();
                            int start2 = bc.getStart();
                            entry.name = new byte[bc.getLength()];
                            System.arraycopy(bc.getBuffer(), start2, entry.name, 0, end2 - start2);
                            entry.charset = bc.getCharset();
                            entry.malformedInputAction = malformedInputAction;
                            entry.unmappableCharacterAction = unmappableCharacterAction;
                            count3 = new int[]{1};
                            bcStats.put(entry, count3);
                        } else {
                            count3[0] = count3[0] + 1;
                        }
                    }
                }
            }
            return value2;
        }
        ++accessCount;
        String result2 = StringCache.find(bc, malformedInputAction, unmappableCharacterAction);
        if (result2 == null) {
            return bc.toStringInternal(malformedInputAction, unmappableCharacterAction);
        }
        ++hitCount;
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(CharChunk cc) {
        if (ccCache == null) {
            String value2 = cc.toStringInternal();
            if (charEnabled && value2.length() < maxStringSize) {
                HashMap<CharEntry, int[]> hashMap = ccStats;
                synchronized (hashMap) {
                    if (ccCache != null) {
                        return value2;
                    }
                    if (ccCount > trainThreshold) {
                        ArrayList list2;
                        long t1 = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList> tempMap = new TreeMap<Integer, ArrayList>();
                        for (Map.Entry<CharEntry, int[]> item : ccStats.entrySet()) {
                            CharEntry entry = item.getKey();
                            int[] countA = item.getValue();
                            Integer count2 = countA[0];
                            list2 = tempMap.computeIfAbsent(count2, k -> new ArrayList());
                            list2.add(entry);
                        }
                        int size2 = ccStats.size();
                        if (size2 > cacheSize) {
                            size2 = cacheSize;
                        }
                        CharEntry[] tempccCache = new CharEntry[size2];
                        CharChunk tempChunk = new CharChunk();
                        int n = 0;
                        while (n < size2) {
                            Object key2 = tempMap.lastKey();
                            list2 = (ArrayList)tempMap.get(key2);
                            for (int i2 = 0; i2 < list2.size() && n < size2; ++n, ++i2) {
                                CharEntry entry = (CharEntry)list2.get(i2);
                                tempChunk.setChars(entry.name, 0, entry.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempccCache, n);
                                if (insertPos == n) {
                                    tempccCache[n + 1] = entry;
                                    continue;
                                }
                                System.arraycopy(tempccCache, insertPos + 1, tempccCache, insertPos + 2, n - insertPos - 1);
                                tempccCache[insertPos + 1] = entry;
                            }
                            tempMap.remove(key2);
                        }
                        ccCount = 0;
                        ccStats.clear();
                        ccCache = tempccCache;
                        if (log.isDebugEnabled()) {
                            long t2 = System.currentTimeMillis();
                            log.debug(sm.getString("stringCache.charTime", t2 - t1));
                        }
                    } else {
                        ++ccCount;
                        CharEntry entry = new CharEntry();
                        entry.value = value2;
                        int[] count3 = ccStats.get(entry);
                        if (count3 == null) {
                            int end2 = cc.getEnd();
                            int start2 = cc.getStart();
                            entry.name = new char[cc.getLength()];
                            System.arraycopy(cc.getBuffer(), start2, entry.name, 0, end2 - start2);
                            count3 = new int[]{1};
                            ccStats.put(entry, count3);
                        } else {
                            count3[0] = count3[0] + 1;
                        }
                    }
                }
            }
            return value2;
        }
        ++accessCount;
        String result2 = StringCache.find(cc);
        if (result2 == null) {
            return cc.toStringInternal();
        }
        ++hitCount;
        return result2;
    }

    protected static final int compare(ByteChunk name2, byte[] compareTo) {
        int len;
        int result2 = 0;
        byte[] b2 = name2.getBuffer();
        int start2 = name2.getStart();
        int end2 = name2.getEnd();
        if (end2 - start2 < (len = compareTo.length)) {
            len = end2 - start2;
        }
        for (int i2 = 0; i2 < len && result2 == 0; ++i2) {
            if (b2[i2 + start2] > compareTo[i2]) {
                result2 = 1;
                continue;
            }
            if (b2[i2 + start2] >= compareTo[i2]) continue;
            result2 = -1;
        }
        if (result2 == 0) {
            if (compareTo.length > end2 - start2) {
                result2 = -1;
            } else if (compareTo.length < end2 - start2) {
                result2 = 1;
            }
        }
        return result2;
    }

    @Deprecated
    protected static final String find(ByteChunk name2) {
        return StringCache.find(name2, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
    }

    protected static final String find(ByteChunk name2, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        int pos2 = StringCache.findClosest(name2, bcCache, bcCache.length);
        if (!(pos2 >= 0 && StringCache.compare(name2, StringCache.bcCache[pos2].name) == 0 && name2.getCharset().equals(StringCache.bcCache[pos2].charset) && malformedInputAction.equals(StringCache.bcCache[pos2].malformedInputAction) && unmappableCharacterAction.equals(StringCache.bcCache[pos2].unmappableCharacterAction))) {
            return null;
        }
        return StringCache.bcCache[pos2].value;
    }

    protected static final int findClosest(ByteChunk name2, ByteEntry[] array2, int len) {
        int a = 0;
        int b2 = len - 1;
        if (b2 == -1) {
            return -1;
        }
        if (StringCache.compare(name2, array2[0].name) < 0) {
            return -1;
        }
        if (b2 == 0) {
            return 0;
        }
        int i2 = 0;
        do {
            i2 = b2 + a >>> 1;
            int result2 = StringCache.compare(name2, array2[i2].name);
            if (result2 == 1) {
                a = i2;
                continue;
            }
            if (result2 == 0) {
                return i2;
            }
            b2 = i2;
        } while (b2 - a != 1);
        int result2 = StringCache.compare(name2, array2[b2].name);
        if (result2 < 0) {
            return a;
        }
        return b2;
    }

    protected static final int compare(CharChunk name2, char[] compareTo) {
        int len;
        int result2 = 0;
        char[] c = name2.getBuffer();
        int start2 = name2.getStart();
        int end2 = name2.getEnd();
        if (end2 - start2 < (len = compareTo.length)) {
            len = end2 - start2;
        }
        for (int i2 = 0; i2 < len && result2 == 0; ++i2) {
            if (c[i2 + start2] > compareTo[i2]) {
                result2 = 1;
                continue;
            }
            if (c[i2 + start2] >= compareTo[i2]) continue;
            result2 = -1;
        }
        if (result2 == 0) {
            if (compareTo.length > end2 - start2) {
                result2 = -1;
            } else if (compareTo.length < end2 - start2) {
                result2 = 1;
            }
        }
        return result2;
    }

    protected static final String find(CharChunk name2) {
        int pos2 = StringCache.findClosest(name2, ccCache, ccCache.length);
        if (pos2 < 0 || StringCache.compare(name2, StringCache.ccCache[pos2].name) != 0) {
            return null;
        }
        return StringCache.ccCache[pos2].value;
    }

    protected static final int findClosest(CharChunk name2, CharEntry[] array2, int len) {
        int a = 0;
        int b2 = len - 1;
        if (b2 == -1) {
            return -1;
        }
        if (StringCache.compare(name2, array2[0].name) < 0) {
            return -1;
        }
        if (b2 == 0) {
            return 0;
        }
        int i2 = 0;
        do {
            i2 = b2 + a >>> 1;
            int result2 = StringCache.compare(name2, array2[i2].name);
            if (result2 == 1) {
                a = i2;
                continue;
            }
            if (result2 == 0) {
                return i2;
            }
            b2 = i2;
        } while (b2 - a != 1);
        int result2 = StringCache.compare(name2, array2[b2].name);
        if (result2 < 0) {
            return a;
        }
        return b2;
    }

    private static class ByteEntry {
        private byte[] name = null;
        private Charset charset = null;
        private CodingErrorAction malformedInputAction = null;
        private CodingErrorAction unmappableCharacterAction = null;
        private String value = null;

        private ByteEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.malformedInputAction, this.unmappableCharacterAction, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteEntry other = (ByteEntry)obj;
            return Objects.equals(this.malformedInputAction, other.malformedInputAction) && Objects.equals(this.unmappableCharacterAction, other.unmappableCharacterAction) && Objects.equals(this.value, other.value);
        }
    }

    private static class CharEntry {
        private char[] name = null;
        private String value = null;

        private CharEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CharEntry) {
                return this.value.equals(((CharEntry)obj).value);
            }
            return false;
        }
    }
}

