/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

public class Asn1Writer {
    public static byte[] writeSequence(byte[] ... components) {
        int len = 0;
        for (byte[] component : components) {
            len += component.length;
        }
        byte[] combined = new byte[len];
        int pos2 = 0;
        for (byte[] component : components) {
            System.arraycopy(component, 0, combined, pos2, component.length);
            pos2 += component.length;
        }
        return Asn1Writer.writeTag((byte)48, combined);
    }

    public static byte[] writeInteger(int value2) {
        int valueSize = 1;
        while (value2 >> valueSize * 8 > 0) {
            ++valueSize;
        }
        byte[] valueBytes = new byte[valueSize];
        int i2 = 0;
        while (valueSize > 0) {
            valueBytes[i2] = (byte)(value2 >> 8 * (valueSize - 1));
            value2 >>= 8;
            --valueSize;
            ++i2;
        }
        return Asn1Writer.writeTag((byte)2, valueBytes);
    }

    public static byte[] writeOctetString(byte[] data2) {
        return Asn1Writer.writeTag((byte)4, data2);
    }

    public static byte[] writeTag(byte tagId, byte[] data2) {
        int dataSize = data2.length;
        int lengthSize = 1;
        if (dataSize > 127) {
            while (dataSize >> ++lengthSize * 8 > 0) {
            }
        }
        byte[] result2 = new byte[1 + lengthSize + dataSize];
        result2[0] = tagId;
        if (dataSize < 128) {
            result2[1] = (byte)dataSize;
        } else {
            result2[1] = (byte)(127 + lengthSize);
            int i2 = lengthSize;
            while (dataSize > 0) {
                result2[i2] = (byte)(dataSize & 0xFF);
                dataSize >>= 8;
                --i2;
            }
        }
        System.arraycopy(data2, 0, result2, 1 + lengthSize, data2.length);
        return result2;
    }
}

