/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.XReflectionIntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class IntrospectionUtils {
    private static final Log log = LogFactory.getLog(IntrospectionUtils.class);
    private static final StringManager sm = StringManager.getManager(IntrospectionUtils.class);
    private static final Map<Class<?>, Method[]> objectMethods = new ConcurrentHashMap();

    public static boolean setProperty(Object o, String name2, String value2) {
        return IntrospectionUtils.setProperty(o, name2, value2, true, null);
    }

    public static boolean setProperty(Object o, String name2, String value2, boolean invokeSetProperty) {
        return IntrospectionUtils.setProperty(o, name2, value2, invokeSetProperty, null);
    }

    public static boolean setProperty(Object o, String name2, String value2, boolean invokeSetProperty, StringBuilder actualMethod) {
        if (log.isTraceEnabled()) {
            log.trace("IntrospectionUtils: setProperty(" + String.valueOf(o.getClass()) + " " + name2 + "=" + value2 + ")");
        }
        if (actualMethod == null && XReflectionIntrospectionUtils.isEnabled()) {
            return XReflectionIntrospectionUtils.setPropertyInternal(o, name2, value2, invokeSetProperty);
        }
        String setter = "set" + IntrospectionUtils.capitalize(name2);
        try {
            Method[] methods2 = IntrospectionUtils.findMethods(o.getClass());
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (Method item : methods2) {
                Class<?>[] paramT = item.getParameterTypes();
                if (!setter.equals(item.getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                item.invoke(o, value2);
                if (actualMethod != null) {
                    actualMethod.append(item.getName()).append("(\"").append(IntrospectionUtils.escape(value2)).append("\")");
                }
                return true;
            }
            for (Method method2 : methods2) {
                boolean ok = true;
                if (setter.equals(method2.getName()) && method2.getParameterTypes().length == 1) {
                    Class<?> paramType = method2.getParameterTypes()[0];
                    Object[] params2 = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params2[0] = Integer.valueOf(value2);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                        if (actualMethod != null) {
                            actualMethod.append(method2.getName()).append("(Integer.valueOf(\"").append(value2).append("\"))");
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params2[0] = Long.valueOf(value2);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                        if (actualMethod != null) {
                            actualMethod.append(method2.getName()).append("(Long.valueOf(\"").append(value2).append("\"))");
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params2[0] = Boolean.valueOf(value2);
                        if (actualMethod != null) {
                            actualMethod.append(method2.getName()).append("(Boolean.valueOf(\"").append(value2).append("\"))");
                        }
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params2[0] = InetAddress.getByName(value2);
                        }
                        catch (UnknownHostException exc) {
                            if (log.isDebugEnabled()) {
                                log.debug(sm.getString("introspectionUtils.hostResolutionFail", value2));
                            }
                            ok = false;
                        }
                        if (actualMethod != null) {
                            actualMethod.append(method2.getName()).append("(InetAddress.getByName(\"").append(value2).append("\"))");
                        }
                    } else if (log.isTraceEnabled()) {
                        log.trace("IntrospectionUtils: Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        method2.invoke(o, params2);
                        return true;
                    }
                }
                if (!"setProperty".equals(method2.getName())) continue;
                if (method2.getReturnType() == Boolean.TYPE) {
                    setPropertyMethodBool = method2;
                    continue;
                }
                setPropertyMethodVoid = method2;
            }
            if (invokeSetProperty && (setPropertyMethodBool != null || setPropertyMethodVoid != null)) {
                if (actualMethod != null) {
                    actualMethod.append("setProperty(\"").append(name2).append("\", \"").append(IntrospectionUtils.escape(value2)).append("\")");
                }
                Object[] params3 = new Object[]{name2, value2};
                if (setPropertyMethodBool != null) {
                    try {
                        return (Boolean)setPropertyMethodBool.invoke(o, params3);
                    }
                    catch (IllegalArgumentException biae) {
                        if (setPropertyMethodVoid != null) {
                            setPropertyMethodVoid.invoke(o, params3);
                            return true;
                        }
                        throw biae;
                    }
                }
                setPropertyMethodVoid.invoke(o, params3);
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            log.warn(sm.getString("introspectionUtils.setPropertyError", name2, value2, o.getClass()), e);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.handleThrowable(e.getCause());
            log.warn(sm.getString("introspectionUtils.setPropertyError", name2, value2, o.getClass()), e);
        }
        return false;
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            if (c == '\"') {
                b2.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                b2.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                b2.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b2.append('\\').append('r');
                continue;
            }
            b2.append(c);
        }
        return b2.toString();
    }

    public static Object getProperty(Object o, String name2) {
        if (XReflectionIntrospectionUtils.isEnabled()) {
            return XReflectionIntrospectionUtils.getPropertyInternal(o, name2);
        }
        String getter = "get" + IntrospectionUtils.capitalize(name2);
        String isGetter = "is" + IntrospectionUtils.capitalize(name2);
        try {
            Method[] methods2 = IntrospectionUtils.findMethods(o.getClass());
            Method getPropertyMethod = null;
            for (Method method2 : methods2) {
                Class<?>[] paramT = method2.getParameterTypes();
                if (getter.equals(method2.getName()) && paramT.length == 0) {
                    return method2.invoke(o, (Object[])null);
                }
                if (isGetter.equals(method2.getName()) && paramT.length == 0) {
                    return method2.invoke(o, (Object[])null);
                }
                if (!"getProperty".equals(method2.getName())) continue;
                getPropertyMethod = method2;
            }
            if (getPropertyMethod != null) {
                Object[] params2 = new Object[]{name2};
                return getPropertyMethod.invoke(o, params2);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            log.warn(sm.getString("introspectionUtils.getPropertyError", name2, o.getClass()), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof NullPointerException) {
                return null;
            }
            ExceptionUtils.handleThrowable(e.getCause());
            log.warn(sm.getString("introspectionUtils.getPropertyError", name2, o.getClass()), e);
        }
        return null;
    }

    public static String replaceProperties(String value2, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp, ClassLoader classLoader) {
        return IntrospectionUtils.replaceProperties(value2, staticProp, dynamicProp, classLoader, 0);
    }

    private static String replaceProperties(String value2, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp, ClassLoader classLoader, int iterationCount) {
        String newval;
        int pos2;
        if (value2 == null || value2.indexOf("${") < 0) {
            return value2;
        }
        if (iterationCount >= 20) {
            log.warn(sm.getString("introspectionUtils.tooManyIterations", value2));
            return value2;
        }
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        while ((pos2 = value2.indexOf(36, prev)) >= 0) {
            if (pos2 > 0) {
                sb.append(value2.substring(prev, pos2));
            }
            if (pos2 == value2.length() - 1) {
                sb.append('$');
                prev = pos2 + 1;
                continue;
            }
            if (value2.charAt(pos2 + 1) != '{') {
                sb.append('$');
                prev = pos2 + 1;
                continue;
            }
            int endName = value2.indexOf(125, pos2);
            if (endName < 0) {
                sb.append(value2.substring(pos2));
                prev = value2.length();
                continue;
            }
            String n = value2.substring(pos2 + 2, endName);
            Object v = IntrospectionUtils.getProperty(n, staticProp, dynamicProp, classLoader);
            if (v == null) {
                int col = n.indexOf(":-");
                if (col != -1) {
                    String dV = n.substring(col + 2);
                    v = IntrospectionUtils.getProperty(n = n.substring(0, col), staticProp, dynamicProp, classLoader);
                    if (v == null) {
                        v = dV;
                    }
                } else {
                    v = "${" + n + "}";
                }
            }
            sb.append((String)v);
            prev = endName + 1;
        }
        if (prev < value2.length()) {
            sb.append(value2.substring(prev));
        }
        if ((newval = sb.toString()).indexOf("${") < 0) {
            return newval;
        }
        if (newval.equals(value2)) {
            return value2;
        }
        if (log.isTraceEnabled()) {
            log.trace("IntrospectionUtils.replaceProperties iter on: " + newval);
        }
        return IntrospectionUtils.replaceProperties(newval, staticProp, dynamicProp, classLoader, iterationCount + 1);
    }

    private static String getProperty(String name2, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp, ClassLoader classLoader) {
        String v = null;
        if (staticProp != null) {
            v = (String)staticProp.get(name2);
        }
        if (v == null && dynamicProp != null) {
            PropertySource propertySource;
            PropertySource[] propertySourceArray = dynamicProp;
            int n = propertySourceArray.length;
            for (int j = 0; j < n && (v = (propertySource = propertySourceArray[j]) instanceof SecurePropertySource ? ((SecurePropertySource)propertySource).getProperty(name2, classLoader) : propertySource.getProperty(name2)) == null; ++j) {
            }
        }
        return v;
    }

    public static String capitalize(String name2) {
        if (name2 == null || name2.length() == 0) {
            return name2;
        }
        char[] chars2 = name2.toCharArray();
        chars2[0] = Character.toUpperCase(chars2[0]);
        return new String(chars2);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> c) {
        Method[] methods2 = objectMethods.get(c);
        if (methods2 != null) {
            return methods2;
        }
        methods2 = c.getMethods();
        objectMethods.put(c, methods2);
        return methods2;
    }

    public static Method findMethod(Class<?> c, String name2, Class<?>[] params2) {
        Method[] methods2;
        for (Method method2 : methods2 = IntrospectionUtils.findMethods(c)) {
            if (!method2.getName().equals(name2)) continue;
            Class<?>[] methodParams = method2.getParameterTypes();
            if (params2 == null) {
                if (methodParams.length != 0) continue;
                return method2;
            }
            if (params2.length != methodParams.length) continue;
            boolean found = true;
            for (int j = 0; j < params2.length; ++j) {
                if (params2[j] == methodParams[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method2;
        }
        return null;
    }

    public static Object callMethod1(Object target2, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target2 == null || methodN == null || param1 == null) {
            throw new IllegalArgumentException(sm.getString("introspectionUtils.nullParameter"));
        }
        if (log.isTraceEnabled()) {
            log.trace("IntrospectionUtils: callMethod1 " + target2.getClass().getName() + " " + param1.getClass().getName() + " " + typeParam1);
        }
        Class[] params2 = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target2.getClass(), methodN, params2);
        if (m == null) {
            throw new NoSuchMethodException(sm.getString("introspectionUtils.noMethod", methodN, target2, target2.getClass()));
        }
        try {
            return m.invoke(target2, param1);
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    public static Object callMethodN(Object target2, String methodN, Object[] params2, Class<?>[] typeParams) throws Exception {
        Method m = null;
        m = IntrospectionUtils.findMethod(target2.getClass(), methodN, typeParams);
        if (m == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("introspectionUtils.noMethod", methodN, target2, target2.getClass()));
            }
            return null;
        }
        try {
            Object o = m.invoke(target2, params2);
            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(target2.getClass().getName()).append('.').append(methodN).append('(');
                for (int i2 = 0; i2 < params2.length; ++i2) {
                    if (i2 > 0) {
                        sb.append(", ");
                    }
                    sb.append(params2[i2]);
                }
                sb.append(')');
                log.trace("IntrospectionUtils:" + sb.toString());
            }
            return o;
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    public static Object convert(String object, Class<?> paramType) {
        Object result2 = null;
        if ("java.lang.String".equals(paramType.getName())) {
            result2 = object;
        } else if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
            try {
                result2 = Integer.valueOf(object);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
            result2 = Boolean.valueOf(object);
        } else if ("java.net.InetAddress".equals(paramType.getName())) {
            try {
                result2 = InetAddress.getByName(object);
            }
            catch (UnknownHostException exc) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("introspectionUtils.hostResolutionFail", object));
                }
            }
        } else if (log.isTraceEnabled()) {
            log.trace("IntrospectionUtils: Unknown type " + paramType.getName());
        }
        if (result2 == null) {
            throw new IllegalArgumentException(sm.getString("introspectionUtils.conversionError", object, paramType.getName()));
        }
        return result2;
    }

    public static boolean isInstance(Class<?> clazz, String type2) {
        Class<?>[] ifaces;
        if (type2.equals(clazz.getName())) {
            return true;
        }
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            if (!IntrospectionUtils.isInstance(iface, type2)) continue;
            return true;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return false;
        }
        return IntrospectionUtils.isInstance(superClazz, type2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }

    public static interface SecurePropertySource
    extends PropertySource {
        public String getProperty(String var1, ClassLoader var2);
    }
}

