/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

import java.io.File;
import org.apache.tomcat.jni.LibraryNotFoundError;

public final class Library {
    private static final String[] NAMES = new String[]{"tcnative-2", "libtcnative-2", "tcnative-1", "libtcnative-1"};
    private static final String CATALINA_HOME_PROP = "catalina.home";
    private static Library _instance = null;
    public static int TCN_MAJOR_VERSION = 0;
    public static int TCN_MINOR_VERSION = 0;
    public static int TCN_PATCH_VERSION = 0;
    public static int TCN_IS_DEV_VERSION = 0;
    public static int APR_MAJOR_VERSION = 0;
    public static int APR_MINOR_VERSION = 0;
    public static int APR_PATCH_VERSION = 0;
    public static int APR_IS_DEV_VERSION = 0;

    private Library() throws Exception {
        boolean loaded = false;
        StringBuilder err = new StringBuilder();
        File binLib = new File(System.getProperty(CATALINA_HOME_PROP), "bin");
        for (int i2 = 0; i2 < NAMES.length; ++i2) {
            File library2 = new File(binLib, System.mapLibraryName(NAMES[i2]));
            try {
                System.load(library2.getAbsolutePath());
                loaded = true;
            }
            catch (ThreadDeath | VirtualMachineError t) {
                throw t;
            }
            catch (Throwable t) {
                if (library2.exists()) {
                    throw t;
                }
                if (i2 > 0) {
                    err.append(", ");
                }
                err.append(t.getMessage());
            }
            if (loaded) break;
        }
        if (!loaded) {
            String path2 = System.getProperty("java.library.path");
            String[] paths = path2.split(File.pathSeparator);
            String[] stringArray = NAMES;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String value2 = stringArray[j];
                try {
                    System.loadLibrary(value2);
                    loaded = true;
                }
                catch (ThreadDeath | VirtualMachineError t) {
                    throw t;
                }
                catch (Throwable t) {
                    String name2 = System.mapLibraryName(value2);
                    for (String s2 : paths) {
                        File fd = new File(s2, name2);
                        if (!fd.exists()) continue;
                        throw t;
                    }
                    if (err.length() > 0) {
                        err.append(", ");
                    }
                    err.append(t.getMessage());
                }
                if (loaded) break;
            }
        }
        if (!loaded) {
            StringBuilder names2 = new StringBuilder();
            for (String name3 : NAMES) {
                names2.append(name3);
                names2.append(", ");
            }
            throw new LibraryNotFoundError(names2.substring(0, names2.length() - 2), err.toString());
        }
    }

    private Library(String libraryName) {
        System.loadLibrary(libraryName);
    }

    private static native boolean initialize();

    public static native void terminate();

    private static native int version(int var0);

    public static native String versionString();

    public static native String aprVersionString();

    public static synchronized boolean initialize(String libraryName) throws Exception {
        if (_instance == null) {
            _instance = libraryName == null ? new Library() : new Library(libraryName);
            TCN_MAJOR_VERSION = Library.version(1);
            TCN_MINOR_VERSION = Library.version(2);
            TCN_PATCH_VERSION = Library.version(3);
            TCN_IS_DEV_VERSION = Library.version(4);
            APR_MAJOR_VERSION = Library.version(17);
            APR_MINOR_VERSION = Library.version(18);
            APR_PATCH_VERSION = Library.version(19);
            APR_IS_DEV_VERSION = Library.version(20);
            if (APR_MAJOR_VERSION < 1) {
                throw new UnsatisfiedLinkError("Unsupported APR Version (" + Library.aprVersionString() + ")");
            }
        }
        return Library.initialize();
    }
}

