/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MailSessionFactory
implements ObjectFactory {
    protected static final String factoryType = "jakarta.mail.Session";

    @Override
    public Object getObjectInstance(Object refObj, Name name2, Context context, Hashtable<?, ?> env) throws Exception {
        Reference ref = (Reference)refObj;
        if (!ref.getClassName().equals(factoryType)) {
            return null;
        }
        return AccessController.doPrivileged(() -> {
            Properties props = new Properties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.host", "localhost");
            String password = null;
            Enumeration<RefAddr> attrs = ref.getAll();
            while (attrs.hasMoreElements()) {
                RefAddr attr2 = attrs.nextElement();
                if ("factory".equals(attr2.getType())) continue;
                if ("password".equals(attr2.getType())) {
                    password = (String)attr2.getContent();
                    continue;
                }
                props.put(attr2.getType(), attr2.getContent());
            }
            Authenticator auth = null;
            if (password != null) {
                String user = props.getProperty("mail.smtp.user");
                if (user == null) {
                    user = props.getProperty("mail.user");
                }
                if (user != null) {
                    final PasswordAuthentication pa = new PasswordAuthentication(user, password);
                    auth = new Authenticator(this){
                        final /* synthetic */ MailSessionFactory this$0;
                        {
                            this.this$0 = this$0;
                        }

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return pa;
                        }
                    };
                }
            }
            Session session = Session.getInstance((Properties)props, auth);
            return session;
        });
    }
}

