/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.apache.naming.factory.ResourceLinkFactory;

public class DataSourceLinkFactory
extends ResourceLinkFactory {
    public static void setGlobalContext(Context newGlobalContext) {
        ResourceLinkFactory.setGlobalContext(newGlobalContext);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name2, Context nameCtx, Hashtable<?, ?> environment2) throws NamingException {
        Object result2 = super.getObjectInstance(obj, name2, nameCtx, environment2);
        if (result2 != null) {
            Reference ref = (Reference)obj;
            RefAddr userAttr = ref.get("username");
            RefAddr passAttr = ref.get("password");
            if (userAttr != null && passAttr != null && userAttr.getContent() != null && passAttr.getContent() != null) {
                result2 = this.wrapDataSource(result2, userAttr.getContent().toString(), passAttr.getContent().toString());
            }
        }
        return result2;
    }

    protected Object wrapDataSource(Object datasource, String username, String password) throws NamingException {
        try {
            DataSourceHandler handler = new DataSourceHandler((DataSource)datasource, username, password);
            return Proxy.newProxyInstance(datasource.getClass().getClassLoader(), datasource.getClass().getInterfaces(), (InvocationHandler)handler);
        }
        catch (Exception x) {
            if (x instanceof InvocationTargetException) {
                Throwable cause2 = x.getCause();
                if (cause2 instanceof ThreadDeath) {
                    throw (ThreadDeath)cause2;
                }
                if (cause2 instanceof VirtualMachineError) {
                    throw (VirtualMachineError)cause2;
                }
                if (cause2 instanceof Exception) {
                    x = (Exception)cause2;
                }
            }
            if (x instanceof NamingException) {
                throw (NamingException)x;
            }
            NamingException nx = new NamingException(x.getMessage());
            nx.initCause(x);
            throw nx;
        }
    }

    public static class DataSourceHandler
    implements InvocationHandler {
        private final DataSource ds;
        private final String username;
        private final String password;
        private final Method getConnection;

        public DataSourceHandler(DataSource ds, String username, String password) throws Exception {
            this.ds = ds;
            this.username = username;
            this.password = password;
            this.getConnection = ds.getClass().getMethod("getConnection", String.class, String.class);
        }

        @Override
        public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
            if ("getConnection".equals(method2.getName()) && (args2 == null || args2.length == 0)) {
                args2 = new String[]{this.username, this.password};
                method2 = this.getConnection;
            } else if ("unwrap".equals(method2.getName())) {
                return this.unwrap((Class)args2[0]);
            }
            try {
                return method2.invoke((Object)this.ds, args2);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    throw t.getCause();
                }
                throw t;
            }
        }

        public Object unwrap(Class<?> iface) throws SQLException {
            if (iface == DataSource.class) {
                return this.ds;
            }
            throw new SQLException(ResourceLinkFactory.sm.getString("dataSourceLinkFactory.badWrapper", iface.getName()));
        }
    }
}

