/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.naming.NamingContext;
import org.apache.naming.StringManager;

public class SelectorContext
implements Context {
    public static final String prefix = "java:";
    public static final int prefixLength = "java:".length();
    public static final String IC_PREFIX = "IC_";
    private static final Log log = LogFactory.getLog(SelectorContext.class);
    protected final Hashtable<String, Object> env;
    protected static final StringManager sm = StringManager.getManager(SelectorContext.class);
    protected final boolean initialContext;

    public SelectorContext(Hashtable<String, Object> env) {
        this.env = env;
        this.initialContext = false;
    }

    public SelectorContext(Hashtable<String, Object> env, boolean initialContext) {
        this.env = env;
        this.initialContext = initialContext;
    }

    @Override
    public Object lookup(Name name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingName", "lookup", name2));
        }
        return this.getBoundContext().lookup(this.parseName(name2));
    }

    @Override
    public Object lookup(String name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingString", "lookup", name2));
        }
        return this.getBoundContext().lookup(this.parseName(name2));
    }

    @Override
    public void bind(Name name2, Object obj) throws NamingException {
        this.getBoundContext().bind(this.parseName(name2), obj);
    }

    @Override
    public void bind(String name2, Object obj) throws NamingException {
        this.getBoundContext().bind(this.parseName(name2), obj);
    }

    @Override
    public void rebind(Name name2, Object obj) throws NamingException {
        this.getBoundContext().rebind(this.parseName(name2), obj);
    }

    @Override
    public void rebind(String name2, Object obj) throws NamingException {
        this.getBoundContext().rebind(this.parseName(name2), obj);
    }

    @Override
    public void unbind(Name name2) throws NamingException {
        this.getBoundContext().unbind(this.parseName(name2));
    }

    @Override
    public void unbind(String name2) throws NamingException {
        this.getBoundContext().unbind(this.parseName(name2));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.getBoundContext().rename(this.parseName(oldName), this.parseName(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.getBoundContext().rename(this.parseName(oldName), this.parseName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingName", "list", name2));
        }
        return this.getBoundContext().list(this.parseName(name2));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingString", "list", name2));
        }
        return this.getBoundContext().list(this.parseName(name2));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingName", "listBindings", name2));
        }
        return this.getBoundContext().listBindings(this.parseName(name2));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingString", "listBindings", name2));
        }
        return this.getBoundContext().listBindings(this.parseName(name2));
    }

    @Override
    public void destroySubcontext(Name name2) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(name2));
    }

    @Override
    public void destroySubcontext(String name2) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(name2));
    }

    @Override
    public Context createSubcontext(Name name2) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(name2));
    }

    @Override
    public Context createSubcontext(String name2) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(name2));
    }

    @Override
    public Object lookupLink(Name name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingName", "lookupLink", name2));
        }
        return this.getBoundContext().lookupLink(this.parseName(name2));
    }

    @Override
    public Object lookupLink(String name2) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("selectorContext.methodUsingString", "lookupLink", name2));
        }
        return this.getBoundContext().lookupLink(this.parseName(name2));
    }

    @Override
    public NameParser getNameParser(Name name2) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(name2));
    }

    @Override
    public NameParser getNameParser(String name2) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(name2));
    }

    @Override
    public Name composeName(Name name2, Name prefix) throws NamingException {
        Name prefixClone = (Name)prefix.clone();
        return prefixClone.addAll(name2);
    }

    @Override
    public String composeName(String name2, String prefix) throws NamingException {
        return prefix + "/" + name2;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.getBoundContext().addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.getBoundContext().removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.getBoundContext().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.getBoundContext().close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return prefix;
    }

    protected Context getBoundContext() throws NamingException {
        if (this.initialContext) {
            Object ICName = IC_PREFIX;
            if (ContextBindings.isThreadBound()) {
                ICName = (String)ICName + ContextBindings.getThreadName();
            } else if (ContextBindings.isClassLoaderBound()) {
                ICName = (String)ICName + ContextBindings.getClassLoaderName();
            }
            Context initialContext = ContextBindings.getContext(ICName);
            if (initialContext == null) {
                initialContext = new NamingContext(this.env, (String)ICName);
                ContextBindings.bindContext(ICName, initialContext);
            }
            return initialContext;
        }
        if (ContextBindings.isThreadBound()) {
            return ContextBindings.getThread();
        }
        return ContextBindings.getClassLoader();
    }

    protected String parseName(String name2) throws NamingException {
        if (!this.initialContext && name2.startsWith(prefix)) {
            return name2.substring(prefixLength);
        }
        if (this.initialContext) {
            return name2;
        }
        throw new NamingException(sm.getString("selectorContext.noJavaUrl"));
    }

    protected Name parseName(Name name2) throws NamingException {
        if (!this.initialContext && !name2.isEmpty() && name2.get(0).startsWith(prefix)) {
            if (name2.get(0).equals(prefix)) {
                return name2.getSuffix(1);
            }
            Name result2 = name2.getSuffix(1);
            result2.add(0, name2.get(0).substring(prefixLength));
            return result2;
        }
        if (this.initialContext) {
            return name2;
        }
        throw new NamingException(sm.getString("selectorContext.noJavaUrl"));
    }
}

