/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextAccessController;
import org.apache.naming.NameParserImpl;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.ResourceRef;
import org.apache.naming.StringManager;

public class NamingContext
implements Context {
    protected static final NameParser nameParser = new NameParserImpl();
    private static final Log log = LogFactory.getLog(NamingContext.class);
    protected final Hashtable<String, Object> env = new Hashtable();
    protected static final StringManager sm = StringManager.getManager(NamingContext.class);
    protected final HashMap<String, NamingEntry> bindings;
    protected final String name;
    private boolean exceptionOnFailedWrite = true;
    private static final boolean GRAAL;

    public NamingContext(Hashtable<String, Object> env, String name2) {
        this(env, name2, new HashMap<String, NamingEntry>());
    }

    public NamingContext(Hashtable<String, Object> env, String name2, HashMap<String, NamingEntry> bindings) {
        this.name = name2;
        if (env != null) {
            Enumeration<String> envEntries = env.keys();
            while (envEntries.hasMoreElements()) {
                String entryName = envEntries.nextElement();
                this.addToEnvironment(entryName, env.get(entryName));
            }
        }
        this.bindings = bindings;
    }

    public boolean getExceptionOnFailedWrite() {
        return this.exceptionOnFailedWrite;
    }

    public void setExceptionOnFailedWrite(boolean exceptionOnFailedWrite) {
        this.exceptionOnFailedWrite = exceptionOnFailedWrite;
    }

    @Override
    public Object lookup(Name name2) throws NamingException {
        return this.lookup(name2, true);
    }

    @Override
    public Object lookup(String name2) throws NamingException {
        return this.lookup(new CompositeName(name2), true);
    }

    @Override
    public void bind(Name name2, Object obj) throws NamingException {
        this.bind(name2, obj, false);
    }

    @Override
    public void bind(String name2, Object obj) throws NamingException {
        this.bind(new CompositeName(name2), obj);
    }

    @Override
    public void rebind(Name name2, Object obj) throws NamingException {
        this.bind(name2, obj, true);
    }

    @Override
    public void rebind(String name2, Object obj) throws NamingException {
        this.rebind(new CompositeName(name2), obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unbind(Name name2) throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            throw new NamingException(sm.getString("namingContext.invalidName"));
        }
        NamingEntry entry = this.bindings.get(name2.get(0));
        if (entry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name2, name2.get(0)));
        }
        if (name2.size() > 1) {
            if (entry.type != 10) throw new NamingException(sm.getString("namingContext.contextExpected"));
            ((Context)entry.value).unbind(name2.getSuffix(1));
            return;
        } else {
            this.bindings.remove(name2.get(0));
        }
    }

    @Override
    public void unbind(String name2) throws NamingException {
        this.unbind(new CompositeName(name2));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object value2 = this.lookup(oldName);
        this.bind(newName, value2);
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name2) throws NamingException {
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            return new NamingContextEnumeration(this.bindings.values().iterator());
        }
        NamingEntry entry = this.bindings.get(name2.get(0));
        if (entry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name2, name2.get(0)));
        }
        if (entry.type != 10) {
            throw new NamingException(sm.getString("namingContext.contextExpected"));
        }
        return ((Context)entry.value).list(name2.getSuffix(1));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name2) throws NamingException {
        return this.list(new CompositeName(name2));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name2) throws NamingException {
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.bindings.values().iterator(), this);
        }
        NamingEntry entry = this.bindings.get(name2.get(0));
        if (entry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name2, name2.get(0)));
        }
        if (entry.type != 10) {
            throw new NamingException(sm.getString("namingContext.contextExpected"));
        }
        return ((Context)entry.value).listBindings(name2.getSuffix(1));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name2) throws NamingException {
        return this.listBindings(new CompositeName(name2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroySubcontext(Name name2) throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            throw new NamingException(sm.getString("namingContext.invalidName"));
        }
        NamingEntry entry = this.bindings.get(name2.get(0));
        if (entry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name2, name2.get(0)));
        }
        if (name2.size() > 1) {
            if (entry.type != 10) throw new NamingException(sm.getString("namingContext.contextExpected"));
            ((Context)entry.value).destroySubcontext(name2.getSuffix(1));
            return;
        } else {
            if (entry.type != 10) throw new NotContextException(sm.getString("namingContext.contextExpected"));
            ((Context)entry.value).close();
            this.bindings.remove(name2.get(0));
        }
    }

    @Override
    public void destroySubcontext(String name2) throws NamingException {
        this.destroySubcontext(new CompositeName(name2));
    }

    @Override
    public Context createSubcontext(Name name2) throws NamingException {
        if (!this.checkWritable()) {
            return null;
        }
        NamingContext newContext = new NamingContext(this.env, this.name);
        this.bind(name2, (Object)newContext);
        newContext.setExceptionOnFailedWrite(this.getExceptionOnFailedWrite());
        return newContext;
    }

    @Override
    public Context createSubcontext(String name2) throws NamingException {
        return this.createSubcontext(new CompositeName(name2));
    }

    @Override
    public Object lookupLink(Name name2) throws NamingException {
        return this.lookup(name2, false);
    }

    @Override
    public Object lookupLink(String name2) throws NamingException {
        return this.lookup(new CompositeName(name2), false);
    }

    @Override
    public NameParser getNameParser(Name name2) throws NamingException {
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            return nameParser;
        }
        if (name2.size() > 1) {
            NamingEntry obj = this.bindings.get(name2.get(0));
            if (obj instanceof Context) {
                return ((Context)((Object)obj)).getNameParser(name2.getSuffix(1));
            }
            throw new NotContextException(sm.getString("namingContext.contextExpected"));
        }
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name2) throws NamingException {
        return this.getNameParser(new CompositeName(name2));
    }

    @Override
    public Name composeName(Name name2, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name2);
    }

    @Override
    public String composeName(String name2, String prefix) {
        return prefix + "/" + name2;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.env.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return this.env;
    }

    @Override
    public void close() throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        this.env.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException(sm.getString("namingContext.noAbsoluteName"));
    }

    protected Object lookup(Name name2, boolean resolveLinks) throws NamingException {
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            return new NamingContext(this.env, this.name, this.bindings);
        }
        NamingEntry entry = this.bindings.get(name2.get(0));
        if (entry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name2, name2.get(0)));
        }
        if (name2.size() > 1) {
            if (entry.type != 10) {
                throw new NamingException(sm.getString("namingContext.contextExpected"));
            }
            return ((Context)entry.value).lookup(name2.getSuffix(1));
        }
        if (resolveLinks && entry.type == 1) {
            String link2 = ((LinkRef)entry.value).getLinkName();
            if (link2.startsWith(".")) {
                return this.lookup(link2.substring(1));
            }
            return new InitialContext(this.env).lookup(link2);
        }
        if (entry.type == 2) {
            try {
                boolean singleton;
                Object obj = null;
                if (!GRAAL) {
                    obj = NamingManager.getObjectInstance(entry.value, name2, this, this.env);
                } else {
                    Reference reference2 = (Reference)entry.value;
                    String factoryClassName = reference2.getFactoryClassName();
                    if (factoryClassName != null) {
                        Class<?> factoryClass = this.getClass().getClassLoader().loadClass(factoryClassName);
                        ObjectFactory factory = (ObjectFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        obj = factory.getObjectInstance(entry.value, name2, this, this.env);
                    }
                }
                if (entry.value instanceof ResourceRef && (singleton = Boolean.parseBoolean((String)((ResourceRef)entry.value).get("singleton").getContent()))) {
                    entry.type = 0;
                    entry.value = obj;
                }
                if (obj == null) {
                    throw new NamingException(sm.getString("namingContext.failResolvingReference"));
                }
                return obj;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = sm.getString("namingContext.failResolvingReference");
                log.warn(msg, e);
                NamingException ne = new NamingException(msg);
                ne.initCause(e);
                throw ne;
            }
        }
        return entry.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bind(Name name2, Object obj, boolean rebind) throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        while (!name2.isEmpty() && name2.get(0).length() == 0) {
            name2 = name2.getSuffix(1);
        }
        if (name2.isEmpty()) {
            throw new NamingException(sm.getString("namingContext.invalidName"));
        }
        NamingEntry entry = this.bindings.get(name2.get(0));
        if (name2.size() > 1) {
            if (entry == null) {
                throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name2, name2.get(0)));
            }
            if (entry.type != 10) throw new NamingException(sm.getString("namingContext.contextExpected"));
            if (rebind) {
                ((Context)entry.value).rebind(name2.getSuffix(1), obj);
                return;
            } else {
                ((Context)entry.value).bind(name2.getSuffix(1), obj);
            }
            return;
        } else {
            if (!rebind && entry != null) {
                throw new NameAlreadyBoundException(sm.getString("namingContext.alreadyBound", name2.get(0)));
            }
            Object toBind = NamingManager.getStateToBind(obj, name2, this, this.env);
            if (toBind instanceof Context) {
                entry = new NamingEntry(name2.get(0), toBind, 10);
            } else if (toBind instanceof LinkRef) {
                entry = new NamingEntry(name2.get(0), toBind, 1);
            } else if (toBind instanceof Reference) {
                entry = new NamingEntry(name2.get(0), toBind, 2);
            } else if (toBind instanceof Referenceable) {
                toBind = ((Referenceable)toBind).getReference();
                entry = new NamingEntry(name2.get(0), toBind, 2);
            } else {
                entry = new NamingEntry(name2.get(0), toBind, 0);
            }
            this.bindings.put(name2.get(0), entry);
        }
    }

    protected boolean isWritable() {
        return ContextAccessController.isWritable(this.name);
    }

    protected boolean checkWritable() throws NamingException {
        if (this.isWritable()) {
            return true;
        }
        if (this.exceptionOnFailedWrite) {
            throw new OperationNotSupportedException(sm.getString("namingContext.readOnly"));
        }
        return false;
    }

    static {
        boolean result2 = false;
        try {
            Class<?> nativeImageClazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            result2 = Boolean.TRUE.equals(nativeImageClazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception2) {
            // empty catch block
        }
        GRAAL = result2 || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
    }
}

