/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContextAccessController {
    private static final Map<Object, Object> readOnlyContexts = new ConcurrentHashMap<Object, Object>();
    private static final Map<Object, Object> securityTokens = new ConcurrentHashMap<Object, Object>();

    public static void setSecurityToken(Object name2, Object token2) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(ContextAccessController.class.getName() + ".setSecurityToken"));
        }
        if (!securityTokens.containsKey(name2) && token2 != null) {
            securityTokens.put(name2, token2);
        }
    }

    public static void unsetSecurityToken(Object name2, Object token2) {
        if (ContextAccessController.checkSecurityToken(name2, token2)) {
            securityTokens.remove(name2);
        }
    }

    public static boolean checkSecurityToken(Object name2, Object token2) {
        Object refToken = securityTokens.get(name2);
        return refToken == null || refToken.equals(token2);
    }

    public static void setWritable(Object name2, Object token2) {
        if (ContextAccessController.checkSecurityToken(name2, token2)) {
            readOnlyContexts.remove(name2);
        }
    }

    public static void setReadOnly(Object name2) {
        readOnlyContexts.put(name2, name2);
    }

    public static boolean isWritable(Object name2) {
        return !readOnlyContexts.containsKey(name2);
    }
}

