/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util.internal;

import java.io.ObjectInputFilter;
import org.apache.logging.log4j.util.internal.SerializationUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultObjectInputFilter
implements ObjectInputFilter {
    private final ObjectInputFilter delegate;

    public DefaultObjectInputFilter() {
        this.delegate = null;
    }

    public DefaultObjectInputFilter(ObjectInputFilter filter2) {
        this.delegate = filter2;
    }

    public static DefaultObjectInputFilter newInstance(ObjectInputFilter filter2) {
        return new DefaultObjectInputFilter(filter2);
    }

    @Override
    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        ObjectInputFilter.Status status2;
        if (this.delegate != null && (status2 = this.delegate.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
            return status2;
        }
        ObjectInputFilter serialFilter = ObjectInputFilter.Config.getSerialFilter();
        if (serialFilter != null && (status2 = serialFilter.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
            return status2;
        }
        Class<?> serialClass = filterInfo.serialClass();
        if (serialClass != null) {
            String name2 = SerializationUtil.stripArray(serialClass);
            if (DefaultObjectInputFilter.isAllowedByDefault((String)name2)) {
                return ObjectInputFilter.Status.ALLOWED;
            }
        } else {
            return ObjectInputFilter.Status.ALLOWED;
        }
        return ObjectInputFilter.Status.REJECTED;
    }

    private static boolean isAllowedByDefault(String name2) {
        return DefaultObjectInputFilter.isRequiredPackage((String)name2) || SerializationUtil.REQUIRED_JAVA_CLASSES.contains(name2);
    }

    private static boolean isRequiredPackage(String name2) {
        for (String packageName : SerializationUtil.REQUIRED_JAVA_PACKAGES) {
            if (!name2.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

