/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;

@PerformanceSensitive(value={"allocation"})
public class Unbox {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int BITS_PER_INT = 32;
    private static final int RINGBUFFER_MIN_SIZE = 32;
    private static final int RINGBUFFER_SIZE = Unbox.calculateRingBufferSize("log4j.unbox.ringbuffer.size");
    private static final int MASK = RINGBUFFER_SIZE - 1;
    private static ThreadLocal<State> threadLocalState = new ThreadLocal();
    private static WebSafeState webSafeState = new WebSafeState();

    private Unbox() {
    }

    private static int calculateRingBufferSize(String propertyName) {
        String userPreferredRBSize = PropertiesUtil.getProperties().getStringProperty(propertyName, String.valueOf(32));
        try {
            int size2 = Integer.parseInt(userPreferredRBSize.trim());
            if (size2 < 32) {
                size2 = 32;
                LOGGER.warn("Invalid {} {}, using minimum size {}.", (Object)propertyName, (Object)userPreferredRBSize, (Object)32);
            }
            return Unbox.ceilingNextPowerOfTwo(size2);
        }
        catch (Exception ex) {
            LOGGER.warn("Invalid {} {}, using default size {}.", (Object)propertyName, (Object)userPreferredRBSize, (Object)32);
            return 32;
        }
    }

    private static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(float value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(double value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(short value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(int value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(char value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(long value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(byte value2) {
        return Unbox.getSB().append(value2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(boolean value2) {
        return Unbox.getSB().append(value2);
    }

    private static State getState() {
        State state2 = threadLocalState.get();
        if (state2 == null) {
            state2 = new State();
            threadLocalState.set(state2);
        }
        return state2;
    }

    private static StringBuilder getSB() {
        return Constants.ENABLE_THREADLOCALS ? Unbox.getState().getStringBuilder() : webSafeState.getStringBuilder();
    }

    static int getRingbufferSize() {
        return RINGBUFFER_SIZE;
    }

    private static class State {
        private final StringBuilder[] ringBuffer = new StringBuilder[Unbox.access$000()];
        private int current;

        State() {
            for (int i2 = 0; i2 < this.ringBuffer.length; ++i2) {
                this.ringBuffer[i2] = new StringBuilder(21);
            }
        }

        public StringBuilder getStringBuilder() {
            StringBuilder result2 = this.ringBuffer[MASK & this.current++];
            result2.setLength(0);
            return result2;
        }
    }

    private static class WebSafeState {
        private final ThreadLocal<StringBuilder[]> ringBuffer = new ThreadLocal();
        private final ThreadLocal<int[]> current = new ThreadLocal();

        private WebSafeState() {
        }

        public StringBuilder getStringBuilder() {
            StringBuilder[] array2 = this.ringBuffer.get();
            if (array2 == null) {
                array2 = new StringBuilder[RINGBUFFER_SIZE];
                for (int i2 = 0; i2 < array2.length; ++i2) {
                    array2[i2] = new StringBuilder(21);
                }
                this.ringBuffer.set(array2);
                this.current.set(new int[1]);
            }
            int[] index2 = this.current.get();
            int n = index2[0];
            index2[0] = n + 1;
            StringBuilder result2 = array2[MASK & n];
            result2.setLength(0);
            return result2;
        }
    }
}

