/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.SystemPropertiesPropertySource;

@InternalApi
public final class Strings {
    private static final int MAX_FORMAT_BUFFER_LENGTH = 518;
    private static final ThreadLocal<StringBuilder> FORMAT_BUFFER_REF = ThreadLocal.withInitial(StringBuilder::new);
    public static final String EMPTY = "";
    private static final String COMMA_DELIMITED_RE = "\\s*,\\s*";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String LINE_SEPARATOR = SystemPropertiesPropertySource.getSystemProperty("line.separator", "\n");

    public static String dquote(String str) {
        return '\"' + str + '\"';
    }

    public static boolean isBlank(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return true;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotBlank(String s2) {
        return !Strings.isBlank(s2);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Strings.isEmpty(cs);
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first2 = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first2, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first2 != null) {
            buf.append(first2);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String[] splitList(String string2) {
        return string2 != null ? string2.split(COMMA_DELIMITED_RE) : new String[]{};
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String quote(String str) {
        return '\'' + str + '\'';
    }

    public static String trimToNull(String str) {
        String ts = str == null ? null : str.trim();
        return Strings.isEmpty(ts) ? null : ts;
    }

    private Strings() {
    }

    public static String toRootLowerCase(String str) {
        return str.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String str) {
        return str.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String str1, String str2) {
        if (Strings.isEmpty(str1)) {
            return str2;
        }
        if (Strings.isEmpty(str2)) {
            return str1;
        }
        StringBuilder sb = FORMAT_BUFFER_REF.get();
        try {
            String string2 = sb.append(str1).append(str2).toString();
            return string2;
        }
        finally {
            StringBuilders.trimToMaxSize(sb, 518);
            sb.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String repeat(String str, int count2) {
        Objects.requireNonNull(str, "str");
        if (count2 < 0) {
            throw new IllegalArgumentException("count");
        }
        StringBuilder sb = FORMAT_BUFFER_REF.get();
        try {
            for (int index2 = 0; index2 < count2; ++index2) {
                sb.append(str);
            }
            String string2 = sb.toString();
            return string2;
        }
        finally {
            StringBuilders.trimToMaxSize(sb, 518);
            sb.setLength(0);
        }
    }
}

