/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.util.internal.SerializationUtil;

public class FilteredObjectInputStream
extends ObjectInputStream {
    private final Collection<String> allowedExtraClasses;

    public FilteredObjectInputStream() throws IOException, SecurityException {
        this.allowedExtraClasses = Collections.emptySet();
    }

    public FilteredObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.allowedExtraClasses = Collections.emptySet();
    }

    public FilteredObjectInputStream(Collection<String> allowedExtraClasses) throws IOException, SecurityException {
        this.allowedExtraClasses = allowedExtraClasses;
    }

    public FilteredObjectInputStream(InputStream inputStream, Collection<String> allowedExtraClasses) throws IOException {
        super(inputStream);
        this.allowedExtraClasses = allowedExtraClasses;
    }

    public Collection<String> getAllowedClasses() {
        return this.allowedExtraClasses;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name2 = SerializationUtil.stripArray(desc.getName());
        if (!FilteredObjectInputStream.isAllowedByDefault(name2) && !this.allowedExtraClasses.contains(name2)) {
            throw new InvalidObjectException("Class is not allowed for deserialization: " + name2);
        }
        return super.resolveClass(desc);
    }

    private static boolean isAllowedByDefault(String name2) {
        return FilteredObjectInputStream.isRequiredPackage(name2) || SerializationUtil.REQUIRED_JAVA_CLASSES.contains(name2);
    }

    private static boolean isRequiredPackage(String name2) {
        for (String packageName : SerializationUtil.REQUIRED_JAVA_PACKAGES) {
            if (!name2.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

