/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertySource;

@ServiceProvider(value=PropertySource.class, resolution="optional")
public class EnvironmentPropertySource
implements PropertySource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String PREFIX = "LOG4J_";
    private static final int DEFAULT_PRIORITY = 100;

    @Override
    public int getPriority() {
        return 100;
    }

    private void logException(SecurityException error2) {
        LOGGER.error("The system environment variables are not available to Log4j due to security restrictions", (Throwable)error2);
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        Map<String, String> getenv;
        try {
            getenv = System.getenv();
        }
        catch (SecurityException e) {
            this.logException(e);
            return;
        }
        for (Map.Entry<String, String> entry : getenv.entrySet()) {
            String key2 = entry.getKey();
            if (!key2.startsWith(PREFIX)) continue;
            action.accept(key2.substring(PREFIX.length()), entry.getValue());
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        StringBuilder sb = new StringBuilder("LOG4J");
        boolean empty = true;
        for (CharSequence charSequence : tokens) {
            empty = false;
            sb.append('_');
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                sb.append(Character.toUpperCase(charSequence.charAt(i2)));
            }
        }
        return empty ? null : sb.toString();
    }

    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getenv().keySet();
        }
        catch (SecurityException e) {
            this.logException(e);
            return PropertySource.super.getPropertyNames();
        }
    }

    @Override
    public String getProperty(String key2) {
        try {
            return System.getenv(key2);
        }
        catch (SecurityException e) {
            this.logException(e);
            return PropertySource.super.getProperty(key2);
        }
    }

    @Override
    public boolean containsProperty(String key2) {
        try {
            return System.getenv().containsKey(key2);
        }
        catch (SecurityException e) {
            this.logException(e);
            return PropertySource.super.containsProperty(key2);
        }
    }
}

