/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.StringBuilders;

@AsynchronouslyFormattable
public class StructuredDataMessage
extends MapMessage<StructuredDataMessage, String> {
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;
    private final int maxLength;

    public StructuredDataMessage(String id2, String msg, String type2) {
        this(id2, msg, type2, 32);
    }

    public StructuredDataMessage(String id2, String msg, String type2, int maxLength) {
        this.id = new StructuredDataId(id2, null, null, maxLength);
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    public StructuredDataMessage(String id2, String msg, String type2, Map<String, String> data2) {
        this(id2, msg, type2, data2, 32);
    }

    public StructuredDataMessage(String id2, String msg, String type2, Map<String, String> data2, int maxLength) {
        super(data2);
        this.id = new StructuredDataId(id2, null, null, maxLength);
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    public StructuredDataMessage(StructuredDataId id2, String msg, String type2) {
        this(id2, msg, type2, 32);
    }

    public StructuredDataMessage(StructuredDataId id2, String msg, String type2, int maxLength) {
        this.id = id2;
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    public StructuredDataMessage(StructuredDataId id2, String msg, String type2, Map<String, String> data2) {
        this(id2, msg, type2, data2, 32);
    }

    public StructuredDataMessage(StructuredDataId id2, String msg, String type2, Map<String, String> data2, int maxLength) {
        super(data2);
        this.id = id2;
        this.message = msg;
        this.type = type2;
        this.maxLength = maxLength;
    }

    private StructuredDataMessage(StructuredDataMessage msg, Map<String, String> map2) {
        super(map2);
        this.id = msg.id;
        this.message = msg.message;
        this.type = msg.type;
        this.maxLength = 32;
    }

    protected StructuredDataMessage() {
        this.maxLength = 32;
    }

    @Override
    public String[] getFormats() {
        String[] formats = new String[Format.values().length];
        int i2 = 0;
        for (Format format : Format.values()) {
            formats[i2++] = format.name();
        }
        return formats;
    }

    public StructuredDataId getId() {
        return this.id;
    }

    protected void setId(String id2) {
        this.id = new StructuredDataId(id2, null, null);
    }

    protected void setId(StructuredDataId id2) {
        this.id = id2;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type2) {
        if (type2.length() > 32) {
            throw new IllegalArgumentException("structured data type exceeds maximum length of 32 characters: " + type2);
        }
        this.type = type2;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.asString(Format.FULL, null, buffer);
    }

    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        this.asString(this.getFormat(formats), null, buffer);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    protected void setMessageFormat(String msg) {
        this.message = msg;
    }

    @Override
    public String asString() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String asString(String format) {
        try {
            return this.asString(EnglishEnums.valueOf(Format.class, format), null);
        }
        catch (IllegalArgumentException ex) {
            return this.asString();
        }
    }

    public final String asString(Format format, StructuredDataId structuredDataId) {
        StringBuilder sb = new StringBuilder();
        this.asString(format, structuredDataId, sb);
        return sb.toString();
    }

    public final void asString(Format format, StructuredDataId structuredDataId, StringBuilder sb) {
        String msg;
        StructuredDataId sdId;
        boolean full = Format.FULL.equals((Object)format);
        if (full) {
            String myType = this.getType();
            if (myType == null) {
                return;
            }
            sb.append(this.getType()).append(' ');
        }
        if ((sdId = (sdId = this.getId()) != null ? sdId.makeId(structuredDataId) : structuredDataId) == null || sdId.getName() == null) {
            return;
        }
        if (Format.XML.equals((Object)format)) {
            this.asXml(sdId, sb);
            return;
        }
        sb.append('[');
        StringBuilders.appendValue(sb, sdId);
        sb.append(' ');
        this.appendMap(sb);
        sb.append(']');
        if (full && (msg = this.getFormat()) != null) {
            sb.append(' ').append(msg);
        }
    }

    private void asXml(StructuredDataId structuredDataId, StringBuilder sb) {
        sb.append("<StructuredData>\n");
        sb.append("<type>").append(this.type).append("</type>\n");
        sb.append("<id>").append(structuredDataId).append("</id>\n");
        super.asXml(sb);
        sb.append("\n</StructuredData>\n");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        return this.asString(this.getFormat(formats), null);
    }

    private Format getFormat(String[] formats) {
        if (formats != null && formats.length > 0) {
            for (int i2 = 0; i2 < formats.length; ++i2) {
                String format = formats[i2];
                if (Format.XML.name().equalsIgnoreCase(format)) {
                    return Format.XML;
                }
                if (!Format.FULL.name().equalsIgnoreCase(format)) continue;
                return Format.FULL;
            }
            return null;
        }
        return Format.FULL;
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    @Override
    public StructuredDataMessage newInstance(Map<String, String> map2) {
        return new StructuredDataMessage(this, map2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructuredDataMessage)) {
            return false;
        }
        StructuredDataMessage that = (StructuredDataMessage)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        result2 = 31 * result2 + (this.id != null ? this.id.hashCode() : 0);
        result2 = 31 * result2 + (this.message != null ? this.message.hashCode() : 0);
        return result2;
    }

    @Override
    protected void validate(String key2, boolean value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, byte value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, char value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, double value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, float value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, int value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, long value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, Object value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, short value2) {
        this.validateKey(key2);
    }

    @Override
    protected void validate(String key2, String value2) {
        this.validateKey(key2);
    }

    protected void validateKey(String key2) {
        if (this.maxLength > 0 && key2.length() > this.maxLength) {
            throw new IllegalArgumentException("Structured data keys are limited to " + this.maxLength + " characters. key: " + key2);
        }
        for (int i2 = 0; i2 < key2.length(); ++i2) {
            char c = key2.charAt(i2);
            if (c >= '!' && c <= '~' && c != '=' && c != ']' && c != '\"') continue;
            throw new IllegalArgumentException("Structured data keys must contain printable US ASCII charactersand may not contain a space, =, ], or \"");
        }
    }

    public static enum Format {
        XML,
        FULL;

    }
}

