/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.ExitMessage;
import org.apache.logging.log4j.message.FlowMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class DefaultFlowMessageFactory
implements FlowMessageFactory,
Serializable {
    private static final String EXIT_DEFAULT_PREFIX = "Exit";
    private static final String ENTRY_DEFAULT_PREFIX = "Enter";
    private static final long serialVersionUID = 8578655591131397576L;
    private final String entryText;
    private final String exitText;
    private final MessageFactory messageFactory;

    public DefaultFlowMessageFactory() {
        this(ENTRY_DEFAULT_PREFIX, EXIT_DEFAULT_PREFIX);
    }

    public DefaultFlowMessageFactory(String entryText, String exitText) {
        this.entryText = entryText;
        this.exitText = exitText;
        this.messageFactory = DefaultFlowMessageFactory.createDefaultMessageFactory();
    }

    private static MessageFactory createDefaultMessageFactory() {
        try {
            return LoaderUtil.newInstanceOf(AbstractLogger.DEFAULT_MESSAGE_FACTORY_CLASS);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getEntryText() {
        return this.entryText;
    }

    public String getExitText() {
        return this.exitText;
    }

    @Override
    public EntryMessage newEntryMessage(String format, Object ... params2) {
        Message message2;
        boolean hasFormat = Strings.isNotEmpty(format);
        if (params2 == null || params2.length == 0) {
            message2 = hasFormat ? this.messageFactory.newMessage(format) : null;
        } else if (hasFormat) {
            message2 = this.messageFactory.newMessage(format, params2);
        } else {
            StringBuilder sb = new StringBuilder("params(");
            for (int i2 = 0; i2 < params2.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append("{}");
            }
            sb.append(")");
            message2 = this.messageFactory.newMessage(sb.toString(), params2);
        }
        return this.newEntryMessage(message2);
    }

    @Override
    public EntryMessage newEntryMessage(Message message2) {
        return new SimpleEntryMessage(this.entryText, this.makeImmutable(message2));
    }

    private Message makeImmutable(Message message2) {
        if (message2 instanceof ReusableMessage) {
            return ((ReusableMessage)message2).memento();
        }
        return message2;
    }

    @Override
    public ExitMessage newExitMessage(String format, Object result2) {
        boolean hasFormat = Strings.isNotEmpty(format);
        Message message2 = result2 == null ? (hasFormat ? this.messageFactory.newMessage(format) : null) : this.messageFactory.newMessage(hasFormat ? format : "with({})", result2);
        return this.newExitMessage(message2);
    }

    @Override
    public ExitMessage newExitMessage(Message message2) {
        return new SimpleExitMessage(this.exitText, message2);
    }

    @Override
    public ExitMessage newExitMessage(EntryMessage message2) {
        return new SimpleExitMessage(this.exitText, message2);
    }

    @Override
    public ExitMessage newExitMessage(Object result2, EntryMessage message2) {
        return new SimpleExitMessage(this.exitText, result2, message2);
    }

    @Override
    public ExitMessage newExitMessage(Object result2, Message message2) {
        return new SimpleExitMessage(this.exitText, result2, message2);
    }

    private static final class SimpleEntryMessage
    extends AbstractFlowMessage
    implements EntryMessage {
        private static final long serialVersionUID = 1L;

        SimpleEntryMessage(String entryText, Message message2) {
            super(entryText, message2);
        }
    }

    private static final class SimpleExitMessage
    extends AbstractFlowMessage
    implements ExitMessage {
        private static final long serialVersionUID = 1L;
        private final Object result;
        private final boolean isVoid;

        SimpleExitMessage(String exitText, EntryMessage message2) {
            this(exitText, message2.getMessage());
        }

        SimpleExitMessage(String exitText, Message message2) {
            super(exitText, message2);
            this.result = null;
            this.isVoid = true;
        }

        SimpleExitMessage(String exitText, Object result2, EntryMessage message2) {
            this(exitText, result2, message2.getMessage());
        }

        SimpleExitMessage(String exitText, Object result2, Message message2) {
            super(exitText, message2);
            this.result = result2;
            this.isVoid = false;
        }

        @Override
        public String getFormattedMessage() {
            String formattedMessage = super.getFormattedMessage();
            if (this.isVoid) {
                return formattedMessage;
            }
            return formattedMessage + ": " + this.result;
        }
    }

    private static class AbstractFlowMessage
    implements FlowMessage,
    StringBuilderFormattable {
        private static final long serialVersionUID = 1L;
        private final Message message;
        private final String text;

        AbstractFlowMessage(String text, Message message2) {
            this.message = message2;
            this.text = text;
        }

        @Override
        public String getFormattedMessage() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormattedMessage();
            }
            return this.text;
        }

        @Override
        public String getFormat() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormat();
            }
            return this.text;
        }

        @Override
        public Object[] getParameters() {
            if (this.message != null) {
                return this.message.getParameters();
            }
            return null;
        }

        @Override
        public Throwable getThrowable() {
            if (this.message != null) {
                return this.message.getThrowable();
            }
            return null;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void formatTo(StringBuilder buffer) {
            buffer.append(this.text);
            if (this.message != null) {
                buffer.append(" ");
                StringBuilders.appendValue(buffer, this.message);
            }
        }
    }
}

