/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import aQute.bnd.annotation.baseline.BaselineIgnore;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.logging.log4j.util.Strings;

@BaselineIgnore(value="2.22.0")
public final class Level
implements Comparable<Level>,
Serializable {
    private static final Level[] EMPTY_ARRAY = new Level[0];
    private static final ConcurrentMap<String, Level> LEVELS = new ConcurrentHashMap<String, Level>();
    public static final Level OFF = new Level("OFF", StandardLevel.OFF.intLevel());
    public static final Level FATAL = new Level("FATAL", StandardLevel.FATAL.intLevel());
    public static final Level ERROR = new Level("ERROR", StandardLevel.ERROR.intLevel());
    public static final Level WARN = new Level("WARN", StandardLevel.WARN.intLevel());
    public static final Level INFO = new Level("INFO", StandardLevel.INFO.intLevel());
    public static final Level DEBUG = new Level("DEBUG", StandardLevel.DEBUG.intLevel());
    public static final Level TRACE = new Level("TRACE", StandardLevel.TRACE.intLevel());
    public static final Level ALL = new Level("ALL", StandardLevel.ALL.intLevel());
    public static final String CATEGORY = "Level";
    private static final long serialVersionUID = 1581082L;
    private final String name;
    private final int intLevel;
    private final StandardLevel standardLevel;

    private Level(String name2, int intLevel) {
        if (Strings.isEmpty(name2)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        if (intLevel < 0) {
            throw new IllegalArgumentException("Illegal Level int less than zero.");
        }
        this.name = name2;
        this.intLevel = intLevel;
        this.standardLevel = StandardLevel.getStandardLevel(intLevel);
        if (LEVELS.putIfAbsent(Strings.toRootUpperCase(name2.trim()), this) != null) {
            throw new IllegalStateException("Level " + name2 + " has already been defined.");
        }
    }

    public int intLevel() {
        return this.intLevel;
    }

    public StandardLevel getStandardLevel() {
        return this.standardLevel;
    }

    public boolean isInRange(Level minLevel, Level maxLevel) {
        return this.intLevel >= minLevel.intLevel && this.intLevel <= maxLevel.intLevel;
    }

    public boolean isLessSpecificThan(Level level2) {
        return this.intLevel >= level2.intLevel;
    }

    public boolean isMoreSpecificThan(Level level2) {
        return this.intLevel <= level2.intLevel;
    }

    public Level clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public int compareTo(Level other) {
        return this.intLevel < other.intLevel ? -1 : (this.intLevel > other.intLevel ? 1 : 0);
    }

    public boolean equals(Object other) {
        return other instanceof Level && other == this;
    }

    public Class<Level> getDeclaringClass() {
        return Level.class;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Level forName(String name2, int intValue) {
        if (Strings.isEmpty(name2)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        String normalizedName = Strings.toRootUpperCase(name2.trim());
        Level level2 = (Level)LEVELS.get(normalizedName);
        if (level2 != null) {
            return level2;
        }
        try {
            return new Level(name2, intValue);
        }
        catch (IllegalStateException ex) {
            return (Level)LEVELS.get(normalizedName);
        }
    }

    public static Level getLevel(String name2) {
        if (Strings.isEmpty(name2)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        return (Level)LEVELS.get(Strings.toRootUpperCase(name2.trim()));
    }

    public static Level toLevel(String level2) {
        return Level.toLevel(level2, DEBUG);
    }

    public static Level toLevel(String name2, Level defaultLevel) {
        if (name2 == null) {
            return defaultLevel;
        }
        Level level2 = (Level)LEVELS.get(Strings.toRootUpperCase(name2.trim()));
        return level2 == null ? defaultLevel : level2;
    }

    public static Level[] values() {
        return LEVELS.values().toArray(EMPTY_ARRAY);
    }

    public static Level valueOf(String name2) {
        Objects.requireNonNull(name2, "No level name given.");
        String levelName = Strings.toRootUpperCase(name2.trim());
        Level level2 = (Level)LEVELS.get(levelName);
        if (level2 != null) {
            return level2;
        }
        throw new IllegalArgumentException("Unknown level constant [" + levelName + "].");
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name2) {
        return Enum.valueOf(enumType, name2);
    }

    private Object readResolve() {
        return Level.valueOf(this.name);
    }
}

