/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.OneLineFormatter;

public class FileHandler
extends Handler {
    public static final int DEFAULT_MAX_DAYS = -1;
    public static final int DEFAULT_BUFFER_SIZE = -1;
    private static final ExecutorService DELETE_FILES_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactory("FileHandlerLogFilesCleaner-"));
    private volatile String date = null;
    private String directory;
    private String prefix;
    private String suffix;
    private Boolean rotatable;
    private Integer maxDays;
    private volatile PrintWriter writer = null;
    protected final ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private Integer bufferSize;
    private Pattern pattern;

    public FileHandler() {
        this(null, null, null);
    }

    public FileHandler(String directory, String prefix, String suffix) {
        this(directory, prefix, suffix, null);
    }

    public FileHandler(String directory, String prefix, String suffix, Integer maxDays) {
        this(directory, prefix, suffix, maxDays, null, null);
    }

    public FileHandler(String directory, String prefix, String suffix, Integer maxDays, Boolean rotatable, Integer bufferSize) {
        this.directory = directory;
        this.prefix = prefix;
        this.suffix = suffix;
        this.maxDays = maxDays;
        this.rotatable = rotatable;
        this.bufferSize = bufferSize;
        this.configure();
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        block19: {
            String tsDate;
            if (!this.isLoggable(record)) {
                return;
            }
            if (this.rotatable.booleanValue()) {
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                tsDate = ts.toString().substring(0, 10);
            } else {
                tsDate = "";
            }
            this.writerLock.readLock().lock();
            try {
                if (!tsDate.equals(this.date)) {
                    this.writerLock.readLock().unlock();
                    this.writerLock.writeLock().lock();
                    try {
                        if (!tsDate.equals(this.date)) {
                            this.closeWriter();
                            this.date = tsDate;
                            this.openWriter();
                            this.clean();
                        }
                    }
                    finally {
                        this.writerLock.readLock().lock();
                        this.writerLock.writeLock().unlock();
                    }
                }
                String result2 = null;
                try {
                    result2 = this.getFormatter().format(record);
                }
                catch (Exception e) {
                    this.reportError(null, e, 5);
                    this.writerLock.readLock().unlock();
                    return;
                }
                try {
                    if (this.writer != null) {
                        this.writer.write(result2);
                        if (this.bufferSize < 0) {
                            this.writer.flush();
                        }
                        break block19;
                    }
                    this.reportError("FileHandler is closed or not yet initialized, unable to log [" + result2 + "]", null, 1);
                }
                catch (Exception e) {
                    this.reportError(null, e, 1);
                }
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }
    }

    @Override
    public void close() {
        this.closeWriter();
    }

    protected void closeWriter() {
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            this.date = null;
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    private void configure() {
        String formatterName;
        String encoding2;
        boolean shouldCheckForRedundantSeparator;
        String className = this.getClass().getName();
        ClassLoader cl = ClassLoaderLogManager.getClassLoader();
        if (this.rotatable == null) {
            this.rotatable = Boolean.valueOf(this.getProperty(className + ".rotatable", "true"));
        }
        if (this.directory == null) {
            this.directory = this.getProperty(className + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(className + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(className + ".suffix", ".log");
        }
        boolean bl = shouldCheckForRedundantSeparator = this.rotatable == false && !this.prefix.isEmpty() && !this.suffix.isEmpty();
        if (shouldCheckForRedundantSeparator && this.prefix.charAt(this.prefix.length() - 1) == this.suffix.charAt(0)) {
            this.suffix = this.suffix.substring(1);
        }
        this.pattern = Pattern.compile("^(" + Pattern.quote(this.prefix) + ")\\d{4}-\\d{1,2}-\\d{1,2}(" + Pattern.quote(this.suffix) + ")$");
        if (this.maxDays == null) {
            String sMaxDays = this.getProperty(className + ".maxDays", String.valueOf(-1));
            try {
                this.maxDays = Integer.valueOf(sMaxDays);
            }
            catch (NumberFormatException ignore) {
                this.maxDays = -1;
            }
        }
        if (this.bufferSize == null) {
            String sBufferSize = this.getProperty(className + ".bufferSize", String.valueOf(-1));
            try {
                this.bufferSize = Integer.valueOf(sBufferSize);
            }
            catch (NumberFormatException ignore) {
                this.bufferSize = -1;
            }
        }
        if ((encoding2 = this.getProperty(className + ".encoding", null)) != null && encoding2.length() > 0) {
            try {
                this.setEncoding(encoding2);
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(className + ".level", String.valueOf(Level.ALL))));
        String filterName = this.getProperty(className + ".filter", null);
        if (filterName != null) {
            try {
                this.setFilter((Filter)cl.loadClass(filterName).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if ((formatterName = this.getProperty(className + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)cl.loadClass(formatterName).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                this.setFormatter(new OneLineFormatter());
            }
        } else {
            this.setFormatter(new OneLineFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String name2, String defaultValue) {
        String value2 = LogManager.getLogManager().getProperty(name2);
        value2 = value2 == null ? defaultValue : value2.trim();
        return value2;
    }

    public void open() {
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWriter() {
        File dir = new File(this.directory);
        if (!dir.mkdirs() && !dir.isDirectory()) {
            this.reportError("Unable to create [" + String.valueOf(dir) + "]", null, 4);
            this.writer = null;
            return;
        }
        this.writerLock.writeLock().lock();
        FileOutputStream fos = null;
        OutputStream os = null;
        try {
            File pathname2 = new File(dir.getAbsoluteFile(), this.prefix + (this.rotatable != false ? this.date : "") + this.suffix);
            File parent = pathname2.getParentFile();
            if (!parent.mkdirs() && !parent.isDirectory()) {
                this.reportError("Unable to create [" + String.valueOf(parent) + "]", null, 4);
                this.writer = null;
                return;
            }
            String encoding2 = this.getEncoding();
            fos = new FileOutputStream(pathname2, true);
            os = this.bufferSize > 0 ? new BufferedOutputStream(fos, this.bufferSize) : fos;
            this.writer = new PrintWriter((Writer)(encoding2 != null ? new OutputStreamWriter(os, encoding2) : new OutputStreamWriter(os)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception e) {
            this.reportError(null, e, 4);
            this.writer = null;
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    private void clean() {
        if (this.maxDays <= 0 || Files.notExists(this.getDirectoryAsPath(), new LinkOption[0])) {
            return;
        }
        DELETE_FILES_SERVICE.submit(() -> {
            try (DirectoryStream<Path> files = this.streamFilesForDelete();){
                for (Path file2 : files) {
                    Files.delete(file2);
                }
            }
            catch (IOException e) {
                this.reportError("Unable to delete log files older than [" + this.maxDays + "] days", null, 0);
            }
        });
    }

    private DirectoryStream<Path> streamFilesForDelete() throws IOException {
        LocalDate maxDaysOffset = LocalDate.now().minus(this.maxDays.intValue(), ChronoUnit.DAYS);
        return Files.newDirectoryStream(this.getDirectoryAsPath(), path2 -> {
            boolean result2 = false;
            String date2 = this.obtainDateFromPath((Path)path2);
            if (date2 != null) {
                try {
                    LocalDate dateFromFile = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(date2));
                    result2 = dateFromFile.isBefore(maxDaysOffset);
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
            return result2;
        });
    }

    private Path getDirectoryAsPath() {
        return Path.of(this.directory, new String[0]);
    }

    private String obtainDateFromPath(Path path2) {
        Path fileName = path2.getFileName();
        if (fileName == null) {
            return null;
        }
        String date2 = fileName.toString();
        if (this.pattern.matcher(date2).matches()) {
            date2 = date2.substring(this.prefix.length());
            return date2.substring(0, date2.length() - this.suffix.length());
        }
        return null;
    }

    protected static final class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private final String namePrefix;
        private final boolean isSecurityEnabled;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public ThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s2 = System.getSecurityManager();
            if (s2 == null) {
                this.isSecurityEnabled = false;
                this.group = Thread.currentThread().getThreadGroup();
            } else {
                this.isSecurityEnabled = true;
                this.group = s2.getThreadGroup();
            }
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (this.isSecurityEnabled) {
                AccessController.doPrivileged(() -> {
                    t.setContextClassLoader(ThreadFactory.class.getClassLoader());
                    return null;
                });
            } else {
                t.setContextClassLoader(ThreadFactory.class.getClassLoader());
            }
            t.setDaemon(true);
            return t;
        }
    }
}

