/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import jakarta.el.ELException;
import jakarta.el.MethodNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.util.MessageFactory;

public class ReflectionUtil {
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String name2) throws ClassNotFoundException {
        if (null == name2 || name2.isEmpty()) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name2);
        if (c == null) {
            if (name2.endsWith("[]")) {
                String nc = name2.substring(0, name2.length() - 2);
                c = Class.forName(nc, true, ReflectionUtil.getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name2, true, ReflectionUtil.getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class<?> forNamePrimitive(String name2) {
        int p2;
        if (name2.length() <= 8 && (p2 = Arrays.binarySearch(PRIMITIVE_NAMES, name2)) >= 0) {
            return PRIMITIVES[p2];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] s2) throws ClassNotFoundException {
        if (s2 == null) {
            return null;
        }
        Class[] c = new Class[s2.length];
        for (int i2 = 0; i2 < s2.length; ++i2) {
            c[i2] = ReflectionUtil.forName(s2[i2]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class<?>[] c) {
        if (c == null) {
            return null;
        }
        String[] s2 = new String[c.length];
        for (int i2 = 0; i2 < c.length; ++i2) {
            s2[i2] = c[i2].getName();
        }
        return s2;
    }

    public static Method getMethod(EvaluationContext ctx, Object base, Object property, Class<?>[] paramTypes, Object[] paramValues) throws MethodNotFoundException {
        if (base == null || property == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        String methodName = property instanceof String ? (String)property : property.toString();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        Method[] methods2 = base.getClass().getMethods();
        HashMap<Object, MatchResult> candidates = new HashMap<Object, MatchResult>();
        for (Method m : methods2) {
            if (!m.getName().equals(methodName)) continue;
            Class<?>[] classArray = m.getParameterTypes();
            int mParamCount = classArray.length;
            if (!m.isVarArgs() && paramCount != mParamCount || m.isVarArgs() && paramCount < mParamCount - 1 || m.isVarArgs() && paramCount == mParamCount && paramValues != null && paramValues.length > paramCount && !paramTypes[mParamCount - 1].isArray() || m.isVarArgs() && paramCount > mParamCount && paramValues != null && paramValues.length != paramCount || !m.isVarArgs() && paramValues != null && paramCount != paramValues.length) continue;
            int exactMatch = 0;
            int assignableMatch = 0;
            int coercibleMatch = 0;
            int varArgsMatch = 0;
            boolean noMatch = false;
            block1: for (int i2 = 0; i2 < mParamCount; ++i2) {
                if (m.isVarArgs() && i2 == mParamCount - 1) {
                    if (i2 == paramCount || paramValues != null && paramValues.length == i2) {
                        varArgsMatch = Integer.MAX_VALUE;
                        break;
                    }
                    Class<?> varType = classArray[i2].getComponentType();
                    for (int j = i2; j < paramCount; ++j) {
                        if (ReflectionUtil.isAssignableFrom(paramTypes[j], varType)) {
                            ++assignableMatch;
                            ++varArgsMatch;
                            continue;
                        }
                        if (paramValues == null) {
                            noMatch = true;
                            continue block1;
                        }
                        if (ReflectionUtil.isCoercibleFrom(ctx, paramValues[j], varType)) {
                            ++coercibleMatch;
                            ++varArgsMatch;
                            continue;
                        }
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (classArray[i2].equals(paramTypes[i2])) {
                    ++exactMatch;
                    continue;
                }
                if (paramTypes[i2] != null && ReflectionUtil.isAssignableFrom(paramTypes[i2], classArray[i2])) {
                    ++assignableMatch;
                    continue;
                }
                if (paramValues == null) {
                    noMatch = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(ctx, paramValues[i2], classArray[i2])) {
                    ++coercibleMatch;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount && varArgsMatch == 0) {
                Method result2 = ReflectionUtil.getMethod(base.getClass(), base, m);
                if (result2 == null) {
                    throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
                }
                return result2;
            }
            candidates.put(m, new MatchResult(m.isVarArgs(), exactMatch, assignableMatch, coercibleMatch, varArgsMatch, m.isBridge()));
        }
        MatchResult bestMatch = new MatchResult(true, 0, 0, 0, 0, true);
        Method match2 = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            int cmp2 = ((MatchResult)entry.getValue()).compareTo(bestMatch);
            if (cmp2 > 0 || match2 == null) {
                bestMatch = (MatchResult)entry.getValue();
                match2 = (Method)entry.getKey();
                multiple = false;
                continue;
            }
            if (cmp2 != 0) continue;
            multiple = true;
        }
        if (multiple && (match2 = bestMatch.getExactCount() == paramCount - 1 ? ReflectionUtil.resolveAmbiguousMethod(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.ambiguous", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        if (match2 == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        Method result3 = ReflectionUtil.getMethod(base.getClass(), base, match2);
        if (result3 == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        return result3;
    }

    /*
     * WARNING - void declaration
     */
    private static Method resolveAmbiguousMethod(Set<Method> candidates, Class<?>[] paramTypes) {
        void var6_14;
        Method m = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (m.getParameterTypes()[i2] == paramTypes[i2]) continue;
            nonMatchIndex = i2;
            nonMatchClass = paramTypes[i2];
            break;
        }
        if (nonMatchClass == null) {
            return null;
        }
        for (Method method2 : candidates) {
            if (method2.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Method c : candidates) {
                if (!c.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return c;
            }
        }
        Object var6_10 = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Method c : candidates) {
                void var6_11;
                Class<?> candidateType = c.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (var6_11 == null) {
                    Method method3 = c;
                    continue;
                }
                Object var6_13 = null;
                break;
            }
        }
        return var6_14;
    }

    private static boolean isAssignableFrom(Class<?> src, Class<?> target2) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target2.isPrimitive() ? (target2 == Boolean.TYPE ? Boolean.class : (target2 == Character.TYPE ? Character.class : (target2 == Byte.TYPE ? Byte.class : (target2 == Short.TYPE ? Short.class : (target2 == Integer.TYPE ? Integer.class : (target2 == Long.TYPE ? Long.class : (target2 == Float.TYPE ? Float.class : Double.class))))))) : target2;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(EvaluationContext ctx, Object src, Class<?> target2) {
        try {
            ELSupport.coerceToType(ctx, src, target2);
        }
        catch (ELException e) {
            return false;
        }
        return true;
    }

    private static Method getMethod(Class<?> type2, Object base, Method m) {
        if (m == null || Modifier.isPublic(type2.getModifiers()) && (Modifier.isStatic(m.getModifiers()) && m.canAccess(null) || m.canAccess(base))) {
            return m;
        }
        Class<?>[] interfaces2 = type2.getInterfaces();
        Method mp = null;
        for (Class<?> iface : interfaces2) {
            try {
                mp = iface.getMethod(m.getName(), m.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type2.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> type2 : types) {
                if (type2 == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(type2.getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader tccl;
        if (System.getSecurityManager() != null) {
            PrivilegedGetTccl pa = new PrivilegedGetTccl();
            tccl = AccessController.doPrivileged(pa);
        } else {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        return tccl;
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final boolean varArgs;
        private final int exactCount;
        private final int assignableCount;
        private final int coercibleCount;
        private final int varArgsCount;
        private final boolean bridge;

        MatchResult(boolean varArgs, int exactCount, int assignableCount, int coercibleCount, int varArgsCount, boolean bridge) {
            this.varArgs = varArgs;
            this.exactCount = exactCount;
            this.assignableCount = assignableCount;
            this.coercibleCount = coercibleCount;
            this.varArgsCount = varArgsCount;
            this.bridge = bridge;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        public int getExactCount() {
            return this.exactCount;
        }

        public int getAssignableCount() {
            return this.assignableCount;
        }

        public int getCoercible() {
            return this.coercibleCount;
        }

        public int getVarArgsCount() {
            return this.varArgsCount;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult o) {
            int cmp2 = Boolean.compare(o.isVarArgs(), this.isVarArgs());
            if (cmp2 == 0 && (cmp2 = Integer.compare(this.getExactCount(), o.getExactCount())) == 0 && (cmp2 = Integer.compare(this.getAssignableCount(), o.getAssignableCount())) == 0 && (cmp2 = Integer.compare(this.getCoercible(), o.getCoercible())) == 0 && (cmp2 = Integer.compare(o.getVarArgsCount(), this.getVarArgsCount())) == 0) {
                cmp2 = Boolean.compare(o.isBridge(), this.isBridge());
            }
            return cmp2;
        }

        public boolean equals(Object o) {
            return o == this || null != o && this.getClass().equals(o.getClass()) && ((MatchResult)o).getExactCount() == this.getExactCount() && ((MatchResult)o).getAssignableCount() == this.getAssignableCount() && ((MatchResult)o).getCoercible() == this.getCoercible() && ((MatchResult)o).getVarArgsCount() == this.getVarArgsCount() && ((MatchResult)o).isVarArgs() == this.isVarArgs() && ((MatchResult)o).isBridge() == this.isBridge();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.assignableCount;
            result2 = 31 * result2 + (this.bridge ? 1231 : 1237);
            result2 = 31 * result2 + this.coercibleCount;
            result2 = 31 * result2 + this.exactCount;
            result2 = 31 * result2 + (this.varArgs ? 1231 : 1237);
            result2 = 31 * result2 + this.varArgsCount;
            return result2;
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

