/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessageFactory {
    private static final ResourceBundle DEFAULT_BUNDLE = ResourceBundle.getBundle("org.apache.el.LocalStrings");
    private static final MessageFactory DEFAULT_MESSAGE_FACTORY = new MessageFactory(DEFAULT_BUNDLE);
    private final ResourceBundle bundle;

    public static String get(String key2) {
        return DEFAULT_MESSAGE_FACTORY.getInternal(key2);
    }

    public static String get(String key2, Object ... args2) {
        return DEFAULT_MESSAGE_FACTORY.getInternal(key2, args2);
    }

    public MessageFactory(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    protected String getInternal(String key2) {
        try {
            return this.bundle.getString(key2);
        }
        catch (MissingResourceException e) {
            return key2;
        }
    }

    protected String getInternal(String key2, Object ... args2) {
        String value2 = this.getInternal(key2);
        MessageFormat mf = new MessageFormat(value2);
        Format[] formats = null;
        if (args2 != null) {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                if (!(args2[i2] instanceof Number)) continue;
                if (formats == null) {
                    formats = mf.getFormatsByArgumentIndex();
                }
                if (i2 >= formats.length || formats[i2] instanceof NumberFormat) continue;
                args2[i2] = args2[i2].toString();
            }
        }
        return mf.format(args2, new StringBuffer(), (FieldPosition)null).toString();
    }
}

