/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.stream;

import jakarta.el.ELException;
import jakarta.el.LambdaExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.lang.ELSupport;
import org.apache.el.stream.Optional;
import org.apache.el.util.MessageFactory;

public class Stream {
    private final Iterator<Object> iterator;

    public Stream(Iterator<Object> iterator) {
        this.iterator = iterator;
    }

    public Stream filter(final LambdaExpression le) {
        OpIterator downStream = new OpIterator(this){
            final /* synthetic */ Stream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void findNext() {
                while (this.this$0.iterator.hasNext()) {
                    Object obj = this.this$0.iterator.next();
                    if (!ELSupport.coerceToBoolean(null, le.invoke(obj), true).booleanValue()) continue;
                    this.next = obj;
                    this.foundNext = true;
                    break;
                }
            }
        };
        return new Stream(downStream);
    }

    public Stream map(final LambdaExpression le) {
        OpIterator downStream = new OpIterator(this){
            final /* synthetic */ Stream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void findNext() {
                if (this.this$0.iterator.hasNext()) {
                    Object obj = this.this$0.iterator.next();
                    this.next = le.invoke(obj);
                    this.foundNext = true;
                }
            }
        };
        return new Stream(downStream);
    }

    public Stream flatMap(final LambdaExpression le) {
        OpIterator downStream = new OpIterator(this){
            private Iterator<?> inner;
            final /* synthetic */ Stream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void findNext() {
                while (this.this$0.iterator.hasNext() || this.inner != null && this.inner.hasNext()) {
                    if (this.inner == null || !this.inner.hasNext()) {
                        this.inner = ((Stream)le.invoke((Object[])new Object[]{this.this$0.iterator.next()})).iterator;
                    }
                    if (!this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.foundNext = true;
                    break;
                }
            }
        };
        return new Stream(downStream);
    }

    public Stream distinct() {
        OpIterator downStream = new OpIterator(){
            private Set<Object> values = new HashSet<Object>();

            @Override
            protected void findNext() {
                while (Stream.this.iterator.hasNext()) {
                    Object obj = Stream.this.iterator.next();
                    if (!this.values.add(obj)) continue;
                    this.next = obj;
                    this.foundNext = true;
                    break;
                }
            }
        };
        return new Stream(downStream);
    }

    public Stream sorted() {
        OpIterator downStream = new OpIterator(){
            private Iterator<Object> sorted = null;

            @Override
            protected void findNext() {
                if (this.sorted == null) {
                    this.sort();
                }
                if (this.sorted.hasNext()) {
                    this.next = this.sorted.next();
                    this.foundNext = true;
                }
            }

            private void sort() {
                ArrayList<Object> list2 = new ArrayList<Object>();
                while (Stream.this.iterator.hasNext()) {
                    list2.add(Stream.this.iterator.next());
                }
                Collections.sort(list2);
                this.sorted = list2.iterator();
            }
        };
        return new Stream(downStream);
    }

    public Stream sorted(final LambdaExpression le) {
        OpIterator downStream = new OpIterator(this){
            private Iterator<Object> sorted = null;
            final /* synthetic */ Stream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void findNext() {
                if (this.sorted == null) {
                    this.sort(le);
                }
                if (this.sorted.hasNext()) {
                    this.next = this.sorted.next();
                    this.foundNext = true;
                }
            }

            private void sort(LambdaExpression le2) {
                ArrayList<Object> list2 = new ArrayList<Object>();
                LambdaExpressionComparator c = new LambdaExpressionComparator(le2);
                while (this.this$0.iterator.hasNext()) {
                    list2.add(this.this$0.iterator.next());
                }
                list2.sort(c);
                this.sorted = list2.iterator();
            }
        };
        return new Stream(downStream);
    }

    public Object forEach(LambdaExpression le) {
        while (this.iterator.hasNext()) {
            le.invoke(this.iterator.next());
        }
        return null;
    }

    public Stream peek(final LambdaExpression le) {
        OpIterator downStream = new OpIterator(this){
            final /* synthetic */ Stream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void findNext() {
                if (this.this$0.iterator.hasNext()) {
                    Object obj = this.this$0.iterator.next();
                    le.invoke(obj);
                    this.next = obj;
                    this.foundNext = true;
                }
            }
        };
        return new Stream(downStream);
    }

    public Iterator<?> iterator() {
        return this.iterator;
    }

    public Stream limit(Number count2) {
        return this.substream(0, count2);
    }

    public Stream substream(Number start2) {
        return this.substream(start2, Integer.MAX_VALUE);
    }

    public Stream substream(final Number start2, final Number end2) {
        OpIterator downStream = new OpIterator(this){
            private final int startPos;
            private final int endPos;
            private int itemCount;
            final /* synthetic */ Stream this$0;
            {
                this.this$0 = this$0;
                this.startPos = start2.intValue();
                this.endPos = end2.intValue();
                this.itemCount = 0;
            }

            @Override
            protected void findNext() {
                while (this.itemCount < this.startPos && this.this$0.iterator.hasNext()) {
                    this.this$0.iterator.next();
                    ++this.itemCount;
                }
                if (this.itemCount < this.endPos && this.this$0.iterator.hasNext()) {
                    ++this.itemCount;
                    this.next = this.this$0.iterator.next();
                    this.foundNext = true;
                }
            }
        };
        return new Stream(downStream);
    }

    public List<Object> toList() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        while (this.iterator.hasNext()) {
            result2.add(this.iterator.next());
        }
        return result2;
    }

    public Object[] toArray() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        while (this.iterator.hasNext()) {
            result2.add(this.iterator.next());
        }
        return result2.toArray(new Object[0]);
    }

    public Optional reduce(LambdaExpression le) {
        Object seed2 = null;
        if (this.iterator.hasNext()) {
            seed2 = this.iterator.next();
        }
        if (seed2 == null) {
            return Optional.EMPTY;
        }
        return new Optional(this.reduce(seed2, le));
    }

    public Object reduce(Object seed2, LambdaExpression le) {
        Object result2 = seed2;
        while (this.iterator.hasNext()) {
            result2 = le.invoke(result2, this.iterator.next());
        }
        return result2;
    }

    public Optional max() {
        return this.compare(true);
    }

    public Optional max(LambdaExpression le) {
        return this.compare(true, le);
    }

    public Optional min() {
        return this.compare(false);
    }

    public Optional min(LambdaExpression le) {
        return this.compare(false, le);
    }

    public Optional average() {
        long count2 = 0L;
        Number sum2 = 0L;
        while (this.iterator.hasNext()) {
            ++count2;
            sum2 = ELArithmetic.add(sum2, this.iterator.next());
        }
        if (count2 == 0L) {
            return Optional.EMPTY;
        }
        return new Optional(ELArithmetic.divide(sum2, count2));
    }

    public Number sum() {
        Number sum2 = 0L;
        while (this.iterator.hasNext()) {
            sum2 = ELArithmetic.add(sum2, this.iterator.next());
        }
        return sum2;
    }

    public Long count() {
        long count2 = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++count2;
        }
        return count2;
    }

    public Optional anyMatch(LambdaExpression le) {
        if (!this.iterator.hasNext()) {
            return Optional.EMPTY;
        }
        Boolean match2 = Boolean.FALSE;
        while (!match2.booleanValue() && this.iterator.hasNext()) {
            match2 = (Boolean)le.invoke(this.iterator.next());
        }
        return new Optional(match2);
    }

    public Optional allMatch(LambdaExpression le) {
        if (!this.iterator.hasNext()) {
            return Optional.EMPTY;
        }
        Boolean match2 = Boolean.TRUE;
        while (match2.booleanValue() && this.iterator.hasNext()) {
            match2 = (Boolean)le.invoke(this.iterator.next());
        }
        return new Optional(match2);
    }

    public Optional noneMatch(LambdaExpression le) {
        if (!this.iterator.hasNext()) {
            return Optional.EMPTY;
        }
        Boolean match2 = Boolean.FALSE;
        while (!match2.booleanValue() && this.iterator.hasNext()) {
            match2 = (Boolean)le.invoke(this.iterator.next());
        }
        return new Optional(match2 == false);
    }

    public Optional findFirst() {
        if (this.iterator.hasNext()) {
            return new Optional(this.iterator.next());
        }
        return Optional.EMPTY;
    }

    private Optional compare(boolean isMax) {
        Object obj;
        Comparable result2 = null;
        if (this.iterator.hasNext()) {
            obj = this.iterator.next();
            if (obj instanceof Comparable) {
                result2 = (Comparable)obj;
            } else {
                throw new ELException(MessageFactory.get("stream.compare.notComparable"));
            }
        }
        while (this.iterator.hasNext()) {
            obj = this.iterator.next();
            if (obj instanceof Comparable) {
                if (isMax && ((Comparable)obj).compareTo(result2) > 0) {
                    result2 = (Comparable)obj;
                    continue;
                }
                if (isMax || ((Comparable)obj).compareTo(result2) >= 0) continue;
                result2 = (Comparable)obj;
                continue;
            }
            throw new ELException(MessageFactory.get("stream.compare.notComparable"));
        }
        if (result2 == null) {
            return Optional.EMPTY;
        }
        return new Optional(result2);
    }

    private Optional compare(boolean isMax, LambdaExpression le) {
        Object obj;
        Object result2 = null;
        if (this.iterator.hasNext()) {
            result2 = obj = this.iterator.next();
        }
        while (this.iterator.hasNext()) {
            obj = this.iterator.next();
            if (isMax && ELSupport.coerceToNumber(null, le.invoke(obj, result2), Integer.class).intValue() > 0) {
                result2 = obj;
                continue;
            }
            if (isMax || ELSupport.coerceToNumber(null, le.invoke(obj, result2), Integer.class).intValue() >= 0) continue;
            result2 = obj;
        }
        if (result2 == null) {
            return Optional.EMPTY;
        }
        return new Optional(result2);
    }

    private static abstract class OpIterator
    implements Iterator<Object> {
        protected boolean foundNext = false;
        protected Object next;

        private OpIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.foundNext) {
                return true;
            }
            this.findNext();
            return this.foundNext;
        }

        @Override
        public Object next() {
            if (this.foundNext) {
                this.foundNext = false;
                return this.next;
            }
            this.findNext();
            if (this.foundNext) {
                this.foundNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract void findNext();
    }

    private static class LambdaExpressionComparator
    implements Comparator<Object> {
        private final LambdaExpression le;

        LambdaExpressionComparator(LambdaExpression le) {
            this.le = le;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ELSupport.coerceToNumber(null, this.le.invoke(o1, o2), Integer.class).intValue();
        }
    }
}

