/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELException;
import jakarta.el.LambdaExpression;
import java.util.ArrayList;
import org.apache.el.ValueExpressionImpl;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.lang.LambdaExpressionNestedState;
import org.apache.el.parser.AstLambdaParameters;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.Node;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;

public class AstLambdaExpression
extends SimpleNode {
    public AstLambdaExpression(int id2) {
        super(id2);
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        int methodParameterSetCount;
        LambdaExpressionNestedState state2 = ctx.getLambdaExpressionNestedState();
        if (state2 == null) {
            state2 = new LambdaExpressionNestedState();
            this.populateNestedState(state2);
            ctx.setLambdaExpressionNestedState(state2);
        }
        if ((methodParameterSetCount = this.jjtGetNumChildren() - 2) > state2.getNestingCount()) {
            throw new ELException(MessageFactory.get("error.lambda.tooManyMethodParameterSets"));
        }
        AstLambdaParameters formalParametersNode = (AstLambdaParameters)this.children[0];
        SimpleNode[] formalParamNodes = formalParametersNode.children;
        ValueExpressionImpl ve = new ValueExpressionImpl("", this.children[1], ctx.getFunctionMapper(), ctx.getVariableMapper(), null);
        ArrayList<String> formalParameters = new ArrayList<String>();
        if (formalParamNodes != null) {
            for (SimpleNode formalParamNode : formalParamNodes) {
                formalParameters.add(formalParamNode.getImage());
            }
        }
        LambdaExpression le = new LambdaExpression(formalParameters, ve);
        le.setELContext(ctx);
        if (this.jjtGetNumChildren() == 2) {
            if (state2.getHasFormalParameters()) {
                return le;
            }
            return le.invoke(ctx, (Object[])null);
        }
        int methodParameterIndex = 2;
        Object result2 = le.invoke(((AstMethodParameters)this.children[methodParameterIndex]).getParameters(ctx));
        ++methodParameterIndex;
        while (result2 instanceof LambdaExpression && methodParameterIndex < this.jjtGetNumChildren()) {
            result2 = ((LambdaExpression)result2).invoke(((AstMethodParameters)this.children[methodParameterIndex]).getParameters(ctx));
            ++methodParameterIndex;
        }
        return result2;
    }

    private void populateNestedState(LambdaExpressionNestedState lambdaExpressionNestedState) {
        lambdaExpressionNestedState.incrementNestingCount();
        if (this.jjtGetNumChildren() > 1) {
            Node firstChild = this.jjtGetChild(0);
            if (firstChild instanceof AstLambdaParameters) {
                if (firstChild.jjtGetNumChildren() > 0) {
                    lambdaExpressionNestedState.setHasFormalParameters();
                }
            } else {
                return;
            }
            Node secondChild = this.jjtGetChild(1);
            if (secondChild instanceof AstLambdaExpression) {
                ((AstLambdaExpression)secondChild).populateNestedState(lambdaExpressionNestedState);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (SimpleNode n : this.children) {
            result2.append(((Object)n).toString());
        }
        return result2.toString();
    }
}

