/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELClass;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.LambdaExpression;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.ELParserTreeConstants;
import org.apache.el.parser.Node;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;

public final class AstFunction
extends SimpleNode {
    protected String localName = "";
    protected String prefix = "";

    public AstFunction(int id2) {
        super(id2);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix == null) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        FunctionMapper fnMapper = ctx.getFunctionMapper();
        if (fnMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method m = fnMapper.resolveFunction(this.prefix, this.localName);
        if (m == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return m.getReturnType();
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        FunctionMapper fnMapper = ctx.getFunctionMapper();
        if (fnMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method m = fnMapper.resolveFunction(this.prefix, this.localName);
        if (m == null && this.prefix.length() == 0) {
            VariableMapper varMapper;
            Class<?> obj = null;
            if (ctx.isLambdaArgument(this.localName)) {
                obj = ctx.getLambdaArgument(this.localName);
            }
            if (obj == null && (varMapper = ctx.getVariableMapper()) != null && (obj = varMapper.resolveVariable(this.localName)) instanceof ValueExpression) {
                obj = ((ValueExpression)((Object)obj)).getValue(ctx);
            }
            if (obj == null) {
                obj = ctx.getELResolver().getValue(ctx, null, this.localName);
            }
            if (obj instanceof LambdaExpression) {
                int i2;
                for (i2 = 0; obj instanceof LambdaExpression && i2 < this.jjtGetNumChildren(); ++i2) {
                    Node args2 = this.jjtGetChild(i2);
                    obj = ((LambdaExpression)((Object)obj)).invoke(((AstMethodParameters)args2).getParameters(ctx));
                }
                if (i2 < this.jjtGetNumChildren()) {
                    throw new ELException(MessageFactory.get("error.lambda.tooManyMethodParameterSets"));
                }
                return obj;
            }
            obj = ctx.getImportHandler().resolveClass(this.localName);
            if (obj != null) {
                return ctx.getELResolver().invoke(ctx, new ELClass(obj), "<init>", null, ((AstMethodParameters)this.children[0]).getParameters(ctx));
            }
            obj = ctx.getImportHandler().resolveStatic(this.localName);
            if (obj != null) {
                return ctx.getELResolver().invoke(ctx, new ELClass(obj), this.localName, null, ((AstMethodParameters)this.children[0]).getParameters(ctx));
            }
        }
        if (m == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        if (this.jjtGetNumChildren() != 1) {
            throw new ELException(MessageFactory.get("error.function.tooManyMethodParameterSets", this.getOutputName()));
        }
        Node parameters2 = this.jjtGetChild(0);
        Class<?>[] paramTypes = m.getParameterTypes();
        Object[] params2 = null;
        Object result2 = null;
        int inputParameterCount = parameters2.jjtGetNumChildren();
        int methodParameterCount = paramTypes.length;
        if (inputParameterCount == 0 && methodParameterCount == 1 && m.isVarArgs()) {
            params2 = new Object[]{null};
        } else if (inputParameterCount > 0) {
            params2 = new Object[methodParameterCount];
            try {
                for (int i3 = 0; i3 < methodParameterCount; ++i3) {
                    if (m.isVarArgs() && i3 == methodParameterCount - 1) {
                        if (inputParameterCount < methodParameterCount) {
                            params2[i3] = new Object[]{null};
                        } else if (inputParameterCount == methodParameterCount && this.isArray(parameters2.jjtGetChild(i3).getValue(ctx))) {
                            params2[i3] = parameters2.jjtGetChild(i3).getValue(ctx);
                        } else {
                            Object[] varargs = new Object[inputParameterCount - methodParameterCount + 1];
                            Class<?> target2 = paramTypes[i3].getComponentType();
                            for (int j = i3; j < inputParameterCount; ++j) {
                                varargs[j - i3] = parameters2.jjtGetChild(j).getValue(ctx);
                                varargs[j - i3] = ELSupport.coerceToType(ctx, varargs[j - i3], target2);
                            }
                            params2[i3] = varargs;
                        }
                    } else {
                        params2[i3] = parameters2.jjtGetChild(i3).getValue(ctx);
                    }
                    params2[i3] = ELSupport.coerceToType(ctx, params2[i3], paramTypes[i3]);
                }
            }
            catch (ELException ele) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), ele);
            }
        }
        try {
            result2 = m.invoke(null, params2);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause2 = ite.getCause();
            if (cause2 instanceof ThreadDeath) {
                throw (ThreadDeath)cause2;
            }
            if (cause2 instanceof VirtualMachineError) {
                throw (VirtualMachineError)cause2;
            }
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), cause2);
        }
        return result2;
    }

    private boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

