/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.LambdaExpression;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.util.ExceptionUtils;
import org.apache.el.util.MessageFactory;

public class ELSupport {
    private static final Long ZERO = 0L;
    protected static final boolean COERCE_TO_ZERO;

    public static final int compare(ELContext ctx, Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1 || ELSupport.equals(ctx, obj0, obj1)) {
            return 0;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj0, BigDecimal.class);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj1, BigDecimal.class);
            return bd0.compareTo(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(ctx, obj0, Double.class);
            Double d1 = (Double)ELSupport.coerceToNumber(ctx, obj1, Double.class);
            return d0.compareTo(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(ctx, obj0, BigInteger.class);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(ctx, obj1, BigInteger.class);
            return bi0.compareTo(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(ctx, obj0, Long.class);
            Long l1 = (Long)ELSupport.coerceToNumber(ctx, obj1, Long.class);
            return l0.compareTo(l1);
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            return ELSupport.coerceToString(ctx, obj0).compareTo(ELSupport.coerceToString(ctx, obj1));
        }
        if (obj0 instanceof Comparable) {
            Comparable comparable = (Comparable)obj0;
            return obj1 != null ? comparable.compareTo(obj1) : 1;
        }
        if (obj1 instanceof Comparable) {
            Comparable comparable = (Comparable)obj1;
            return obj0 != null ? -comparable.compareTo(obj0) : -1;
        }
        throw new ELException(MessageFactory.get("error.compare", obj0, obj1));
    }

    public static final boolean equals(ELContext ctx, Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1) {
            return true;
        }
        if (obj0 == null || obj1 == null) {
            return false;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj0, BigDecimal.class);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj1, BigDecimal.class);
            return bd0.equals(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(ctx, obj0, Double.class);
            Double d1 = (Double)ELSupport.coerceToNumber(ctx, obj1, Double.class);
            return d0.equals(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(ctx, obj0, BigInteger.class);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(ctx, obj1, BigInteger.class);
            return bi0.equals(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(ctx, obj0, Long.class);
            Long l1 = (Long)ELSupport.coerceToNumber(ctx, obj1, Long.class);
            return l0.equals(l1);
        }
        if (obj0 instanceof Boolean || obj1 instanceof Boolean) {
            return ELSupport.coerceToBoolean(ctx, obj0, false).equals(ELSupport.coerceToBoolean(ctx, obj1, false));
        }
        if (obj0.getClass().isEnum()) {
            return obj0.equals(ELSupport.coerceToEnum(ctx, obj1, obj0.getClass()));
        }
        if (obj1.getClass().isEnum()) {
            return obj1.equals(ELSupport.coerceToEnum(ctx, obj0, obj1.getClass()));
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            int lexCompare = ELSupport.coerceToString(ctx, obj0).compareTo(ELSupport.coerceToString(ctx, obj1));
            return lexCompare == 0;
        }
        return obj0.equals(obj1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Enum<?> coerceToEnum(ELContext ctx, Object obj, Class type2) {
        Object result2;
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Object result3 = ctx.getELResolver().convertToType(ctx, obj, type2);
                if (ctx.isPropertyResolved()) {
                    Enum enum_ = (Enum)result3;
                    return enum_;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (type2.isAssignableFrom(obj.getClass())) {
            return (Enum)obj;
        }
        if (!(obj instanceof String)) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type2));
        }
        try {
            result2 = Enum.valueOf(type2, (String)obj);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type2));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Boolean coerceToBoolean(ELContext ctx, Object obj, boolean primitive) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Boolean result2 = ctx.getELResolver().convertToType(ctx, obj, Boolean.class);
                if (ctx.isPropertyResolved()) {
                    Boolean bl = result2;
                    return bl;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (!COERCE_TO_ZERO && !primitive && obj == null) {
            return null;
        }
        if (obj == null || "".equals(obj)) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), Boolean.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Character coerceToCharacter(ELContext ctx, Object obj) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Character result2 = ctx.getELResolver().convertToType(ctx, obj, Character.class);
                if (ctx.isPropertyResolved()) {
                    Character c = result2;
                    return c;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (obj == null || "".equals(obj)) {
            return Character.valueOf('\u0000');
        }
        if (obj instanceof String) {
            return Character.valueOf(((String)obj).charAt(0));
        }
        if (ELArithmetic.isNumber(obj)) {
            return Character.valueOf((char)((Number)obj).shortValue());
        }
        Class<?> objType = obj.getClass();
        if (obj instanceof Character) {
            return (Character)obj;
        }
        throw new ELException(MessageFactory.get("error.convert", obj, objType, Character.class));
    }

    protected static final Number coerceToNumber(Number number, Class<?> type2) throws ELException {
        if (Long.TYPE == type2 || Long.class.equals(type2)) {
            return number.longValue();
        }
        if (Double.TYPE == type2 || Double.class.equals(type2)) {
            return number.doubleValue();
        }
        if (Integer.TYPE == type2 || Integer.class.equals(type2)) {
            return number.intValue();
        }
        if (BigInteger.class.equals(type2)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            if (number instanceof BigInteger) {
                return number;
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (BigDecimal.class.equals(type2)) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (Byte.TYPE == type2 || Byte.class.equals(type2)) {
            return number.byteValue();
        }
        if (Short.TYPE == type2 || Short.class.equals(type2)) {
            return number.shortValue();
        }
        if (Float.TYPE == type2 || Float.class.equals(type2)) {
            return Float.valueOf(number.floatValue());
        }
        if (Number.class.equals(type2)) {
            return number;
        }
        throw new ELException(MessageFactory.get("error.convert", number, number.getClass(), type2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Number coerceToNumber(ELContext ctx, Object obj, Class<?> type2) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Object result2 = ctx.getELResolver().convertToType(ctx, obj, type2);
                if (ctx.isPropertyResolved()) {
                    Number number = (Number)result2;
                    return number;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (!COERCE_TO_ZERO && obj == null && !type2.isPrimitive()) {
            return null;
        }
        if (obj == null || "".equals(obj)) {
            return ELSupport.coerceToNumber(ZERO, type2);
        }
        if (obj instanceof String) {
            return ELSupport.coerceToNumber((String)obj, type2);
        }
        if (ELArithmetic.isNumber(obj)) {
            return ELSupport.coerceToNumber((Number)obj, type2);
        }
        if (obj instanceof Character) {
            return ELSupport.coerceToNumber((short)((Character)obj).charValue(), type2);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type2));
    }

    protected static final Number coerceToNumber(String val, Class<?> type2) throws ELException {
        if (Long.TYPE == type2 || Long.class.equals(type2)) {
            try {
                return Long.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (Integer.TYPE == type2 || Integer.class.equals(type2)) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (Double.TYPE == type2 || Double.class.equals(type2)) {
            try {
                return Double.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (BigInteger.class.equals(type2)) {
            try {
                return new BigInteger(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (BigDecimal.class.equals(type2)) {
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (Byte.TYPE == type2 || Byte.class.equals(type2)) {
            try {
                return Byte.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (Short.TYPE == type2 || Short.class.equals(type2)) {
            try {
                return Short.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        if (Float.TYPE == type2 || Float.class.equals(type2)) {
            try {
                return Float.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
            }
        }
        throw new ELException(MessageFactory.get("error.convert", val, String.class, type2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String coerceToString(ELContext ctx, Object obj) {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                String result2 = ctx.getELResolver().convertToType(ctx, obj, String.class);
                if (ctx.isPropertyResolved()) {
                    String string2 = result2;
                    return string2;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        try {
            return obj.toString();
        }
        catch (ELException e) {
            throw e;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            throw new ELException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T coerceToType(ELContext ctx, Object obj, Class<T> type2) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                T result2 = ctx.getELResolver().convertToType(ctx, obj, type2);
                if (ctx.isPropertyResolved()) {
                    T t = result2;
                    return t;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (type2 == null || Object.class.equals(type2) || obj != null && type2.isAssignableFrom(obj.getClass())) {
            Object result3 = obj;
            return (T)result3;
        }
        if (!(COERCE_TO_ZERO || obj != null || type2.isPrimitive() || String.class.isAssignableFrom(type2))) {
            return null;
        }
        if (String.class.equals(type2)) {
            String result4 = ELSupport.coerceToString(ctx, obj);
            return (T)result4;
        }
        if (ELArithmetic.isNumberType(type2)) {
            Number result5 = ELSupport.coerceToNumber(ctx, obj, type2);
            return (T)result5;
        }
        if (Character.class.equals(type2) || Character.TYPE == type2) {
            Character result6 = ELSupport.coerceToCharacter(ctx, obj);
            return (T)result6;
        }
        if (Boolean.class.equals(type2) || Boolean.TYPE == type2) {
            Boolean result7 = ELSupport.coerceToBoolean(ctx, obj, Boolean.TYPE == type2);
            return (T)result7;
        }
        if (type2.isEnum()) {
            Enum<?> result8 = ELSupport.coerceToEnum(ctx, obj, type2);
            return (T)result8;
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            PropertyEditor editor = PropertyEditorManager.findEditor(type2);
            if (editor == null) {
                if (str.isEmpty()) {
                    return null;
                }
                throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type2));
            }
            try {
                editor.setAsText(str);
                Object result9 = editor.getValue();
                return (T)result9;
            }
            catch (RuntimeException e) {
                if (str.isEmpty()) {
                    return null;
                }
                throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type2), e);
            }
        }
        if (obj instanceof Set && type2 == Map.class && ((Set)obj).isEmpty()) {
            Map result10 = Collections.EMPTY_MAP;
            return (T)result10;
        }
        if (type2.isArray() && obj.getClass().isArray()) {
            Object result11 = ELSupport.coerceToArray(ctx, obj, type2);
            return (T)result11;
        }
        if (obj instanceof LambdaExpression && ELSupport.isFunctionalInterface(type2)) {
            T result12 = ELSupport.coerceToFunctionalInterface(ctx, (LambdaExpression)obj, type2);
            return result12;
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type2));
    }

    private static Object coerceToArray(ELContext ctx, Object obj, Class<?> type2) {
        int size2 = Array.getLength(obj);
        Class<?> componentType = type2.getComponentType();
        Object result2 = Array.newInstance(componentType, size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            Array.set(result2, i2, ELSupport.coerceToType(ctx, Array.get(obj, i2), componentType));
        }
        return result2;
    }

    private static <T> T coerceToFunctionalInterface(ELContext ctx, LambdaExpression lambdaExpression, Class<T> type2) {
        Supplier<Object> proxy2 = () -> {
            Object result2 = Proxy.newProxyInstance(type2.getClassLoader(), new Class[]{type2}, (obj, method2, args2) -> {
                if (!Modifier.isAbstract(method2.getModifiers())) {
                    throw new ELException(MessageFactory.get("elSupport.coerce.nonAbstract", type2, method2));
                }
                if (ctx == null) {
                    return lambdaExpression.invoke(args2);
                }
                return lambdaExpression.invoke(ctx, args2);
            });
            return result2;
        };
        if (System.getSecurityManager() != null) {
            return (T)AccessController.doPrivileged(proxy2::get);
        }
        return (T)proxy2.get();
    }

    public static final boolean isBigDecimalOp(Object obj0, Object obj1) {
        return obj0 instanceof BigDecimal || obj1 instanceof BigDecimal;
    }

    public static final boolean isBigIntegerOp(Object obj0, Object obj1) {
        return obj0 instanceof BigInteger || obj1 instanceof BigInteger;
    }

    public static final boolean isDoubleOp(Object obj0, Object obj1) {
        return obj0 instanceof Double || obj1 instanceof Double || obj0 instanceof Float || obj1 instanceof Float;
    }

    public static final boolean isLongOp(Object obj0, Object obj1) {
        return obj0 instanceof Long || obj1 instanceof Long || obj0 instanceof Integer || obj1 instanceof Integer || obj0 instanceof Character || obj1 instanceof Character || obj0 instanceof Short || obj1 instanceof Short || obj0 instanceof Byte || obj1 instanceof Byte;
    }

    public static final boolean isStringFloat(String str) {
        int len = str.length();
        if (len > 1) {
            for (int i2 = 0; i2 < len; ++i2) {
                switch (str.charAt(i2)) {
                    case 'E': {
                        return true;
                    }
                    case 'e': {
                        return true;
                    }
                    case '.': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static boolean isFunctionalInterface(Class<?> type2) {
        Method[] methods2;
        if (!type2.isInterface()) {
            return false;
        }
        boolean foundAbstractMethod = false;
        for (Method method2 : methods2 = type2.getMethods()) {
            if (!Modifier.isAbstract(method2.getModifiers()) || ELSupport.overridesObjectMethod(method2)) continue;
            if (foundAbstractMethod) {
                return false;
            }
            foundAbstractMethod = true;
        }
        return foundAbstractMethod;
    }

    private static boolean overridesObjectMethod(Method method2) {
        return "equals".equals(method2.getName()) ? method2.getReturnType().equals(Boolean.TYPE) && method2.getParameterCount() == 1 && method2.getParameterTypes()[0].equals(Object.class) : ("hashCode".equals(method2.getName()) ? method2.getReturnType().equals(Integer.TYPE) && method2.getParameterCount() == 0 : "toString".equals(method2.getName()) && method2.getReturnType().equals(String.class) && method2.getParameterCount() == 0);
    }

    private ELSupport() {
    }

    static {
        String coerceToZeroStr = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "false")) : System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "false");
        COERCE_TO_ZERO = Boolean.parseBoolean(coerceToZeroStr);
    }
}

