/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.coyote.http2.HPackHuffman;
import org.apache.coyote.http2.Hpack;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

class HpackEncoder {
    private static final Log log = LogFactory.getLog(HpackEncoder.class);
    private static final StringManager sm = StringManager.getManager(HpackEncoder.class);
    private static final HpackHeaderFunction DEFAULT_HEADER_FUNCTION = new HpackHeaderFunction(){

        @Override
        public boolean shouldUseIndexing(String headerName, String value2) {
            switch (headerName) {
                case "content-length": 
                case "date": {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean shouldUseHuffman(String header, String value2) {
            return value2.length() > 5;
        }

        @Override
        public boolean shouldUseHuffman(String header) {
            return header.length() > 5;
        }
    };
    private int headersIterator = -1;
    private boolean firstPass = true;
    private MimeHeaders currentHeaders;
    private int entryPositionCounter;
    private int newMaxHeaderSize = -1;
    private int minNewMaxHeaderSize = -1;
    private static final Map<String, TableEntry[]> ENCODING_STATIC_TABLE;
    private final Deque<TableEntry> evictionQueue = new ArrayDeque<TableEntry>();
    private final Map<String, List<TableEntry>> dynamicTable = new HashMap<String, List<TableEntry>>();
    private int maxTableSize = 4096;
    private int currentTableSize;
    private final HpackHeaderFunction hpackHeaderFunction = DEFAULT_HEADER_FUNCTION;

    HpackEncoder() {
    }

    State encode(MimeHeaders headers, ByteBuffer target2) {
        int it = this.headersIterator;
        if (this.headersIterator == -1) {
            this.handleTableSizeChange(target2);
            it = 0;
            this.currentHeaders = headers;
        } else if (headers != this.currentHeaders) {
            throw new IllegalStateException();
        }
        while (it < this.currentHeaders.size()) {
            String headerName = headers.getName(it).toString().toLowerCase(Locale.US);
            boolean skip2 = false;
            if (this.firstPass) {
                if (headerName.charAt(0) != ':') {
                    skip2 = true;
                }
            } else if (headerName.charAt(0) == ':') {
                skip2 = true;
            }
            if (!skip2) {
                boolean canIndex;
                String val = headers.getValue(it).toString();
                if (log.isTraceEnabled()) {
                    log.trace(sm.getString("hpackEncoder.encodeHeader", headerName, val));
                }
                TableEntry tableEntry = this.findInTable(headerName, val);
                int required = 11 + headerName.length() + 1 + val.length();
                if (target2.remaining() < required) {
                    this.headersIterator = it;
                    return State.UNDERFLOW;
                }
                boolean bl = canIndex = this.hpackHeaderFunction.shouldUseIndexing(headerName, val) && headerName.length() + val.length() + 32 < this.maxTableSize;
                if (tableEntry == null && canIndex) {
                    target2.put((byte)64);
                    this.writeHuffmanEncodableName(target2, headerName);
                    this.writeHuffmanEncodableValue(target2, headerName, val);
                    this.addToDynamicTable(headerName, val);
                } else if (tableEntry == null) {
                    target2.put((byte)16);
                    this.writeHuffmanEncodableName(target2, headerName);
                    this.writeHuffmanEncodableValue(target2, headerName, val);
                } else if (val.equals(tableEntry.value)) {
                    target2.put((byte)-128);
                    Hpack.encodeInteger(target2, tableEntry.getPosition(), 7);
                } else if (canIndex) {
                    target2.put((byte)64);
                    Hpack.encodeInteger(target2, tableEntry.getPosition(), 6);
                    this.writeHuffmanEncodableValue(target2, headerName, val);
                    this.addToDynamicTable(headerName, val);
                } else {
                    target2.put((byte)16);
                    Hpack.encodeInteger(target2, tableEntry.getPosition(), 4);
                    this.writeHuffmanEncodableValue(target2, headerName, val);
                }
            }
            if (++it != this.currentHeaders.size() || !this.firstPass) continue;
            this.firstPass = false;
            it = 0;
        }
        this.headersIterator = -1;
        this.firstPass = true;
        return State.COMPLETE;
    }

    private void writeHuffmanEncodableName(ByteBuffer target2, String headerName) {
        if (this.hpackHeaderFunction.shouldUseHuffman(headerName) && HPackHuffman.encode(target2, headerName, true)) {
            return;
        }
        target2.put((byte)0);
        Hpack.encodeInteger(target2, headerName.length(), 7);
        for (int j = 0; j < headerName.length(); ++j) {
            target2.put((byte)Hpack.toLower(headerName.charAt(j)));
        }
    }

    private void writeHuffmanEncodableValue(ByteBuffer target2, String headerName, String val) {
        if (this.hpackHeaderFunction.shouldUseHuffman(headerName, val)) {
            if (!HPackHuffman.encode(target2, val, false)) {
                this.writeValueString(target2, val);
            }
        } else {
            this.writeValueString(target2, val);
        }
    }

    private void writeValueString(ByteBuffer target2, String val) {
        target2.put((byte)0);
        Hpack.encodeInteger(target2, val.length(), 7);
        for (int j = 0; j < val.length(); ++j) {
            target2.put((byte)val.charAt(j));
        }
    }

    private void addToDynamicTable(String headerName, String val) {
        int pos2 = this.entryPositionCounter++;
        DynamicTableEntry d = new DynamicTableEntry(headerName, val, -pos2);
        this.dynamicTable.computeIfAbsent(headerName, k -> new ArrayList(1)).add(d);
        this.evictionQueue.add(d);
        this.currentTableSize += d.getSize();
        this.runEvictionIfRequired();
        if (this.entryPositionCounter == Integer.MAX_VALUE) {
            this.preventPositionRollover();
        }
    }

    private void preventPositionRollover() {
        for (List<TableEntry> tableEntries : this.dynamicTable.values()) {
            for (TableEntry t : tableEntries) {
                t.position = t.getPosition();
            }
        }
        this.entryPositionCounter = 0;
    }

    private void runEvictionIfRequired() {
        while (this.currentTableSize > this.maxTableSize) {
            TableEntry next2 = this.evictionQueue.poll();
            if (next2 == null) {
                return;
            }
            this.currentTableSize -= next2.size;
            List<TableEntry> list2 = this.dynamicTable.get(next2.name);
            list2.remove(next2);
            if (!list2.isEmpty()) continue;
            this.dynamicTable.remove(next2.name);
        }
    }

    private TableEntry findInTable(String headerName, String value2) {
        List<TableEntry> dynamic;
        TableEntry[] staticTable = ENCODING_STATIC_TABLE.get(headerName);
        if (staticTable != null) {
            for (TableEntry st : staticTable) {
                if (st.value == null || !st.value.equals(value2)) continue;
                return st;
            }
        }
        if ((dynamic = this.dynamicTable.get(headerName)) != null) {
            for (TableEntry st : dynamic) {
                if (!st.value.equals(value2)) continue;
                return st;
            }
        }
        if (staticTable != null) {
            return staticTable[0];
        }
        return null;
    }

    public void setMaxTableSize(int newSize) {
        this.newMaxHeaderSize = newSize;
        this.minNewMaxHeaderSize = this.minNewMaxHeaderSize == -1 ? newSize : Math.min(newSize, this.minNewMaxHeaderSize);
    }

    private void handleTableSizeChange(ByteBuffer target2) {
        if (this.newMaxHeaderSize == -1) {
            return;
        }
        if (this.minNewMaxHeaderSize != this.newMaxHeaderSize) {
            target2.put((byte)32);
            Hpack.encodeInteger(target2, this.minNewMaxHeaderSize, 5);
        }
        target2.put((byte)32);
        Hpack.encodeInteger(target2, this.newMaxHeaderSize, 5);
        this.maxTableSize = this.newMaxHeaderSize;
        this.runEvictionIfRequired();
        this.newMaxHeaderSize = -1;
        this.minNewMaxHeaderSize = -1;
    }

    static {
        HashMap<String, TableEntry[]> map2 = new HashMap<String, TableEntry[]>();
        for (int i2 = 1; i2 < Hpack.STATIC_TABLE.length; ++i2) {
            Hpack.HeaderField m = Hpack.STATIC_TABLE[i2];
            TableEntry[] existing = (TableEntry[])map2.get(m.name);
            if (existing == null) {
                map2.put(m.name, new TableEntry[]{new TableEntry(m.name, m.value, i2)});
                continue;
            }
            TableEntry[] newEntry = new TableEntry[existing.length + 1];
            System.arraycopy(existing, 0, newEntry, 0, existing.length);
            newEntry[existing.length] = new TableEntry(m.name, m.value, i2);
            map2.put(m.name, newEntry);
        }
        ENCODING_STATIC_TABLE = Collections.unmodifiableMap(map2);
    }

    private static interface HpackHeaderFunction {
        public boolean shouldUseIndexing(String var1, String var2);

        public boolean shouldUseHuffman(String var1, String var2);

        public boolean shouldUseHuffman(String var1);
    }

    private static class TableEntry {
        private final String name;
        private final String value;
        private final int size;
        private int position;

        private TableEntry(String name2, String value2, int position) {
            this.name = name2;
            this.value = value2;
            this.position = position;
            this.size = value2 != null ? 32 + name2.length() + value2.length() : -1;
        }

        int getPosition() {
            return this.position;
        }

        int getSize() {
            return this.size;
        }
    }

    static enum State {
        COMPLETE,
        UNDERFLOW;

    }

    private class DynamicTableEntry
    extends TableEntry {
        private DynamicTableEntry(String name2, String value2, int position) {
            super(name2, value2, position);
        }

        @Override
        int getPosition() {
            return super.getPosition() + HpackEncoder.this.entryPositionCounter + Hpack.STATIC_TABLE_LENGTH;
        }
    }
}

