/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import org.apache.coyote.http2.HpackException;
import org.apache.tomcat.util.res.StringManager;

final class Hpack {
    private static final StringManager sm = StringManager.getManager(Hpack.class);
    private static final byte LOWER_DIFF = 32;
    static final int DEFAULT_TABLE_SIZE = 4096;
    private static final int MAX_INTEGER_OCTETS = 8;
    private static final int[] PREFIX_TABLE = new int[32];
    static final HeaderField[] STATIC_TABLE;
    static final int STATIC_TABLE_LENGTH;

    static int decodeInteger(ByteBuffer source2, int n) throws HpackException {
        byte b2;
        if (source2.remaining() == 0) {
            return -1;
        }
        int count2 = 1;
        int sp = source2.position();
        int mask = PREFIX_TABLE[n];
        int i2 = mask & source2.get();
        if (i2 < PREFIX_TABLE[n]) {
            return i2;
        }
        int m = 0;
        do {
            if (count2++ > 8) {
                throw new HpackException(sm.getString("hpack.integerEncodedOverTooManyOctets", 8));
            }
            if (source2.remaining() == 0) {
                source2.position(sp);
                return -1;
            }
            b2 = source2.get();
            i2 += (b2 & 0x7F) * (PREFIX_TABLE[m] + 1);
            m += 7;
        } while ((b2 & 0x80) == 128);
        return i2;
    }

    static void encodeInteger(ByteBuffer source2, int value2, int n) {
        int twoNminus1 = PREFIX_TABLE[n];
        int pos2 = source2.position() - 1;
        if (value2 < twoNminus1) {
            source2.put(pos2, (byte)(source2.get(pos2) | value2));
        } else {
            source2.put(pos2, (byte)(source2.get(pos2) | twoNminus1));
            value2 -= twoNminus1;
            while (value2 >= 128) {
                source2.put((byte)(value2 % 128 + 128));
                value2 /= 128;
            }
            source2.put((byte)value2);
        }
    }

    static char toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private Hpack() {
    }

    static {
        for (int i2 = 0; i2 < 32; ++i2) {
            int n = 0;
            for (int j = 0; j < i2; ++j) {
                n <<= 1;
                n |= 1;
            }
            Hpack.PREFIX_TABLE[i2] = n;
        }
        HeaderField[] fields2 = new HeaderField[62];
        fields2[1] = new HeaderField(":authority", null);
        fields2[2] = new HeaderField(":method", "GET");
        fields2[3] = new HeaderField(":method", "POST");
        fields2[4] = new HeaderField(":path", "/");
        fields2[5] = new HeaderField(":path", "/index.html");
        fields2[6] = new HeaderField(":scheme", "http");
        fields2[7] = new HeaderField(":scheme", "https");
        fields2[8] = new HeaderField(":status", "200");
        fields2[9] = new HeaderField(":status", "204");
        fields2[10] = new HeaderField(":status", "206");
        fields2[11] = new HeaderField(":status", "304");
        fields2[12] = new HeaderField(":status", "400");
        fields2[13] = new HeaderField(":status", "404");
        fields2[14] = new HeaderField(":status", "500");
        fields2[15] = new HeaderField("accept-charset", null);
        fields2[16] = new HeaderField("accept-encoding", "gzip, deflate");
        fields2[17] = new HeaderField("accept-language", null);
        fields2[18] = new HeaderField("accept-ranges", null);
        fields2[19] = new HeaderField("accept", null);
        fields2[20] = new HeaderField("access-control-allow-origin", null);
        fields2[21] = new HeaderField("age", null);
        fields2[22] = new HeaderField("allow", null);
        fields2[23] = new HeaderField("authorization", null);
        fields2[24] = new HeaderField("cache-control", null);
        fields2[25] = new HeaderField("content-disposition", null);
        fields2[26] = new HeaderField("content-encoding", null);
        fields2[27] = new HeaderField("content-language", null);
        fields2[28] = new HeaderField("content-length", null);
        fields2[29] = new HeaderField("content-location", null);
        fields2[30] = new HeaderField("content-range", null);
        fields2[31] = new HeaderField("content-type", null);
        fields2[32] = new HeaderField("cookie", null);
        fields2[33] = new HeaderField("date", null);
        fields2[34] = new HeaderField("etag", null);
        fields2[35] = new HeaderField("expect", null);
        fields2[36] = new HeaderField("expires", null);
        fields2[37] = new HeaderField("from", null);
        fields2[38] = new HeaderField("host", null);
        fields2[39] = new HeaderField("if-match", null);
        fields2[40] = new HeaderField("if-modified-since", null);
        fields2[41] = new HeaderField("if-none-match", null);
        fields2[42] = new HeaderField("if-range", null);
        fields2[43] = new HeaderField("if-unmodified-since", null);
        fields2[44] = new HeaderField("last-modified", null);
        fields2[45] = new HeaderField("link", null);
        fields2[46] = new HeaderField("location", null);
        fields2[47] = new HeaderField("max-forwards", null);
        fields2[48] = new HeaderField("proxy-authenticate", null);
        fields2[49] = new HeaderField("proxy-authorization", null);
        fields2[50] = new HeaderField("range", null);
        fields2[51] = new HeaderField("referer", null);
        fields2[52] = new HeaderField("refresh", null);
        fields2[53] = new HeaderField("retry-after", null);
        fields2[54] = new HeaderField("server", null);
        fields2[55] = new HeaderField("set-cookie", null);
        fields2[56] = new HeaderField("strict-transport-security", null);
        fields2[57] = new HeaderField("transfer-encoding", null);
        fields2[58] = new HeaderField("user-agent", null);
        fields2[59] = new HeaderField("vary", null);
        fields2[60] = new HeaderField("via", null);
        fields2[61] = new HeaderField("www-authenticate", null);
        STATIC_TABLE = fields2;
        STATIC_TABLE_LENGTH = STATIC_TABLE.length - 1;
    }

    static class HeaderField {
        final String name;
        final String value;
        final int size;

        HeaderField(String name2, String value2) {
            this.name = name2;
            this.value = value2;
            this.size = value2 != null ? 32 + name2.length() + value2.length() : -1;
        }
    }
}

