/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Map;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionSettingsBase;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Setting;

class ConnectionSettingsLocal
extends ConnectionSettingsBase<IllegalArgumentException> {
    private static final String ENDPOINT_NAME = "Local(client->server)";
    private boolean sendInProgress = false;

    ConnectionSettingsLocal(String connectionId) {
        super(connectionId);
    }

    @Override
    final synchronized void set(Setting setting, Long value2) {
        this.checkSend();
        if (((Long)this.current.get((Object)setting)).longValue() == value2.longValue()) {
            this.pending.remove((Object)setting);
        } else {
            this.pending.put(setting, value2);
        }
    }

    final synchronized byte[] getSettingsFrameForPending() {
        this.checkSend();
        int payloadSize = this.pending.size() * 6;
        byte[] result2 = new byte[9 + payloadSize];
        ByteUtil.setThreeBytes(result2, 0, payloadSize);
        result2[3] = FrameType.SETTINGS.getIdByte();
        int pos2 = 9;
        for (Map.Entry setting : this.pending.entrySet()) {
            ByteUtil.setTwoBytes(result2, pos2, ((Setting)((Object)setting.getKey())).getId());
            ByteUtil.setFourBytes(result2, pos2 += 2, (Long)setting.getValue());
            pos2 += 4;
        }
        this.sendInProgress = true;
        return result2;
    }

    final synchronized boolean ack() {
        if (this.sendInProgress) {
            this.sendInProgress = false;
            this.current.putAll(this.pending);
            this.pending.clear();
            return true;
        }
        return false;
    }

    private void checkSend() {
        if (this.sendInProgress) {
            throw new IllegalStateException();
        }
    }

    @Override
    final void throwException(String msg, Http2Error error2) throws IllegalArgumentException {
        throw new IllegalArgumentException(msg);
    }

    @Override
    final String getEndpointName() {
        return ENDPOINT_NAME;
    }
}

