/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;

public class IdentityOutputFilter
implements OutputFilter {
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected HttpOutputBuffer buffer;

    @Override
    public int doWrite(ByteBuffer chunk2) throws IOException {
        int result2 = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                result2 = chunk2.remaining();
                if ((long)result2 > this.remaining) {
                    chunk2.limit(chunk2.position() + (int)this.remaining);
                    result2 = (int)this.remaining;
                    this.remaining = 0L;
                } else {
                    this.remaining -= (long)result2;
                }
                this.buffer.doWrite(chunk2);
            } else {
                chunk2.position(0);
                chunk2.limit(0);
                result2 = -1;
            }
        } else {
            result2 = chunk2.remaining();
            this.buffer.doWrite(chunk2);
            result2 -= chunk2.remaining();
        }
        return result2;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
        this.remaining = this.contentLength = response.getContentLengthLong();
    }

    @Override
    public void setBuffer(HttpOutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        this.buffer.end();
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }
}

