/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.coyote.Processor;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

public abstract class AbstractProcessorLight
implements Processor {
    private Set<DispatchType> dispatches = new CopyOnWriteArraySet<DispatchType>();

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<?> socketWrapper, SocketEvent status2) throws IOException {
        AbstractEndpoint.Handler.SocketState state2 = AbstractEndpoint.Handler.SocketState.CLOSED;
        Iterator<DispatchType> dispatches = null;
        do {
            if (dispatches != null) {
                DispatchType nextDispatch = (DispatchType)((Object)dispatches.next());
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace("Processing dispatch type: [" + String.valueOf((Object)nextDispatch) + "]");
                }
                state2 = this.dispatch(nextDispatch.getSocketStatus());
                if (!dispatches.hasNext()) {
                    state2 = this.checkForPipelinedData(state2, socketWrapper);
                }
            } else if (status2 != SocketEvent.DISCONNECT) {
                if (this.isAsync() || this.isUpgrade() || state2 == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    state2 = this.dispatch(status2);
                    state2 = this.checkForPipelinedData(state2, socketWrapper);
                } else if (status2 == SocketEvent.OPEN_WRITE) {
                    state2 = AbstractEndpoint.Handler.SocketState.LONG;
                } else if (status2 == SocketEvent.OPEN_READ) {
                    state2 = this.service(socketWrapper);
                } else if (status2 == SocketEvent.CONNECT_FAIL) {
                    this.logAccess(socketWrapper);
                } else {
                    state2 = AbstractEndpoint.Handler.SocketState.CLOSED;
                }
            }
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Socket: [" + String.valueOf(socketWrapper) + "], Status in: [" + String.valueOf((Object)status2) + "], State out: [" + String.valueOf((Object)state2) + "]");
            }
            if (this.isAsync() && state2 != AbstractEndpoint.Handler.SocketState.CLOSED) {
                state2 = this.asyncPostProcess();
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace("Socket: [" + String.valueOf(socketWrapper) + "], State after async post processing: [" + String.valueOf((Object)state2) + "]");
                }
            }
            if (dispatches != null && dispatches.hasNext()) continue;
            dispatches = this.getIteratorAndClearDispatches();
        } while (state2 == AbstractEndpoint.Handler.SocketState.ASYNC_END || dispatches != null && state2 != AbstractEndpoint.Handler.SocketState.CLOSED);
        return state2;
    }

    private AbstractEndpoint.Handler.SocketState checkForPipelinedData(AbstractEndpoint.Handler.SocketState inState, SocketWrapperBase<?> socketWrapper) throws IOException {
        if (inState == AbstractEndpoint.Handler.SocketState.OPEN) {
            return this.service(socketWrapper);
        }
        return inState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatch(DispatchType dispatchType) {
        Set<DispatchType> set2 = this.dispatches;
        synchronized (set2) {
            this.dispatches.add(dispatchType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DispatchType> getIteratorAndClearDispatches() {
        Iterator<DispatchType> result2;
        Set<DispatchType> set2 = this.dispatches;
        synchronized (set2) {
            result2 = this.dispatches.iterator();
            if (result2.hasNext()) {
                this.dispatches.clear();
            } else {
                result2 = null;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDispatches() {
        Set<DispatchType> set2 = this.dispatches;
        synchronized (set2) {
            this.dispatches.clear();
        }
    }

    protected void logAccess(SocketWrapperBase<?> socketWrapper) throws IOException {
    }

    protected abstract AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> var1) throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState dispatch(SocketEvent var1) throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState asyncPostProcess();

    protected abstract Log getLog();
}

