/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.Serializable;
import java.util.function.Function;
import java.util.logging.LogRecord;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

final class LogAdapter {
    private static final boolean log4jSpiPresent = LogAdapter.isPresent("org.apache.logging.log4j.spi.ExtendedLogger");
    private static final boolean log4jSlf4jProviderPresent = LogAdapter.isPresent("org.apache.logging.slf4j.SLF4JProvider");
    private static final boolean slf4jSpiPresent = LogAdapter.isPresent("org.slf4j.spi.LocationAwareLogger");
    private static final boolean slf4jApiPresent = LogAdapter.isPresent("org.slf4j.Logger");
    private static final Function<String, Log> createLog = log4jSpiPresent ? (log4jSlf4jProviderPresent && slf4jSpiPresent ? Slf4jAdapter::createLocationAwareLog : Log4jAdapter::createLog) : (slf4jSpiPresent ? Slf4jAdapter::createLocationAwareLog : (slf4jApiPresent ? Slf4jAdapter::createLog : JavaUtilAdapter::createLog));

    private LogAdapter() {
    }

    public static Log createLog(String name2) {
        return createLog.apply(name2);
    }

    private static boolean isPresent(String className) {
        try {
            Class.forName(className, false, LogAdapter.class.getClassLoader());
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static class LocationResolvingLogRecord
    extends LogRecord {
        private static final String FQCN = JavaUtilLog.class.getName();
        private volatile boolean resolved;

        public LocationResolvingLogRecord(java.util.logging.Level level2, String msg) {
            super(level2, msg);
        }

        @Override
        public String getSourceClassName() {
            if (!this.resolved) {
                this.resolve();
            }
            return super.getSourceClassName();
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            super.setSourceClassName(sourceClassName);
            this.resolved = true;
        }

        @Override
        public String getSourceMethodName() {
            if (!this.resolved) {
                this.resolve();
            }
            return super.getSourceMethodName();
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            super.setSourceMethodName(sourceMethodName);
            this.resolved = true;
        }

        private void resolve() {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            String sourceClassName = null;
            String sourceMethodName = null;
            boolean found = false;
            for (StackTraceElement element : stack) {
                String className = element.getClassName();
                if (FQCN.equals(className)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                sourceClassName = className;
                sourceMethodName = element.getMethodName();
                break;
            }
            this.setSourceClassName(sourceClassName);
            this.setSourceMethodName(sourceMethodName);
        }

        protected Object writeReplace() {
            LogRecord serialized = new LogRecord(this.getLevel(), this.getMessage());
            serialized.setLoggerName(this.getLoggerName());
            serialized.setResourceBundle(this.getResourceBundle());
            serialized.setResourceBundleName(this.getResourceBundleName());
            serialized.setSourceClassName(this.getSourceClassName());
            serialized.setSourceMethodName(this.getSourceMethodName());
            serialized.setSequenceNumber(this.getSequenceNumber());
            serialized.setParameters(this.getParameters());
            serialized.setLongThreadID(this.getLongThreadID());
            serialized.setInstant(this.getInstant());
            serialized.setThrown(this.getThrown());
            return serialized;
        }
    }

    private static class JavaUtilLog
    implements Log,
    Serializable {
        private final String name;
        private final transient java.util.logging.Logger logger;

        public JavaUtilLog(String name2) {
            this.name = name2;
            this.logger = java.util.logging.Logger.getLogger(name2);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.SEVERE);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.WARNING);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.INFO);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.FINE);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.FINEST);
        }

        @Override
        public void fatal(Object message2) {
            this.error(message2);
        }

        @Override
        public void fatal(Object message2, Throwable exception2) {
            this.error(message2, exception2);
        }

        @Override
        public void error(Object message2) {
            this.log(java.util.logging.Level.SEVERE, message2, null);
        }

        @Override
        public void error(Object message2, Throwable exception2) {
            this.log(java.util.logging.Level.SEVERE, message2, exception2);
        }

        @Override
        public void warn(Object message2) {
            this.log(java.util.logging.Level.WARNING, message2, null);
        }

        @Override
        public void warn(Object message2, Throwable exception2) {
            this.log(java.util.logging.Level.WARNING, message2, exception2);
        }

        @Override
        public void info(Object message2) {
            this.log(java.util.logging.Level.INFO, message2, null);
        }

        @Override
        public void info(Object message2, Throwable exception2) {
            this.log(java.util.logging.Level.INFO, message2, exception2);
        }

        @Override
        public void debug(Object message2) {
            this.log(java.util.logging.Level.FINE, message2, null);
        }

        @Override
        public void debug(Object message2, Throwable exception2) {
            this.log(java.util.logging.Level.FINE, message2, exception2);
        }

        @Override
        public void trace(Object message2) {
            this.log(java.util.logging.Level.FINEST, message2, null);
        }

        @Override
        public void trace(Object message2, Throwable exception2) {
            this.log(java.util.logging.Level.FINEST, message2, exception2);
        }

        private void log(java.util.logging.Level level2, Object message2, Throwable exception2) {
            if (this.logger.isLoggable(level2)) {
                LogRecord rec;
                if (message2 instanceof LogRecord) {
                    LogRecord logRecord;
                    rec = logRecord = (LogRecord)message2;
                } else {
                    rec = new LocationResolvingLogRecord(level2, String.valueOf(message2));
                    rec.setLoggerName(this.name);
                    rec.setResourceBundleName(this.logger.getResourceBundleName());
                    rec.setResourceBundle(this.logger.getResourceBundle());
                    rec.setThrown(exception2);
                }
                this.logger.log(rec);
            }
        }

        protected Object readResolve() {
            return new JavaUtilLog(this.name);
        }
    }

    private static class Slf4jLocationAwareLog
    extends Slf4jLog<LocationAwareLogger>
    implements Serializable {
        private static final String FQCN = Slf4jLocationAwareLog.class.getName();

        public Slf4jLocationAwareLog(LocationAwareLogger logger) {
            super(logger);
        }

        @Override
        public void fatal(Object message2) {
            this.error(message2);
        }

        @Override
        public void fatal(Object message2, Throwable exception2) {
            this.error(message2, exception2);
        }

        @Override
        public void error(Object message2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isErrorEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 40, String.valueOf(message2), null, null);
            }
        }

        @Override
        public void error(Object message2, Throwable exception2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isErrorEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 40, String.valueOf(message2), null, exception2);
            }
        }

        @Override
        public void warn(Object message2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isWarnEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 30, String.valueOf(message2), null, null);
            }
        }

        @Override
        public void warn(Object message2, Throwable exception2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isWarnEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 30, String.valueOf(message2), null, exception2);
            }
        }

        @Override
        public void info(Object message2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isInfoEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 20, String.valueOf(message2), null, null);
            }
        }

        @Override
        public void info(Object message2, Throwable exception2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isInfoEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 20, String.valueOf(message2), null, exception2);
            }
        }

        @Override
        public void debug(Object message2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isDebugEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 10, String.valueOf(message2), null, null);
            }
        }

        @Override
        public void debug(Object message2, Throwable exception2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isDebugEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 10, String.valueOf(message2), null, exception2);
            }
        }

        @Override
        public void trace(Object message2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isTraceEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 0, String.valueOf(message2), null, null);
            }
        }

        @Override
        public void trace(Object message2, Throwable exception2) {
            if (message2 instanceof String || ((LocationAwareLogger)this.logger).isTraceEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 0, String.valueOf(message2), null, exception2);
            }
        }

        @Override
        protected Object readResolve() {
            return Slf4jAdapter.createLocationAwareLog(this.name);
        }
    }

    private static class Slf4jLog<T extends Logger>
    implements Log,
    Serializable {
        protected final String name;
        protected final transient T logger;

        public Slf4jLog(T logger) {
            this.name = logger.getName();
            this.logger = logger;
        }

        @Override
        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void fatal(Object message2) {
            this.error(message2);
        }

        @Override
        public void fatal(Object message2, Throwable exception2) {
            this.error(message2, exception2);
        }

        @Override
        public void error(Object message2) {
            if (message2 instanceof String || this.logger.isErrorEnabled()) {
                this.logger.error(String.valueOf(message2));
            }
        }

        @Override
        public void error(Object message2, Throwable exception2) {
            if (message2 instanceof String || this.logger.isErrorEnabled()) {
                this.logger.error(String.valueOf(message2), exception2);
            }
        }

        @Override
        public void warn(Object message2) {
            if (message2 instanceof String || this.logger.isWarnEnabled()) {
                this.logger.warn(String.valueOf(message2));
            }
        }

        @Override
        public void warn(Object message2, Throwable exception2) {
            if (message2 instanceof String || this.logger.isWarnEnabled()) {
                this.logger.warn(String.valueOf(message2), exception2);
            }
        }

        @Override
        public void info(Object message2) {
            if (message2 instanceof String || this.logger.isInfoEnabled()) {
                this.logger.info(String.valueOf(message2));
            }
        }

        @Override
        public void info(Object message2, Throwable exception2) {
            if (message2 instanceof String || this.logger.isInfoEnabled()) {
                this.logger.info(String.valueOf(message2), exception2);
            }
        }

        @Override
        public void debug(Object message2) {
            if (message2 instanceof String || this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(message2));
            }
        }

        @Override
        public void debug(Object message2, Throwable exception2) {
            if (message2 instanceof String || this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(message2), exception2);
            }
        }

        @Override
        public void trace(Object message2) {
            if (message2 instanceof String || this.logger.isTraceEnabled()) {
                this.logger.trace(String.valueOf(message2));
            }
        }

        @Override
        public void trace(Object message2, Throwable exception2) {
            if (message2 instanceof String || this.logger.isTraceEnabled()) {
                this.logger.trace(String.valueOf(message2), exception2);
            }
        }

        protected Object readResolve() {
            return Slf4jAdapter.createLog(this.name);
        }
    }

    private static class Log4jLog
    implements Log,
    Serializable {
        private static final String FQCN = Log4jLog.class.getName();
        private static final LoggerContext loggerContext = LogManager.getContext(Log4jLog.class.getClassLoader(), false);
        private final String name;
        private final transient ExtendedLogger logger;

        public Log4jLog(String name2) {
            this.name = name2;
            LoggerContext context = loggerContext;
            if (context == null) {
                context = LogManager.getContext(Log4jLog.class.getClassLoader(), false);
            }
            this.logger = context.getLogger(name2);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.logger.isEnabled(Level.FATAL);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isEnabled(Level.ERROR);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isEnabled(Level.WARN);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isEnabled(Level.INFO);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isEnabled(Level.DEBUG);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isEnabled(Level.TRACE);
        }

        @Override
        public void fatal(Object message2) {
            this.log(Level.FATAL, message2, null);
        }

        @Override
        public void fatal(Object message2, Throwable exception2) {
            this.log(Level.FATAL, message2, exception2);
        }

        @Override
        public void error(Object message2) {
            this.log(Level.ERROR, message2, null);
        }

        @Override
        public void error(Object message2, Throwable exception2) {
            this.log(Level.ERROR, message2, exception2);
        }

        @Override
        public void warn(Object message2) {
            this.log(Level.WARN, message2, null);
        }

        @Override
        public void warn(Object message2, Throwable exception2) {
            this.log(Level.WARN, message2, exception2);
        }

        @Override
        public void info(Object message2) {
            this.log(Level.INFO, message2, null);
        }

        @Override
        public void info(Object message2, Throwable exception2) {
            this.log(Level.INFO, message2, exception2);
        }

        @Override
        public void debug(Object message2) {
            this.log(Level.DEBUG, message2, null);
        }

        @Override
        public void debug(Object message2, Throwable exception2) {
            this.log(Level.DEBUG, message2, exception2);
        }

        @Override
        public void trace(Object message2) {
            this.log(Level.TRACE, message2, null);
        }

        @Override
        public void trace(Object message2, Throwable exception2) {
            this.log(Level.TRACE, message2, exception2);
        }

        private void log(Level level2, Object message2, Throwable exception2) {
            if (message2 instanceof String) {
                String text = (String)message2;
                if (exception2 != null) {
                    this.logger.logIfEnabled(FQCN, level2, (Marker)null, text, exception2);
                } else {
                    this.logger.logIfEnabled(FQCN, level2, null, text);
                }
            } else {
                this.logger.logIfEnabled(FQCN, level2, null, message2, exception2);
            }
        }

        protected Object readResolve() {
            return new Log4jLog(this.name);
        }
    }

    private static class JavaUtilAdapter {
        private JavaUtilAdapter() {
        }

        public static Log createLog(String name2) {
            return new JavaUtilLog(name2);
        }
    }

    private static class Slf4jAdapter {
        private Slf4jAdapter() {
        }

        public static Log createLocationAwareLog(String name2) {
            Slf4jLocationAwareLog slf4jLocationAwareLog;
            Logger logger = LoggerFactory.getLogger(name2);
            if (logger instanceof LocationAwareLogger) {
                LocationAwareLogger locationAwareLogger = (LocationAwareLogger)logger;
                slf4jLocationAwareLog = new Slf4jLocationAwareLog(locationAwareLogger);
            } else {
                slf4jLocationAwareLog = new Slf4jLog(logger);
            }
            return slf4jLocationAwareLog;
        }

        public static Log createLog(String name2) {
            return new Slf4jLog<Logger>(LoggerFactory.getLogger(name2));
        }
    }

    private static class Log4jAdapter {
        private Log4jAdapter() {
        }

        public static Log createLog(String name2) {
            return new Log4jLog(name2);
        }
    }
}

