/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DurationFormatUtils {
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTES = 60;
    private static final int HOURS_PER_DAY = 24;
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    static final String y = "y";
    static final String M = "M";
    static final String d = "d";
    static final String H = "H";
    static final String m = "m";
    static final String s = "s";
    static final String S = "S";

    static String format(Token[] tokens, long years, long months, long days, long hours, long minutes, long seconds, long milliseconds, boolean padWithZeros) {
        StringBuilder buffer = new StringBuilder();
        boolean lastOutputSeconds = false;
        boolean lastOutputZero = false;
        int optionalStart = -1;
        boolean firstOptionalNonLiteral = false;
        int optionalIndex = -1;
        boolean inOptional = false;
        for (Token token2 : tokens) {
            Object value2 = token2.getValue();
            boolean isLiteral = value2 instanceof StringBuilder;
            int count2 = token2.getCount();
            if (optionalIndex != token2.optionalIndex) {
                optionalIndex = token2.optionalIndex;
                if (optionalIndex > -1) {
                    optionalStart = buffer.length();
                    lastOutputZero = false;
                    inOptional = true;
                    firstOptionalNonLiteral = false;
                } else {
                    inOptional = false;
                }
            }
            if (isLiteral) {
                if (!inOptional || !lastOutputZero) {
                    buffer.append(value2.toString());
                }
            } else if (value2.equals(y)) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = years == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(years, padWithZeros, count2));
                }
            } else if (value2.equals(M)) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = months == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(months, padWithZeros, count2));
                }
            } else if (value2.equals(d)) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = days == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(days, padWithZeros, count2));
                }
            } else if (value2.equals(H)) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = hours == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(hours, padWithZeros, count2));
                }
            } else if (value2.equals(m)) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = minutes == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(minutes, padWithZeros, count2));
                }
            } else if (value2.equals(s)) {
                lastOutputSeconds = true;
                boolean bl = lastOutputZero = seconds == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(seconds, padWithZeros, count2));
                }
            } else if (value2.equals(S)) {
                boolean bl = lastOutputZero = milliseconds == 0L;
                if (!inOptional || !lastOutputZero) {
                    if (lastOutputSeconds) {
                        int width = padWithZeros ? Math.max(3, count2) : 3;
                        buffer.append(DurationFormatUtils.paddedValue(milliseconds, true, width));
                    } else {
                        buffer.append(DurationFormatUtils.paddedValue(milliseconds, padWithZeros, count2));
                    }
                }
                lastOutputSeconds = false;
            }
            if (!inOptional || isLiteral || firstOptionalNonLiteral) continue;
            firstOptionalNonLiteral = true;
            if (!lastOutputZero) continue;
            buffer.delete(optionalStart, buffer.length());
        }
        return buffer.toString();
    }

    public static String formatDuration(long durationMillis, String format) {
        return DurationFormatUtils.formatDuration(durationMillis, format, true);
    }

    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, durationMillis, "durationMillis must not be negative");
        Token[] tokens = DurationFormatUtils.lexx(format);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long milliseconds = durationMillis;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = milliseconds / 86400000L;
            milliseconds -= days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = milliseconds / 3600000L;
            milliseconds -= hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = milliseconds / 60000L;
            milliseconds -= minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = milliseconds / 1000L;
            milliseconds -= seconds * 1000L;
        }
        return DurationFormatUtils.format(tokens, 0L, 0L, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String tmp;
        String duration = DurationFormatUtils.formatDuration(durationMillis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            duration = " " + duration;
            tmp = StringUtils.replaceOnce(duration, " 0 days", "");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, " 0 minutes", "");
            }
            if (!duration.isEmpty()) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (tmp = StringUtils.replaceOnce(duration, " 0 seconds", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 minutes", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
            duration = StringUtils.replaceOnce(tmp, " 0 days", "");
        }
        duration = " " + duration;
        duration = StringUtils.replaceOnce(duration, " 1 seconds", " 1 second");
        duration = StringUtils.replaceOnce(duration, " 1 minutes", " 1 minute");
        duration = StringUtils.replaceOnce(duration, " 1 hours", " 1 hour");
        duration = StringUtils.replaceOnce(duration, " 1 days", " 1 day");
        return duration.trim();
    }

    public static String formatPeriod(long startMillis, long endMillis, String format) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, format, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format, boolean padWithZeros, TimeZone timezone) {
        Validate.isTrue(startMillis <= endMillis, "startMillis must not be greater than endMillis", new Object[0]);
        Token[] tokens = DurationFormatUtils.lexx(format);
        Calendar start2 = Calendar.getInstance(timezone);
        start2.setTime(new Date(startMillis));
        Calendar end2 = Calendar.getInstance(timezone);
        end2.setTime(new Date(endMillis));
        long milliseconds = end2.get(14) - start2.get(14);
        int seconds = end2.get(13) - start2.get(13);
        int minutes = end2.get(12) - start2.get(12);
        int hours = end2.get(11) - start2.get(11);
        int days = end2.get(5) - start2.get(5);
        int months = end2.get(2) - start2.get(2);
        int years = end2.get(1) - start2.get(1);
        while (milliseconds < 0L) {
            milliseconds += 1000L;
            --seconds;
        }
        while (seconds < 0) {
            seconds += 60;
            --minutes;
        }
        while (minutes < 0) {
            minutes += 60;
            --hours;
        }
        while (hours < 0) {
            hours += 24;
            --days;
        }
        if (Token.containsTokenWithValue(tokens, M)) {
            while (days < 0) {
                days += start2.getActualMaximum(5);
                --months;
                start2.add(2, 1);
            }
            while (months < 0) {
                months += 12;
                --years;
            }
            if (!Token.containsTokenWithValue(tokens, y) && years != 0) {
                while (years != 0) {
                    months += 12 * years;
                    years = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokens, y)) {
                int target2 = end2.get(1);
                if (months < 0) {
                    --target2;
                }
                while (start2.get(1) != target2) {
                    days += start2.getActualMaximum(6) - start2.get(6);
                    if (start2 instanceof GregorianCalendar && start2.get(2) == 1 && start2.get(5) == 29) {
                        ++days;
                    }
                    start2.add(1, 1);
                    days += start2.get(6);
                }
                years = 0;
            }
            while (start2.get(2) != end2.get(2)) {
                days += start2.getActualMaximum(5);
                start2.add(2, 1);
            }
            months = 0;
            while (days < 0) {
                days += start2.getActualMaximum(5);
                --months;
                start2.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokens, d)) {
            hours += 24 * days;
            days = 0;
        }
        if (!Token.containsTokenWithValue(tokens, H)) {
            minutes += 60 * hours;
            hours = 0;
        }
        if (!Token.containsTokenWithValue(tokens, m)) {
            seconds += 60 * minutes;
            minutes = 0;
        }
        if (!Token.containsTokenWithValue(tokens, s)) {
            milliseconds += 1000L * (long)seconds;
            seconds = 0;
        }
        return DurationFormatUtils.format(tokens, years, months, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    public static String formatPeriodISO(long startMillis, long endMillis) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    static Token[] lexx(String format) {
        ArrayList<Token> list2 = new ArrayList<Token>(format.length());
        boolean inLiteral = false;
        StringBuilder buffer = null;
        Token previous = null;
        boolean inOptional = false;
        int optionalIndex = -1;
        for (int i2 = 0; i2 < format.length(); ++i2) {
            char ch = format.charAt(i2);
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            String value2 = null;
            switch (ch) {
                case '[': {
                    if (inOptional) {
                        throw new IllegalArgumentException("Nested optional block at index: " + i2);
                    }
                    ++optionalIndex;
                    inOptional = true;
                    break;
                }
                case ']': {
                    if (!inOptional) {
                        throw new IllegalArgumentException("Attempting to close unopened optional block at index: " + i2);
                    }
                    inOptional = false;
                    break;
                }
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuilder();
                    list2.add(new Token(buffer, inOptional, optionalIndex));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value2 = y;
                    break;
                }
                case 'M': {
                    value2 = M;
                    break;
                }
                case 'd': {
                    value2 = d;
                    break;
                }
                case 'H': {
                    value2 = H;
                    break;
                }
                case 'm': {
                    value2 = m;
                    break;
                }
                case 's': {
                    value2 = s;
                    break;
                }
                case 'S': {
                    value2 = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        list2.add(new Token(buffer, inOptional, optionalIndex));
                    }
                    buffer.append(ch);
                }
            }
            if (value2 == null) continue;
            if (previous != null && previous.getValue().equals(value2)) {
                previous.increment();
            } else {
                Token token2 = new Token(value2, inOptional, optionalIndex);
                list2.add(token2);
                previous = token2;
            }
            buffer = null;
        }
        if (inLiteral) {
            throw new IllegalArgumentException("Unmatched quote in format: " + format);
        }
        if (inOptional) {
            throw new IllegalArgumentException("Unmatched optional in format: " + format);
        }
        return list2.toArray(Token.EMPTY_ARRAY);
    }

    private static String paddedValue(long value2, boolean padWithZeros, int count2) {
        String longString = Long.toString(value2);
        return padWithZeros ? StringUtils.leftPad(longString, count2, '0') : longString;
    }

    @Deprecated
    public DurationFormatUtils() {
    }

    static class Token {
        private static final Token[] EMPTY_ARRAY = new Token[0];
        private final CharSequence value;
        private int count;
        private int optionalIndex = -1;

        static boolean containsTokenWithValue(Token[] tokens, Object value2) {
            return Stream.of(tokens).anyMatch(token2 -> token2.getValue() == value2);
        }

        Token(CharSequence value2, boolean optional, int optionalIndex) {
            this.value = Objects.requireNonNull(value2, "value");
            this.count = 1;
            if (optional) {
                this.optionalIndex = optionalIndex;
            }
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

