/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    public static final Long LONG_INT_MAX_VALUE = Integer.MAX_VALUE;
    public static final Long LONG_INT_MIN_VALUE = Integer.MIN_VALUE;

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static int compare(int x, int y) {
        if (x == y) {
            return 0;
        }
        return x < y ? -1 : 1;
    }

    public static int compare(long x, long y) {
        if (x == y) {
            return 0;
        }
        return x < y ? -1 : 1;
    }

    public static int compare(short x, short y) {
        if (x == y) {
            return 0;
        }
        return x < y ? -1 : 1;
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(str);
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            throw new NumberFormatException("An empty string is not a valid number");
        }
        int pos2 = 0;
        int radix = 10;
        boolean negate2 = false;
        char char0 = str.charAt(0);
        if (char0 == '-') {
            negate2 = true;
            pos2 = 1;
        } else if (char0 == '+') {
            pos2 = 1;
        }
        if (str.startsWith("0x", pos2) || str.startsWith("0X", pos2)) {
            radix = 16;
            pos2 += 2;
        } else if (str.startsWith("#", pos2)) {
            radix = 16;
            ++pos2;
        } else if (str.startsWith("0", pos2) && str.length() > pos2 + 1) {
            radix = 8;
            ++pos2;
        }
        BigInteger value2 = new BigInteger(str.substring(pos2), radix);
        return negate2 ? value2.negate() : value2;
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.valueOf(str);
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(str);
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.decode(str);
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.decode(str);
    }

    public static Number createNumber(String str) {
        String exp2;
        String mant;
        String dec;
        boolean requestType;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] hexPrefixes = new String[]{"0x", "0X", "#"};
        int length2 = str.length();
        int offset2 = str.charAt(0) == '+' || str.charAt(0) == '-' ? 1 : 0;
        int pfxLen = 0;
        for (String pfx : hexPrefixes) {
            if (!str.startsWith(pfx, offset2)) continue;
            pfxLen += pfx.length() + offset2;
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i2 = pfxLen; i2 < length2 && (firstSigDigit = str.charAt(i2)) == '0'; ++i2) {
                ++pfxLen;
            }
            int hexDigits = length2 - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return NumberUtils.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return NumberUtils.createLong(str);
            }
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(length2 - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        boolean bl = requestType = !Character.isDigit(lastChar) && lastChar != '.';
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos <= decPos || expPos > length2) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1, requestType ? length2 - 1 : length2);
            }
            mant = NumberUtils.getMantissa(str, decPos);
        } else {
            if (expPos > -1) {
                if (expPos > length2) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                mant = NumberUtils.getMantissa(str, expPos);
            } else {
                mant = NumberUtils.getMantissa(str, requestType ? length2 - 1 : length2);
            }
            dec = null;
        }
        if (requestType) {
            exp2 = expPos > -1 && expPos < length2 - 1 ? str.substring(expPos + 1, length2 - 1) : null;
            String numeric2 = str.substring(0, length2 - 1);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp2 == null && (!numeric2.isEmpty() && numeric2.charAt(0) == '-' && NumberUtils.isDigits(numeric2.substring(1)) || NumberUtils.isDigits(numeric2))) {
                        try {
                            return NumberUtils.createLong(numeric2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(numeric2);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtils.createFloat(str);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || NumberUtils.isZero(mant, dec))) {
                            return f;
                        }
                    }
                    catch (NumberFormatException f) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtils.createDouble(str);
                        if (!d.isInfinite() && (d != 0.0 || NumberUtils.isZero(mant, dec))) {
                            return d;
                        }
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric2);
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        exp2 = expPos > -1 && expPos < length2 - 1 ? str.substring(expPos + 1) : null;
        if (dec == null && exp2 == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException numeric2) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException numeric2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        try {
            Float f = NumberUtils.createFloat(str);
            Double d = NumberUtils.createDouble(str);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || NumberUtils.isZero(mant, dec)) && f.toString().equals(d.toString())) {
                return f;
            }
            if (!d.isInfinite() && (d != 0.0 || NumberUtils.isZero(mant, dec))) {
                BigDecimal b2 = NumberUtils.createBigDecimal(str);
                if (b2.compareTo(BigDecimal.valueOf(d)) == 0) {
                    return d;
                }
                return b2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(str);
    }

    private static String getMantissa(String str, int stopPos) {
        char firstChar = str.charAt(0);
        boolean hasSign = firstChar == '-' || firstChar == '+';
        int length2 = str.length();
        if (length2 <= (hasSign ? 1 : 0) || length2 < stopPos) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        return hasSign ? str.substring(1, stopPos) : str.substring(0, stopPos);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            if (str.charAt(i2) == '0') continue;
            return false;
        }
        return true;
    }

    public static boolean isCreatable(String str) {
        int i2;
        int start2;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars2 = str.toCharArray();
        int sz = chars2.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start2 = chars2[0] == '-' || chars2[0] == '+' ? 1 : 0;
        if (sz > start2 + 1 && chars2[start2] == '0' && !StringUtils.contains((CharSequence)str, 46)) {
            if (chars2[start2 + 1] == 'x' || chars2[start2 + 1] == 'X') {
                int i3 = start2 + 2;
                if (i3 == sz) {
                    return false;
                }
                while (i3 < chars2.length) {
                    if (!(chars2[i3] >= '0' && chars2[i3] <= '9' || chars2[i3] >= 'a' && chars2[i3] <= 'f' || chars2[i3] >= 'A' && chars2[i3] <= 'F')) {
                        return false;
                    }
                    ++i3;
                }
                return true;
            }
            if (Character.isDigit(chars2[start2 + 1])) {
                for (int i4 = start2 + 1; i4 < chars2.length; ++i4) {
                    if (chars2[i4] >= '0' && chars2[i4] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i2 = start2; i2 < sz || i2 < sz + 1 && allowSigns && !foundDigit; ++i2) {
            if (chars2[i2] >= '0' && chars2[i2] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars2[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars2[i2] == 'e' || chars2[i2] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars2[i2] == '+' || chars2[i2] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i2 < chars2.length) {
            if (chars2[i2] >= '0' && chars2[i2] <= '9') {
                return true;
            }
            if (chars2[i2] == 'e' || chars2[i2] == 'E') {
                return false;
            }
            if (chars2[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars2[i2] != 'd' && chars2[i2] != 'D' && chars2[i2] != 'f' && chars2[i2] != 'F')) {
                return foundDigit;
            }
            if (chars2[i2] == 'l' || chars2[i2] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isDigits(String str) {
        return StringUtils.isNumeric(str);
    }

    @Deprecated
    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable(str);
    }

    public static boolean isParsable(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return NumberUtils.withDecimalsParsing(str, 1);
        }
        return NumberUtils.withDecimalsParsing(str, 0);
    }

    private static boolean isZero(String mant, String dec) {
        return NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(dec);
    }

    public static byte max(byte ... array2) {
        NumberUtils.validateArray(array2);
        byte max2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] <= max2) continue;
            max2 = array2[i2];
        }
        return max2;
    }

    public static byte max(byte a, byte b2, byte c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static double max(double ... array2) {
        NumberUtils.validateArray(array2);
        double max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (Double.isNaN(array2[j])) {
                return Double.NaN;
            }
            if (!(array2[j] > max2)) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static double max(double a, double b2, double c) {
        return Math.max(Math.max(a, b2), c);
    }

    public static float max(float ... array2) {
        NumberUtils.validateArray(array2);
        float max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (Float.isNaN(array2[j])) {
                return Float.NaN;
            }
            if (!(array2[j] > max2)) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static float max(float a, float b2, float c) {
        return Math.max(Math.max(a, b2), c);
    }

    public static int max(int ... array2) {
        NumberUtils.validateArray(array2);
        int max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (array2[j] <= max2) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static int max(int a, int b2, int c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static long max(long ... array2) {
        NumberUtils.validateArray(array2);
        long max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (array2[j] <= max2) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static long max(long a, long b2, long c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static short max(short ... array2) {
        NumberUtils.validateArray(array2);
        short max2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] <= max2) continue;
            max2 = array2[i2];
        }
        return max2;
    }

    public static short max(short a, short b2, short c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static byte min(byte ... array2) {
        NumberUtils.validateArray(array2);
        byte min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min2) continue;
            min2 = array2[i2];
        }
        return min2;
    }

    public static byte min(byte a, byte b2, byte c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static double min(double ... array2) {
        NumberUtils.validateArray(array2);
        double min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (Double.isNaN(array2[i2])) {
                return Double.NaN;
            }
            if (!(array2[i2] < min2)) continue;
            min2 = array2[i2];
        }
        return min2;
    }

    public static double min(double a, double b2, double c) {
        return Math.min(Math.min(a, b2), c);
    }

    public static float min(float ... array2) {
        NumberUtils.validateArray(array2);
        float min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (Float.isNaN(array2[i2])) {
                return Float.NaN;
            }
            if (!(array2[i2] < min2)) continue;
            min2 = array2[i2];
        }
        return min2;
    }

    public static float min(float a, float b2, float c) {
        return Math.min(Math.min(a, b2), c);
    }

    public static int min(int ... array2) {
        NumberUtils.validateArray(array2);
        int min2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (array2[j] >= min2) continue;
            min2 = array2[j];
        }
        return min2;
    }

    public static int min(int a, int b2, int c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static long min(long ... array2) {
        NumberUtils.validateArray(array2);
        long min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min2) continue;
            min2 = array2[i2];
        }
        return min2;
    }

    public static long min(long a, long b2, long c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static short min(short ... array2) {
        NumberUtils.validateArray(array2);
        short min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min2) continue;
            min2 = array2[i2];
        }
        return min2;
    }

    public static short min(short a, short b2, short c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(BigDecimal value2) {
        return NumberUtils.toDouble(value2, 0.0);
    }

    public static double toDouble(BigDecimal value2, double defaultValue) {
        return value2 == null ? defaultValue : value2.doubleValue();
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value2) {
        return NumberUtils.toScaledBigDecimal(value2, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value2, int scale2, RoundingMode roundingMode) {
        if (value2 == null) {
            return BigDecimal.ZERO;
        }
        return value2.setScale(scale2, roundingMode == null ? RoundingMode.HALF_EVEN : roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Double value2) {
        return NumberUtils.toScaledBigDecimal(value2, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Double value2, int scale2, RoundingMode roundingMode) {
        if (value2 == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value2), scale2, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Float value2) {
        return NumberUtils.toScaledBigDecimal(value2, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Float value2, int scale2, RoundingMode roundingMode) {
        if (value2 == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value2.floatValue()), scale2, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(String value2) {
        return NumberUtils.toScaledBigDecimal(value2, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(String value2, int scale2, RoundingMode roundingMode) {
        if (value2 == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(NumberUtils.createBigDecimal(value2), scale2, roundingMode);
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private static void validateArray(Object array2) {
        Objects.requireNonNull(array2, "array");
        Validate.isTrue(Array.getLength(array2) != 0, "Array cannot be empty.", new Object[0]);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        for (int i2 = beginIdx; i2 < str.length(); ++i2) {
            boolean isDecimalPoint;
            char ch = str.charAt(i2);
            boolean bl = isDecimalPoint = ch == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public NumberUtils() {
    }
}

