/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class IEEE754rUtils {
    public static double max(double ... array2) {
        Objects.requireNonNull(array2, "array");
        Validate.isTrue(array2.length != 0, "Array cannot be empty.", new Object[0]);
        double max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            max2 = IEEE754rUtils.max(array2[j], max2);
        }
        return max2;
    }

    public static double max(double a, double b2) {
        if (Double.isNaN(a)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a;
        }
        return Math.max(a, b2);
    }

    public static double max(double a, double b2, double c) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a, b2), c);
    }

    public static float max(float ... array2) {
        Objects.requireNonNull(array2, "array");
        Validate.isTrue(array2.length != 0, "Array cannot be empty.", new Object[0]);
        float max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            max2 = IEEE754rUtils.max(array2[j], max2);
        }
        return max2;
    }

    public static float max(float a, float b2) {
        if (Float.isNaN(a)) {
            return b2;
        }
        if (Float.isNaN(b2)) {
            return a;
        }
        return Math.max(a, b2);
    }

    public static float max(float a, float b2, float c) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a, b2), c);
    }

    public static double min(double ... array2) {
        Objects.requireNonNull(array2, "array");
        Validate.isTrue(array2.length != 0, "Array cannot be empty.", new Object[0]);
        double min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            min2 = IEEE754rUtils.min(array2[i2], min2);
        }
        return min2;
    }

    public static double min(double a, double b2) {
        if (Double.isNaN(a)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a;
        }
        return Math.min(a, b2);
    }

    public static double min(double a, double b2, double c) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a, b2), c);
    }

    public static float min(float ... array2) {
        Objects.requireNonNull(array2, "array");
        Validate.isTrue(array2.length != 0, "Array cannot be empty.", new Object[0]);
        float min2 = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            min2 = IEEE754rUtils.min(array2[i2], min2);
        }
        return min2;
    }

    public static float min(float a, float b2) {
        if (Float.isNaN(a)) {
            return b2;
        }
        if (Float.isNaN(b2)) {
            return a;
        }
        return Math.min(a, b2);
    }

    public static float min(float a, float b2, float c) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a, b2), c);
    }

    @Deprecated
    public IEEE754rUtils() {
    }
}

