/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;

public class MultiBackgroundInitializer
extends BackgroundInitializer<MultiBackgroundInitializerResults> {
    private final Map<String, BackgroundInitializer<?>> childInitializers = new HashMap();

    public MultiBackgroundInitializer() {
    }

    public MultiBackgroundInitializer(ExecutorService exec2) {
        super(exec2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitializer(String name2, BackgroundInitializer<?> backgroundInitializer) {
        Objects.requireNonNull(name2, "name");
        Objects.requireNonNull(backgroundInitializer, "backgroundInitializer");
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.childInitializers.put(name2, backgroundInitializer);
        }
    }

    @Override
    public void close() throws ConcurrentException {
        ConcurrentException exception2 = null;
        for (BackgroundInitializer<?> child : this.childInitializers.values()) {
            try {
                child.close();
            }
            catch (Exception e) {
                if (exception2 == null) {
                    exception2 = new ConcurrentException();
                }
                if (e instanceof ConcurrentException) {
                    exception2.addSuppressed(e.getCause());
                    continue;
                }
                exception2.addSuppressed(e);
            }
        }
        if (exception2 != null) {
            throw exception2;
        }
    }

    @Override
    protected int getTaskCount() {
        return 1 + this.childInitializers.values().stream().mapToInt(BackgroundInitializer::getTaskCount).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiBackgroundInitializerResults initialize() throws Exception {
        HashMap inits;
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            inits = new HashMap(this.childInitializers);
        }
        ExecutorService exec2 = this.getActiveExecutor();
        inits.values().forEach(bi -> {
            if (bi.getExternalExecutor() == null) {
                bi.setExternalExecutor(exec2);
            }
            bi.start();
        });
        HashMap results = new HashMap();
        HashMap excepts = new HashMap();
        inits.forEach((k, v) -> {
            try {
                results.put(k, v.get());
            }
            catch (ConcurrentException cex) {
                excepts.put(k, cex);
            }
        });
        return new MultiBackgroundInitializerResults(inits, results, excepts);
    }

    @Override
    public boolean isInitialized() {
        if (this.childInitializers.isEmpty()) {
            return false;
        }
        return this.childInitializers.values().stream().allMatch(BackgroundInitializer::isInitialized);
    }

    public static class MultiBackgroundInitializerResults {
        private final Map<String, BackgroundInitializer<?>> initializers;
        private final Map<String, Object> resultObjects;
        private final Map<String, ConcurrentException> exceptions;

        private MultiBackgroundInitializerResults(Map<String, BackgroundInitializer<?>> inits, Map<String, Object> results, Map<String, ConcurrentException> excepts) {
            this.initializers = inits;
            this.resultObjects = results;
            this.exceptions = excepts;
        }

        private BackgroundInitializer<?> checkName(String name2) {
            BackgroundInitializer<?> init = this.initializers.get(name2);
            if (init == null) {
                throw new NoSuchElementException("No child initializer with name " + name2);
            }
            return init;
        }

        public ConcurrentException getException(String name2) {
            this.checkName(name2);
            return this.exceptions.get(name2);
        }

        public BackgroundInitializer<?> getInitializer(String name2) {
            return this.checkName(name2);
        }

        public Object getResultObject(String name2) {
            this.checkName(name2);
            return this.resultObjects.get(name2);
        }

        public Set<String> initializerNames() {
            return Collections.unmodifiableSet(this.initializers.keySet());
        }

        public boolean isException(String name2) {
            this.checkName(name2);
            return this.exceptions.containsKey(name2);
        }

        public boolean isSuccessful() {
            return this.exceptions.isEmpty();
        }
    }
}

