/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayFill;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.Charsets;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.function.Suppliers;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.apache.commons.lang3.stream.LangCollectors;
import org.apache.commons.lang3.stream.Streams;

public class StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final Pattern STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate(str, "...", 0, maxWidth);
    }

    public static String abbreviate(String str, int offset2, int maxWidth) {
        return StringUtils.abbreviate(str, "...", offset2, maxWidth);
    }

    public static String abbreviate(String str, String abbrevMarker, int maxWidth) {
        return StringUtils.abbreviate(str, abbrevMarker, 0, maxWidth);
    }

    public static String abbreviate(String str, String abbrevMarker, int offset2, int maxWidth) {
        if (StringUtils.isNotEmpty(str) && EMPTY.equals(abbrevMarker) && maxWidth > 0) {
            return StringUtils.substring(str, 0, maxWidth);
        }
        if (StringUtils.isAnyEmpty(str, abbrevMarker)) {
            return str;
        }
        int abbrevMarkerLength = abbrevMarker.length();
        int minAbbrevWidth = abbrevMarkerLength + 1;
        int minAbbrevWidthOffset = abbrevMarkerLength + abbrevMarkerLength + 1;
        if (maxWidth < minAbbrevWidth) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width is %d", minAbbrevWidth));
        }
        int strLen = str.length();
        if (strLen <= maxWidth) {
            return str;
        }
        if (offset2 > strLen) {
            offset2 = strLen;
        }
        if (strLen - offset2 < maxWidth - abbrevMarkerLength) {
            offset2 = strLen - (maxWidth - abbrevMarkerLength);
        }
        if (offset2 <= abbrevMarkerLength + 1) {
            return str.substring(0, maxWidth - abbrevMarkerLength) + abbrevMarker;
        }
        if (maxWidth < minAbbrevWidthOffset) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width with offset is %d", minAbbrevWidthOffset));
        }
        if (offset2 + maxWidth - abbrevMarkerLength < strLen) {
            return abbrevMarker + StringUtils.abbreviate(str.substring(offset2), abbrevMarker, maxWidth - abbrevMarkerLength);
        }
        return abbrevMarker + str.substring(strLen - (maxWidth - abbrevMarkerLength));
    }

    public static String abbreviateMiddle(String str, String middle, int length2) {
        if (StringUtils.isAnyEmpty(str, middle) || length2 >= str.length() || length2 < middle.length() + 2) {
            return str;
        }
        int targetSting = length2 - middle.length();
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = str.length() - targetSting / 2;
        return str.substring(0, startOffset) + middle + str.substring(endOffset);
    }

    private static String appendIfMissing(String str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (str == null || StringUtils.isEmpty(suffix) || StringUtils.endsWith(str, suffix, ignoreCase)) {
            return str;
        }
        if (ArrayUtils.isNotEmpty(suffixes)) {
            for (CharSequence s2 : suffixes) {
                if (!StringUtils.endsWith(str, s2, ignoreCase)) continue;
                return str;
            }
        }
        return str + suffix;
    }

    public static String appendIfMissing(String str, CharSequence suffix, CharSequence ... suffixes) {
        return StringUtils.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(String str, CharSequence suffix, CharSequence ... suffixes) {
        return StringUtils.appendIfMissing(str, suffix, true, suffixes);
    }

    public static String capitalize(String str) {
        int codePoint;
        int newCodePoint;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String center(String str, int size2) {
        return StringUtils.center(str, size2, ' ');
    }

    public static String center(String str, int size2, char padChar) {
        if (str == null || size2 <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size2 - strLen;
        if (pads <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, strLen + pads / 2, padChar);
        return StringUtils.rightPad(str, size2, padChar);
    }

    public static String center(String str, int size2, String padStr) {
        int strLen;
        int pads;
        if (str == null || size2 <= 0) {
            return str;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size2 - (strLen = str.length())) <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, strLen + pads / 2, padStr);
        return StringUtils.rightPad(str, size2, padStr);
    }

    public static String chomp(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return EMPTY;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last2 = str.charAt(lastIdx);
        if (last2 == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last2 != '\r') {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    @Deprecated
    public static String chomp(String str, String separator) {
        return StringUtils.removeEnd(str, separator);
    }

    public static String chop(String str) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char last2 = str.charAt(lastIdx);
        if (last2 == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static int compare(String str1, String str2) {
        return StringUtils.compare(str1, str2, true);
    }

    public static int compare(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.compareTo(str2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        return StringUtils.compareIgnoreCase(str1, str2, true);
    }

    public static int compareIgnoreCase(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return false;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, 0) >= 0;
    }

    public static boolean contains(CharSequence seq, int searchChar) {
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        return CharSequenceUtils.indexOf(seq, searchChar, 0) >= 0;
    }

    public static boolean containsAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return false;
        }
        int csLength = cs.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i2 = 0; i2 < csLength; ++i2) {
            char ch = cs.charAt(i2);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                if (!Character.isHighSurrogate(ch)) {
                    return true;
                }
                if (j == searchLast) {
                    return true;
                }
                if (i2 >= csLast || searchChars[j + 1] != cs.charAt(i2 + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence cs, CharSequence searchChars) {
        if (searchChars == null) {
            return false;
        }
        return StringUtils.containsAny(cs, CharSequenceUtils.toCharArray(searchChars));
    }

    public static boolean containsAny(CharSequence cs, CharSequence ... searchCharSequences) {
        return StringUtils.containsAny(StringUtils::contains, cs, searchCharSequences);
    }

    private static boolean containsAny(ToBooleanBiFunction<CharSequence, CharSequence> test2, CharSequence cs, CharSequence ... searchCharSequences) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchCharSequences)) {
            return false;
        }
        for (CharSequence searchCharSequence : searchCharSequences) {
            if (!test2.applyAsBoolean(cs, searchCharSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence ... searchCharSequences) {
        return StringUtils.containsAny(StringUtils::containsIgnoreCase, cs, searchCharSequences);
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max2 = str.length() - len;
        for (int i2 = 0; i2 <= max2; ++i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i2 = 0; i2 < csLen; ++i2) {
            char ch = cs.charAt(i2);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (!Character.isHighSurrogate(ch)) {
                    return false;
                }
                if (j == searchLast) {
                    return false;
                }
                if (i2 >= csLast || searchChars[j + 1] != cs.charAt(i2 + 1)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(CharSequence cs, String invalidChars) {
        if (invalidChars == null) {
            return true;
        }
        return StringUtils.containsNone(cs, invalidChars.toCharArray());
    }

    public static boolean containsOnly(CharSequence cs, char ... valid) {
        if (valid == null || cs == null) {
            return false;
        }
        if (cs.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(cs, valid) == -1;
    }

    public static boolean containsOnly(CharSequence cs, String validChars) {
        if (cs == null || validChars == null) {
            return false;
        }
        return StringUtils.containsOnly(cs, validChars.toCharArray());
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        int strLen = seq.length();
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (!Character.isWhitespace(seq.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static void convertRemainingAccentCharacters(StringBuilder decomposed) {
        block17: for (int i2 = 0; i2 < decomposed.length(); ++i2) {
            char charAt = decomposed.charAt(i2);
            switch (charAt) {
                case '\u0141': {
                    decomposed.setCharAt(i2, 'L');
                    continue block17;
                }
                case '\u0142': {
                    decomposed.setCharAt(i2, 'l');
                    continue block17;
                }
                case '\u0110': {
                    decomposed.setCharAt(i2, 'D');
                    continue block17;
                }
                case '\u0111': {
                    decomposed.setCharAt(i2, 'd');
                    continue block17;
                }
                case '\u0197': {
                    decomposed.setCharAt(i2, 'I');
                    continue block17;
                }
                case '\u0268': {
                    decomposed.setCharAt(i2, 'i');
                    continue block17;
                }
                case '\u1d7b': {
                    decomposed.setCharAt(i2, 'I');
                    continue block17;
                }
                case '\u1da4': {
                    decomposed.setCharAt(i2, 'i');
                    continue block17;
                }
                case '\u1da7': {
                    decomposed.setCharAt(i2, 'I');
                    continue block17;
                }
                case '\u0244': {
                    decomposed.setCharAt(i2, 'U');
                    continue block17;
                }
                case '\u0289': {
                    decomposed.setCharAt(i2, 'u');
                    continue block17;
                }
                case '\u1d7e': {
                    decomposed.setCharAt(i2, 'U');
                    continue block17;
                }
                case '\u1db6': {
                    decomposed.setCharAt(i2, 'u');
                    continue block17;
                }
                case '\u0166': {
                    decomposed.setCharAt(i2, 'T');
                    continue block17;
                }
                case '\u0167': {
                    decomposed.setCharAt(i2, 't');
                    continue block17;
                }
            }
        }
    }

    public static int countMatches(CharSequence str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count2 = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (ch != str.charAt(i2)) continue;
            ++count2;
        }
        return count2;
    }

    public static int countMatches(CharSequence str, CharSequence sub3) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub3)) {
            return 0;
        }
        int count2 = 0;
        int idx = 0;
        while ((idx = CharSequenceUtils.indexOf(str, sub3, idx)) != -1) {
            ++count2;
            idx += sub3.length();
        }
        return count2;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        return StringUtils.isBlank(str) ? defaultStr : str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        return StringUtils.isEmpty(str) ? defaultStr : str;
    }

    public static String defaultString(String str) {
        return Objects.toString(str, EMPTY);
    }

    @Deprecated
    public static String defaultString(String str, String nullDefault) {
        return Objects.toString(str, nullDefault);
    }

    public static String deleteWhitespace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count2 = 0;
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            chs[count2++] = str.charAt(i2);
        }
        if (count2 == sz) {
            return str;
        }
        if (count2 == 0) {
            return EMPTY;
        }
        return new String(chs, 0, count2);
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at2 = StringUtils.indexOfDifference((CharSequence)str1, (CharSequence)str2);
        if (at2 == -1) {
            return EMPTY;
        }
        return str2.substring(at2);
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == suffix;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return CharSequenceUtils.regionMatches(str, ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean endsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (CharSequence searchString : searchStrings) {
            if (!StringUtils.endsWith(sequence, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith(str, suffix, true);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length2 = cs1.length();
        for (int i2 = 0; i2 < length2; ++i2) {
            if (cs1.charAt(i2) == cs2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAny(CharSequence string2, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            for (CharSequence next2 : searchStrings) {
                if (!StringUtils.equals(string2, next2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(CharSequence string2, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            for (CharSequence next2 : searchStrings) {
                if (!StringUtils.equalsIgnoreCase(string2, next2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(cs1, true, 0, cs2, 0, cs1.length());
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonBlank(T ... values2) {
        if (values2 != null) {
            for (T val : values2) {
                if (!StringUtils.isNotBlank(val)) continue;
                return val;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonEmpty(T ... values2) {
        if (values2 != null) {
            for (T val : values2) {
                if (!StringUtils.isNotEmpty(val)) continue;
                return val;
            }
        }
        return null;
    }

    public static byte[] getBytes(String string2, Charset charset) {
        return string2 == null ? ArrayUtils.EMPTY_BYTE_ARRAY : string2.getBytes(Charsets.toCharset(charset));
    }

    public static byte[] getBytes(String string2, String charset) throws UnsupportedEncodingException {
        return string2 == null ? ArrayUtils.EMPTY_BYTE_ARRAY : string2.getBytes(Charsets.toCharsetName(charset));
    }

    public static String getCommonPrefix(String ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return EMPTY;
        }
        int smallestIndexOfDiff = StringUtils.indexOfDifference(strs);
        if (smallestIndexOfDiff == -1) {
            if (strs[0] == null) {
                return EMPTY;
            }
            return strs[0];
        }
        if (smallestIndexOfDiff == 0) {
            return EMPTY;
        }
        return strs[0].substring(0, smallestIndexOfDiff);
    }

    public static String getDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        StringBuilder strDigits = new StringBuilder(sz);
        for (int i2 = 0; i2 < sz; ++i2) {
            char tempChar = str.charAt(i2);
            if (!Character.isDigit(tempChar)) continue;
            strDigits.append(tempChar);
        }
        return strDigits.toString();
    }

    @Deprecated
    public static int getFuzzyDistance(CharSequence term, CharSequence query, Locale locale) {
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        String termLowerCase = term.toString().toLowerCase(locale);
        String queryLowerCase = query.toString().toLowerCase(locale);
        int score = 0;
        int termIndex = 0;
        int previousMatchingCharacterIndex = Integer.MIN_VALUE;
        for (int queryIndex = 0; queryIndex < queryLowerCase.length(); ++queryIndex) {
            char queryChar = queryLowerCase.charAt(queryIndex);
            boolean termCharacterMatchFound = false;
            while (termIndex < termLowerCase.length() && !termCharacterMatchFound) {
                char termChar = termLowerCase.charAt(termIndex);
                if (queryChar == termChar) {
                    ++score;
                    if (previousMatchingCharacterIndex + 1 == termIndex) {
                        score += 2;
                    }
                    previousMatchingCharacterIndex = termIndex;
                    termCharacterMatchFound = true;
                }
                ++termIndex;
            }
        }
        return score;
    }

    public static <T extends CharSequence> T getIfBlank(T str, Supplier<T> defaultSupplier) {
        return (T)(StringUtils.isBlank(str) ? (CharSequence)Suppliers.get(defaultSupplier) : str);
    }

    public static <T extends CharSequence> T getIfEmpty(T str, Supplier<T> defaultSupplier) {
        return (T)(StringUtils.isEmpty(str) ? (CharSequence)Suppliers.get(defaultSupplier) : str);
    }

    @Deprecated
    public static double getJaroWinklerDistance(CharSequence first2, CharSequence second2) {
        double DEFAULT_SCALING_FACTOR = 0.1;
        if (first2 == null || second2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int[] mtp = StringUtils.matches(first2, second2);
        double m = mtp[0];
        if (m == 0.0) {
            return 0.0;
        }
        double j = (m / (double)first2.length() + m / (double)second2.length() + (m - (double)mtp[1]) / m) / 3.0;
        double jw = j < 0.7 ? j : j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - j);
        return (double)Math.round(jw * 100.0) / 100.0;
    }

    @Deprecated
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t) {
        int i2;
        if (s2 == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s2.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s2;
            s2 = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p2 = new int[n + 1];
        for (i2 = 0; i2 <= n; ++i2) {
            p2[i2] = i2;
        }
        for (int j = 1; j <= m; ++j) {
            int upperleft = p2[0];
            char jOfT = t.charAt(j - 1);
            p2[0] = j;
            for (i2 = 1; i2 <= n; ++i2) {
                int upper = p2[i2];
                int cost = s2.charAt(i2 - 1) == jOfT ? 0 : 1;
                p2[i2] = Math.min(Math.min(p2[i2 - 1] + 1, p2[i2] + 1), upperleft + cost);
                upperleft = upper;
            }
        }
        return p2[n];
    }

    @Deprecated
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t, int threshold) {
        if (s2 == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n = s2.length();
        int m = t.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (Math.abs(n - m) > threshold) {
            return -1;
        }
        if (n > m) {
            CharSequence tmp = s2;
            s2 = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p2 = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p2[i2] = i2;
        }
        Arrays.fill(p2, boundary, p2.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max2;
            char jOfT = t.charAt(j - 1);
            d[0] = j;
            int min2 = Math.max(1, j - threshold);
            int n2 = max2 = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min2 > max2) {
                return -1;
            }
            if (min2 > 1) {
                d[min2 - 1] = Integer.MAX_VALUE;
            }
            for (int i3 = min2; i3 <= max2; ++i3) {
                d[i3] = s2.charAt(i3 - 1) == jOfT ? p2[i3 - 1] : 1 + Math.min(Math.min(d[i3 - 1], p2[i3]), p2[i3 - 1]);
            }
            int[] tmp = p2;
            p2 = d;
            d = tmp;
        }
        if (p2[n] <= threshold) {
            return p2[n];
        }
        return -1;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, 0);
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, startPos);
    }

    public static int indexOf(CharSequence seq, int searchChar) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchChar, 0);
    }

    public static int indexOf(CharSequence seq, int searchChar, int startPos) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchChar, startPos);
    }

    public static int indexOfAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i2 = 0; i2 < csLen; ++i2) {
            char ch = cs.charAt(i2);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (i2 >= csLast || j >= searchLast || !Character.isHighSurrogate(ch)) {
                    return i2;
                }
                if (searchChars[j + 1] != cs.charAt(i2 + 1)) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int indexOfAny(CharSequence str, CharSequence ... searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = Integer.MAX_VALUE;
        for (CharSequence search : searchStrs) {
            int tmp;
            if (search == null || (tmp = CharSequenceUtils.indexOf(str, search, 0)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int indexOfAny(CharSequence cs, String searchChars) {
        if (StringUtils.isEmpty(cs) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        return StringUtils.indexOfAny(cs, searchChars.toCharArray());
    }

    public static int indexOfAnyBut(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        block0: for (int i2 = 0; i2 < csLen; ++i2) {
            char ch = cs.charAt(i2);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] == ch && (i2 >= csLast || j >= searchLast || !Character.isHighSurrogate(ch) || searchChars[j + 1] == cs.charAt(i2 + 1))) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence seq, CharSequence searchChars) {
        if (StringUtils.isEmpty(seq) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        int strLen = seq.length();
        for (int i2 = 0; i2 < strLen; ++i2) {
            boolean chFound;
            char ch = seq.charAt(i2);
            boolean bl = chFound = CharSequenceUtils.indexOf(searchChars, ch, 0) >= 0;
            if (i2 + 1 < strLen && Character.isHighSurrogate(ch)) {
                char ch2 = seq.charAt(i2 + 1);
                if (!chFound || CharSequenceUtils.indexOf(searchChars, ch2, 0) >= 0) continue;
                return i2;
            }
            if (chFound) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfDifference(CharSequence ... css) {
        if (ArrayUtils.getLength(css) <= 1) {
            return -1;
        }
        boolean anyStringNull = false;
        boolean allStringsNull = true;
        int arrayLen = css.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        for (CharSequence cs : css) {
            if (cs == null) {
                anyStringNull = true;
                shortestStrLen = 0;
                continue;
            }
            allStringsNull = false;
            shortestStrLen = Math.min(cs.length(), shortestStrLen);
            longestStrLen = Math.max(cs.length(), longestStrLen);
        }
        if (allStringsNull || longestStrLen == 0 && !anyStringNull) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = css[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (css[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    public static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        int i2;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (i2 = 0; i2 < cs1.length() && i2 < cs2.length() && cs1.charAt(i2) == cs2.charAt(i2); ++i2) {
        }
        if (i2 < cs2.length() || i2 < cs1.length()) {
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < endLimit; ++i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, searchStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isAllBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isNotBlank(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isNotEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLowerCase(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isUpperCase(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetter(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetterOrDigit(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            char nowChar = cs.charAt(i2);
            if (nowChar == ' ' || Character.isLetterOrDigit(nowChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            char nowChar = cs.charAt(i2);
            if (nowChar == ' ' || Character.isLetter(nowChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isBlank(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isEmpty(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (CharUtils.isAsciiPrintable(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isMixedCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs) || cs.length() == 1) {
            return false;
        }
        boolean containsUppercase = false;
        boolean containsLowercase = false;
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            char nowChar = cs.charAt(i2);
            if (Character.isUpperCase(nowChar)) {
                containsUppercase = true;
            } else if (Character.isLowerCase(nowChar)) {
                containsLowercase = true;
            }
            if (!containsUppercase || !containsLowercase) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return !StringUtils.isAnyBlank(css);
    }

    public static boolean isNoneEmpty(CharSequence ... css) {
        return !StringUtils.isAnyEmpty(css);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isDigit(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            char nowChar = cs.charAt(i2);
            if (nowChar == ' ' || Character.isDigit(nowChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String join(boolean[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(boolean[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(array2.length * 5 + array2.length - 1);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(byte[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(byte[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(char[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(char[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(array2.length * 2 - 1);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(double[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(double[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(float[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(float[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(int[] array2, char separator) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, separator, 0, array2.length);
    }

    public static String join(int[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(Iterable<?> iterable, char separator) {
        return iterable != null ? StringUtils.join(iterable.iterator(), separator) : null;
    }

    public static String join(Iterable<?> iterable, String separator) {
        return iterable != null ? StringUtils.join(iterable.iterator(), separator) : null;
    }

    public static String join(Iterator<?> iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        return Streams.of(iterator).collect(LangCollectors.joining(StringUtils.toStringOrEmpty(String.valueOf(separator)), EMPTY, EMPTY, StringUtils::toStringOrEmpty));
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        return Streams.of(iterator).collect(LangCollectors.joining(StringUtils.toStringOrEmpty(separator), EMPTY, EMPTY, StringUtils::toStringOrEmpty));
    }

    public static String join(List<?> list2, char separator, int startIndex, int endIndex) {
        if (list2 == null) {
            return null;
        }
        int noOfItems = endIndex - startIndex;
        if (noOfItems <= 0) {
            return EMPTY;
        }
        List<?> subList = list2.subList(startIndex, endIndex);
        return StringUtils.join(subList.iterator(), separator);
    }

    public static String join(List<?> list2, String separator, int startIndex, int endIndex) {
        if (list2 == null) {
            return null;
        }
        int noOfItems = endIndex - startIndex;
        if (noOfItems <= 0) {
            return EMPTY;
        }
        List<?> subList = list2.subList(startIndex, endIndex);
        return StringUtils.join(subList.iterator(), separator);
    }

    public static String join(long[] array2, char separator) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, separator, 0, array2.length);
    }

    public static String join(long[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String join(Object[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(Object[] array2, char delimiter, int startIndex, int endIndex) {
        return StringUtils.join(array2, String.valueOf(delimiter), startIndex, endIndex);
    }

    public static String join(Object[] array2, String delimiter) {
        return array2 != null ? StringUtils.join(array2, StringUtils.toStringOrEmpty(delimiter), 0, array2.length) : null;
    }

    public static String join(Object[] array2, String delimiter, int startIndex, int endIndex) {
        return array2 != null ? Streams.of(array2).skip(startIndex).limit(Math.max(0, endIndex - startIndex)).collect(LangCollectors.joining(delimiter, EMPTY, EMPTY, StringUtils::toStringOrEmpty)) : null;
    }

    public static String join(short[] array2, char delimiter) {
        if (array2 == null) {
            return null;
        }
        return StringUtils.join(array2, delimiter, 0, array2.length);
    }

    public static String join(short[] array2, char delimiter, int startIndex, int endIndex) {
        if (array2 == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            stringBuilder.append(array2[i2]).append(delimiter);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        return StringUtils.join((Object[])elements, null);
    }

    public static String joinWith(String delimiter, Object ... array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("Object varargs must not be null");
        }
        return StringUtils.join(array2, delimiter);
    }

    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq) {
        if (seq == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchSeq, seq.length());
    }

    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        return CharSequenceUtils.lastIndexOf(seq, searchSeq, startPos);
    }

    public static int lastIndexOf(CharSequence seq, int searchChar) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchChar, seq.length());
    }

    public static int lastIndexOf(CharSequence seq, int searchChar, int startPos) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchChar, startPos);
    }

    public static int lastIndexOfAny(CharSequence str, CharSequence ... searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = -1;
        for (CharSequence search : searchStrs) {
            int tmp;
            if (search == null || (tmp = CharSequenceUtils.lastIndexOf(str, search, str.length())) <= ret) continue;
            ret = tmp;
        }
        return ret;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        int searchStrLength = searchStr.length();
        int strLength = str.length();
        if (startPos > strLength - searchStrLength) {
            startPos = strLength - searchStrLength;
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStrLength == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 >= 0; --i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, searchStrLength)) continue;
            return i2;
        }
        return -1;
    }

    public static int lastOrdinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal2) {
        return StringUtils.ordinalIndexOf(str, searchStr, ordinal2, true);
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String leftPad(String str, int size2) {
        return StringUtils.leftPad(str, size2, ' ');
    }

    public static String leftPad(String str, int size2, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size2 - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size2, String.valueOf(padChar));
        }
        return StringUtils.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size2, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size2 - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size2, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i2 = 0; i2 < pads; ++i2) {
            padding[i2] = padChars[i2 % padLen];
        }
        return new String(padding).concat(str);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String lowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(LocaleUtils.toLocale(locale));
    }

    private static int[] matches(CharSequence first2, CharSequence second2) {
        int i2;
        CharSequence min2;
        CharSequence max2;
        if (first2.length() > second2.length()) {
            max2 = first2;
            min2 = second2;
        } else {
            max2 = second2;
            min2 = first2;
        }
        int range = Math.max(max2.length() / 2 - 1, 0);
        int[] matchIndexes = ArrayFill.fill(new int[min2.length()], -1);
        boolean[] matchFlags = new boolean[max2.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min2.length(); ++mi) {
            char c1 = min2.charAt(mi);
            int xn = Math.min(mi + range + 1, max2.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max2.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int si = 0;
        for (i2 = 0; i2 < min2.length(); ++i2) {
            if (matchIndexes[i2] == -1) continue;
            ms1[si] = min2.charAt(i2);
            ++si;
        }
        si = 0;
        for (i2 = 0; i2 < max2.length(); ++i2) {
            if (!matchFlags[i2]) continue;
            ms2[si] = max2.charAt(i2);
            ++si;
        }
        int transpositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < min2.length() && first2.charAt(mi) == second2.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches, transpositions / 2, prefix, max2.length()};
    }

    public static String mid(String str, int pos2, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos2 > str.length()) {
            return EMPTY;
        }
        if (pos2 < 0) {
            pos2 = 0;
        }
        if (str.length() <= pos2 + len) {
            return str.substring(pos2);
        }
        return str.substring(pos2, pos2 + len);
    }

    public static String normalizeSpace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int size2 = str.length();
        char[] newChars = new char[size2];
        int count2 = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i2 = 0; i2 < size2; ++i2) {
            char actualChar = str.charAt(i2);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count2++] = SPACE.charAt(0);
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count2++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return EMPTY;
        }
        return new String(newChars, 0, count2 - (whitespacesCount > 0 ? 1 : 0)).trim();
    }

    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal2) {
        return StringUtils.ordinalIndexOf(str, searchStr, ordinal2, false);
    }

    private static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal2, boolean lastIndex) {
        if (str == null || searchStr == null || ordinal2 <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return lastIndex ? str.length() : 0;
        }
        int found = 0;
        int index2 = lastIndex ? str.length() : -1;
        do {
            if ((index2 = lastIndex ? CharSequenceUtils.lastIndexOf(str, searchStr, index2 - 1) : CharSequenceUtils.indexOf(str, searchStr, index2 + 1)) >= 0) continue;
            return index2;
        } while (++found < ordinal2);
        return index2;
    }

    public static String overlay(String str, String overlay, int start2, int end2) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str.length();
        if (start2 < 0) {
            start2 = 0;
        }
        if (start2 > len) {
            start2 = len;
        }
        if (end2 < 0) {
            end2 = 0;
        }
        if (end2 > len) {
            end2 = len;
        }
        if (start2 > end2) {
            int temp = start2;
            start2 = end2;
            end2 = temp;
        }
        return str.substring(0, start2) + overlay + str.substring(end2);
    }

    private static String prependIfMissing(String str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || StringUtils.isEmpty(prefix) || StringUtils.startsWith(str, prefix, ignoreCase)) {
            return str;
        }
        if (ArrayUtils.isNotEmpty(prefixes)) {
            for (CharSequence p2 : prefixes) {
                if (!StringUtils.startsWith(str, p2, ignoreCase)) continue;
                return str;
            }
        }
        return prefix + str;
    }

    public static String prependIfMissing(String str, CharSequence prefix, CharSequence ... prefixes) {
        return StringUtils.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(String str, CharSequence prefix, CharSequence ... prefixes) {
        return StringUtils.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String remove(String str, char remove) {
        if (StringUtils.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        char[] chars2 = str.toCharArray();
        int pos2 = 0;
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            if (chars2[i2] == remove) continue;
            chars2[pos2++] = chars2[i2];
        }
        return new String(chars2, 0, pos2);
    }

    public static String remove(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replace(str, remove, EMPTY, -1);
    }

    @Deprecated
    public static String removeAll(String text, String regex) {
        return RegExUtils.removeAll(text, regex);
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String removeEndIgnoreCase(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (StringUtils.endsWithIgnoreCase(str, remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    @Deprecated
    public static String removeFirst(String text, String regex) {
        return StringUtils.replaceFirst(text, regex, EMPTY);
    }

    public static String removeIgnoreCase(String str, String remove) {
        return StringUtils.replaceIgnoreCase(str, remove, EMPTY, -1);
    }

    @Deprecated
    public static String removePattern(String source2, String regex) {
        return RegExUtils.removePattern(source2, regex);
    }

    public static String removeStart(String str, char remove) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return str.charAt(0) == remove ? str.substring(1) : str;
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeStartIgnoreCase(String str, String remove) {
        if (str != null && StringUtils.startsWithIgnoreCase(str, remove)) {
            return str.substring(StringUtils.length(remove));
        }
        return str;
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        return new String(ArrayFill.fill(new char[repeat], ch));
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i2 = repeat * 2 - 2; i2 >= 0; --i2) {
                    output2[i2] = ch0;
                    output2[i2 + 1] = ch1;
                    --i2;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i3 = 0; i3 < repeat; ++i3) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(String str, String separator, int repeat) {
        if (str == null || separator == null) {
            return StringUtils.repeat(str, repeat);
        }
        String result2 = StringUtils.repeat(str + separator, repeat);
        return StringUtils.removeEnd(result2, separator);
    }

    public static String replace(String text, String searchString, String replacement2) {
        return StringUtils.replace(text, searchString, replacement2, -1);
    }

    public static String replace(String text, String searchString, String replacement2, int max2) {
        return StringUtils.replace(text, searchString, replacement2, max2, false);
    }

    private static String replace(String text, String searchString, String replacement2, int max2, boolean ignoreCase) {
        int end2;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement2 == null || max2 == 0) {
            return text;
        }
        if (ignoreCase) {
            searchString = searchString.toLowerCase();
        }
        int start2 = 0;
        int n = end2 = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, start2) : StringUtils.indexOf((CharSequence)text, searchString, start2);
        if (end2 == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = Math.max(replacement2.length() - replLength, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max2 < 0 ? 16 : Math.min(max2, 64)));
        while (end2 != -1) {
            buf.append(text, start2, end2).append(replacement2);
            start2 = end2 + replLength;
            if (--max2 == 0) break;
            end2 = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, start2) : StringUtils.indexOf((CharSequence)text, searchString, start2);
        }
        buf.append(text, start2, text.length());
        return buf.toString();
    }

    @Deprecated
    public static String replaceAll(String text, String regex, String replacement2) {
        return RegExUtils.replaceAll(text, regex, replacement2);
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i2 = 0; i2 < strLength; ++i2) {
            char ch = str.charAt(i2);
            int index2 = searchChars.indexOf(ch);
            if (index2 >= 0) {
                modified = true;
                if (index2 >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index2));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, false, 0);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        int tempIndex;
        if (timeToLive < 0) {
            HashSet<String> searchSet = new HashSet<String>(Arrays.asList(searchList));
            HashSet<String> replacementSet = new HashSet<String>(Arrays.asList(replacementList));
            searchSet.retainAll(replacementSet);
            if (!searchSet.isEmpty()) {
                throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
            }
        }
        if (StringUtils.isEmpty(text) || ArrayUtils.isEmpty(searchList) || ArrayUtils.isEmpty(replacementList) || ArrayUtils.isNotEmpty(searchList) && timeToLive == -1) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        for (int i2 = 0; i2 < searchLength; ++i2) {
            if (noMoreMatchesForReplIndex[i2] || StringUtils.isEmpty(searchList[i2]) || replacementList[i2] == null) continue;
            tempIndex = text.indexOf(searchList[i2]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i2] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i2;
        }
        if (textIndex == -1) {
            return text;
        }
        int start2 = 0;
        int increase = 0;
        for (int i3 = 0; i3 < searchList.length; ++i3) {
            int greater;
            if (searchList[i3] == null || replacementList[i3] == null || (greater = replacementList[i3].length() - searchList[i3].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i4;
            for (i4 = start2; i4 < textIndex; ++i4) {
                buf.append(text.charAt(i4));
            }
            buf.append(replacementList[replaceIndex]);
            start2 = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i4 = 0; i4 < searchLength; ++i4) {
                if (noMoreMatchesForReplIndex[i4] || StringUtils.isEmpty(searchList[i4]) || replacementList[i4] == null) continue;
                tempIndex = text.indexOf(searchList[i4], start2);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i4] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i4;
            }
        }
        int textLength = text.length();
        for (int i5 = start2; i5 < textLength; ++i5) {
            buf.append(text.charAt(i5));
        }
        String result2 = buf.toString();
        if (!repeat) {
            return result2;
        }
        return StringUtils.replaceEach(result2, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, true, ArrayUtils.getLength(searchList));
    }

    @Deprecated
    public static String replaceFirst(String text, String regex, String replacement2) {
        return RegExUtils.replaceFirst(text, regex, replacement2);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement2) {
        return StringUtils.replaceIgnoreCase(text, searchString, replacement2, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement2, int max2) {
        return StringUtils.replace(text, searchString, replacement2, max2, true);
    }

    public static String replaceOnce(String text, String searchString, String replacement2) {
        return StringUtils.replace(text, searchString, replacement2, 1);
    }

    public static String replaceOnceIgnoreCase(String text, String searchString, String replacement2) {
        return StringUtils.replaceIgnoreCase(text, searchString, replacement2, 1);
    }

    @Deprecated
    public static String replacePattern(String source2, String regex, String replacement2) {
        return RegExUtils.replacePattern(source2, regex, replacement2);
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String reverseDelimited(String str, char separatorChar) {
        Object[] strs = StringUtils.split(str, separatorChar);
        ArrayUtils.reverse(strs);
        return StringUtils.join(strs, separatorChar);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String rightPad(String str, int size2) {
        return StringUtils.rightPad(str, size2, ' ');
    }

    public static String rightPad(String str, int size2, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size2 - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size2, String.valueOf(padChar));
        }
        return str.concat(StringUtils.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size2, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size2 - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size2, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i2 = 0; i2 < pads; ++i2) {
            padding[i2] = padChars[i2 % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String rotate(String str, int shift2) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (shift2 == 0 || strLen == 0 || shift2 % strLen == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(strLen);
        int offset2 = -(shift2 % strLen);
        builder.append(StringUtils.substring(str, offset2));
        builder.append(StringUtils.substring(str, 0, offset2));
        return builder.toString();
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, false);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max2) {
        return StringUtils.splitWorker(str, separatorChars, max2, false);
    }

    public static String[] splitByCharacterType(String str) {
        return StringUtils.splitByCharacterType(str, false);
    }

    private static String[] splitByCharacterType(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        char[] c = str.toCharArray();
        ArrayList<String> list2 = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos2 = tokenStart + 1; pos2 < c.length; ++pos2) {
            int type2 = Character.getType(c[pos2]);
            if (type2 == currentType) continue;
            if (camelCase && type2 == 2 && currentType == 1) {
                int newTokenStart = pos2 - 1;
                if (newTokenStart != tokenStart) {
                    list2.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list2.add(new String(c, tokenStart, pos2 - tokenStart));
                tokenStart = pos2;
            }
            currentType = type2;
        }
        list2.add(new String(c, tokenStart, c.length - tokenStart));
        return list2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitByCharacterTypeCamelCase(String str) {
        return StringUtils.splitByCharacterType(str, true);
    }

    public static String[] splitByWholeSeparator(String str, String separator) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, -1, false);
    }

    public static String[] splitByWholeSeparator(String str, String separator, int max2) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, max2, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator, int max2) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, max2, true);
    }

    private static String[] splitByWholeSeparatorWorker(String str, String separator, int max2, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return StringUtils.splitWorker(str, null, max2, preserveAllTokens);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end2 = 0;
        while (end2 < len) {
            end2 = str.indexOf(separator, beg);
            if (end2 > -1) {
                if (end2 > beg) {
                    if (++numberOfSubstrings == max2) {
                        end2 = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end2));
                    beg = end2 + separatorLength;
                    continue;
                }
                if (preserveAllTokens) {
                    if (++numberOfSubstrings == max2) {
                        end2 = len;
                        substrings.add(str.substring(beg));
                    } else {
                        substrings.add(EMPTY);
                    }
                }
                beg = end2 + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end2 = len;
        }
        return substrings.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitPreserveAllTokens(String str) {
        return StringUtils.splitWorker(str, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, true);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars, int max2) {
        return StringUtils.splitWorker(str, separatorChars, max2, true);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list2 = new ArrayList<String>();
        int i2 = 0;
        int start2 = 0;
        boolean match2 = false;
        boolean lastMatch = false;
        while (i2 < len) {
            if (str.charAt(i2) == separatorChar) {
                if (match2 || preserveAllTokens) {
                    list2.add(str.substring(start2, i2));
                    match2 = false;
                    lastMatch = true;
                }
                start2 = ++i2;
                continue;
            }
            lastMatch = false;
            match2 = true;
            ++i2;
        }
        if (match2 || preserveAllTokens && lastMatch) {
            list2.add(str.substring(start2, i2));
        }
        return list2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private static String[] splitWorker(String str, String separatorChars, int max2, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list2 = new ArrayList<String>();
        int sizePlus1 = 1;
        int i2 = 0;
        int start2 = 0;
        boolean match2 = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i2 < len) {
                if (Character.isWhitespace(str.charAt(i2))) {
                    if (match2 || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max2) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list2.add(str.substring(start2, i2));
                        match2 = false;
                    }
                    start2 = ++i2;
                    continue;
                }
                lastMatch = false;
                match2 = true;
                ++i2;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i2 < len) {
                if (str.charAt(i2) == sep) {
                    if (match2 || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max2) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list2.add(str.substring(start2, i2));
                        match2 = false;
                    }
                    start2 = ++i2;
                    continue;
                }
                lastMatch = false;
                match2 = true;
                ++i2;
            }
        } else {
            while (i2 < len) {
                if (separatorChars.indexOf(str.charAt(i2)) >= 0) {
                    if (match2 || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max2) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list2.add(str.substring(start2, i2));
                        match2 = false;
                    }
                    start2 = ++i2;
                    continue;
                }
                lastMatch = false;
                match2 = true;
                ++i2;
            }
        }
        if (match2 || preserveAllTokens && lastMatch) {
            list2.add(str.substring(start2, i2));
        }
        return list2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, false);
    }

    private static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == prefix;
        }
        int preLen = prefix.length();
        if (preLen > str.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(str, ignoreCase, 0, prefix, 0, preLen);
    }

    public static boolean startsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (CharSequence searchString : searchStrings) {
            if (!StringUtils.startsWith(sequence, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, true);
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        str = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(str, stripChars);
    }

    public static String stripAccents(String input) {
        if (StringUtils.isEmpty(input)) {
            return input;
        }
        StringBuilder decomposed = new StringBuilder(Normalizer.normalize(input, Normalizer.Form.NFKD));
        StringUtils.convertRemainingAccentCharacters(decomposed);
        return STRIP_ACCENTS_PATTERN.matcher(decomposed).replaceAll(EMPTY);
    }

    public static String[] stripAll(String ... strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String stripChars) {
        int strsLen = ArrayUtils.getLength(strs);
        if (strsLen == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        Arrays.setAll(newArr, i2 -> StringUtils.strip(strs[i2], stripChars));
        return newArr;
    }

    public static String stripEnd(String str, String stripChars) {
        int end2 = StringUtils.length(str);
        if (end2 == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end2 != 0 && Character.isWhitespace(str.charAt(end2 - 1))) {
                --end2;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end2 != 0 && stripChars.indexOf(str.charAt(end2 - 1)) != -1) {
                --end2;
            }
        }
        return str.substring(0, end2);
    }

    public static String stripStart(String str, String stripChars) {
        int start2;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start2 = 0; start2 != strLen && Character.isWhitespace(str.charAt(start2)); ++start2) {
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (start2 != strLen && stripChars.indexOf(str.charAt(start2)) != -1) {
                ++start2;
            }
        }
        return str.substring(start2);
    }

    public static String stripToEmpty(String str) {
        return str == null ? EMPTY : StringUtils.strip(str, null);
    }

    public static String stripToNull(String str) {
        if (str == null) {
            return null;
        }
        return (str = StringUtils.strip(str, null)).isEmpty() ? null : str;
    }

    public static String substring(String str, int start2) {
        if (str == null) {
            return null;
        }
        if (start2 < 0) {
            start2 = str.length() + start2;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        if (start2 > str.length()) {
            return EMPTY;
        }
        return str.substring(start2);
    }

    public static String substring(String str, int start2, int end2) {
        if (str == null) {
            return null;
        }
        if (end2 < 0) {
            end2 = str.length() + end2;
        }
        if (start2 < 0) {
            start2 = str.length() + start2;
        }
        if (end2 > str.length()) {
            end2 = str.length();
        }
        if (start2 > end2) {
            return EMPTY;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        if (end2 < 0) {
            end2 = 0;
        }
        return str.substring(start2, end2);
    }

    public static String substringAfter(String str, int separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos2 = str.indexOf(separator);
        if (pos2 == -1) {
            return EMPTY;
        }
        return str.substring(pos2 + 1);
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos2 = str.indexOf(separator);
        if (pos2 == -1) {
            return EMPTY;
        }
        return str.substring(pos2 + separator.length());
    }

    public static String substringAfterLast(String str, int separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos2 = str.lastIndexOf(separator);
        if (pos2 == -1 || pos2 == str.length() - 1) {
            return EMPTY;
        }
        return str.substring(pos2 + 1);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos2 = str.lastIndexOf(separator);
        if (pos2 == -1 || pos2 == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos2 + separator.length());
    }

    public static String substringBefore(String str, int separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos2 = str.indexOf(separator);
        if (pos2 == -1) {
            return str;
        }
        return str.substring(0, pos2);
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int pos2 = str.indexOf(separator);
        if (pos2 == -1) {
            return str;
        }
        return str.substring(0, pos2);
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos2 = str.lastIndexOf(separator);
        if (pos2 == -1) {
            return str;
        }
        return str.substring(0, pos2);
    }

    public static String substringBetween(String str, String tag2) {
        return StringUtils.substringBetween(str, tag2, tag2);
    }

    public static String substringBetween(String str, String open2, String close2) {
        int end2;
        if (!ObjectUtils.allNotNull(str, open2, close2)) {
            return null;
        }
        int start2 = str.indexOf(open2);
        if (start2 != -1 && (end2 = str.indexOf(close2, start2 + open2.length())) != -1) {
            return str.substring(start2 + open2.length(), end2);
        }
        return null;
    }

    public static String[] substringsBetween(String str, String open2, String close2) {
        int end2;
        int start2;
        if (str == null || StringUtils.isEmpty(open2) || StringUtils.isEmpty(close2)) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int closeLen = close2.length();
        int openLen = open2.length();
        ArrayList<String> list2 = new ArrayList<String>();
        int pos2 = 0;
        while (pos2 < strLen - closeLen && (start2 = str.indexOf(open2, pos2)) >= 0 && (end2 = str.indexOf(close2, start2 += openLen)) >= 0) {
            list2.add(str.substring(start2, end2));
            pos2 = end2 + closeLen;
        }
        if (list2.isEmpty()) {
            return null;
        }
        return list2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String swapCase(String str) {
        int newCodePoint;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        for (int i2 = 0; i2 < strLen; i2 += Character.charCount(newCodePoint)) {
            int oldCodepoint = str.codePointAt(i2);
            newCodePoint = Character.isUpperCase(oldCodepoint) || Character.isTitleCase(oldCodepoint) ? Character.toLowerCase(oldCodepoint) : (Character.isLowerCase(oldCodepoint) ? Character.toUpperCase(oldCodepoint) : oldCodepoint);
            newCodePoints[outOffset++] = newCodePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static int[] toCodePoints(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        if (cs.length() == 0) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        String s2 = cs.toString();
        int[] result2 = new int[s2.codePointCount(0, s2.length())];
        int index2 = 0;
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = s2.codePointAt(index2);
            index2 += Character.charCount(result2[i2]);
        }
        return result2;
    }

    public static String toEncodedString(byte[] bytes2, Charset charset) {
        return new String(bytes2, Charsets.toCharset(charset));
    }

    public static String toRootLowerCase(String source2) {
        return source2 == null ? null : source2.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String source2) {
        return source2 == null ? null : source2.toUpperCase(Locale.ROOT);
    }

    @Deprecated
    public static String toString(byte[] bytes2, String charsetName) throws UnsupportedEncodingException {
        return new String(bytes2, Charsets.toCharset(charsetName));
    }

    private static String toStringOrEmpty(Object obj) {
        return Objects.toString(obj, EMPTY);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String truncate(String str, int maxWidth) {
        return StringUtils.truncate(str, 0, maxWidth);
    }

    public static String truncate(String str, int offset2, int maxWidth) {
        if (offset2 < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str == null) {
            return null;
        }
        if (offset2 > str.length()) {
            return EMPTY;
        }
        if (str.length() > maxWidth) {
            int ix = Math.min(offset2 + maxWidth, str.length());
            return str.substring(offset2, ix);
        }
        return str.substring(offset2);
    }

    public static String uncapitalize(String str) {
        int codePoint;
        int newCodePoint;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodePoint = str.codePointAt(0);
        if (firstCodePoint == (newCodePoint = Character.toLowerCase(firstCodePoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodePoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String unwrap(String str, char wrapChar) {
        if (StringUtils.isEmpty(str) || wrapChar == '\u0000' || str.length() == 1) {
            return str;
        }
        if (str.charAt(0) == wrapChar && str.charAt(str.length() - 1) == wrapChar) {
            boolean startIndex = false;
            int endIndex = str.length() - 1;
            return str.substring(1, endIndex);
        }
        return str;
    }

    public static String unwrap(String str, String wrapToken) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapToken) || str.length() < 2 * wrapToken.length()) {
            return str;
        }
        if (StringUtils.startsWith(str, wrapToken) && StringUtils.endsWith(str, wrapToken)) {
            return str.substring(wrapToken.length(), str.lastIndexOf(wrapToken));
        }
        return str;
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String upperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(LocaleUtils.toLocale(locale));
    }

    public static String valueOf(char[] value2) {
        return value2 == null ? null : String.valueOf(value2);
    }

    public static String wrap(String str, char wrapWith) {
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        return wrapWith + str + wrapWith;
    }

    public static String wrap(String str, String wrapWith) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        return wrapWith.concat(str).concat(wrapWith);
    }

    public static String wrapIfMissing(String str, char wrapWith) {
        boolean wrapEnd;
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        boolean wrapStart = str.charAt(0) != wrapWith;
        boolean bl = wrapEnd = str.charAt(str.length() - 1) != wrapWith;
        if (!wrapStart && !wrapEnd) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() + 2);
        if (wrapStart) {
            builder.append(wrapWith);
        }
        builder.append(str);
        if (wrapEnd) {
            builder.append(wrapWith);
        }
        return builder.toString();
    }

    public static String wrapIfMissing(String str, String wrapWith) {
        boolean wrapEnd;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        boolean wrapStart = !str.startsWith(wrapWith);
        boolean bl = wrapEnd = !str.endsWith(wrapWith);
        if (!wrapStart && !wrapEnd) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() + wrapWith.length() + wrapWith.length());
        if (wrapStart) {
            builder.append(wrapWith);
        }
        builder.append(str);
        if (wrapEnd) {
            builder.append(wrapWith);
        }
        return builder.toString();
    }

    @Deprecated
    public StringUtils() {
    }
}

