/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.lang3.CachedRandomBits;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.exception.UncheckedException;

public class RandomStringUtils {
    private static final ThreadLocal<SecureRandom> RANDOM = ThreadLocal.withInitial(() -> {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedException(e);
        }
    });
    private static final char[] ALPHANUMERICAL_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    static SecureRandom random() {
        return RANDOM.get();
    }

    public static String random(int count2) {
        return RandomStringUtils.random(count2, false, false);
    }

    public static String random(int count2, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, 0, 0, letters, numbers);
    }

    public static String random(int count2, char ... chars2) {
        if (chars2 == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, RandomStringUtils.random());
        }
        return RandomStringUtils.random(count2, 0, chars2.length, false, false, chars2, RandomStringUtils.random());
    }

    public static String random(int count2, int start2, int end2, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, start2, end2, letters, numbers, null, RandomStringUtils.random());
    }

    public static String random(int count2, int start2, int end2, boolean letters, boolean numbers, char ... chars2) {
        return RandomStringUtils.random(count2, start2, end2, letters, numbers, chars2, RandomStringUtils.random());
    }

    public static String random(int count2, int start2, int end2, boolean letters, boolean numbers, char[] chars2, Random random) {
        if (count2 == 0) {
            return "";
        }
        if (count2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + count2 + " is less than 0.");
        }
        if (chars2 != null && chars2.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start2 == 0 && end2 == 0) {
            if (chars2 != null) {
                end2 = chars2.length;
            } else if (!letters && !numbers) {
                end2 = 0x10FFFF;
            } else {
                end2 = 123;
                start2 = 32;
            }
        } else if (end2 <= start2) {
            throw new IllegalArgumentException("Parameter end (" + end2 + ") must be greater than start (" + start2 + ")");
        }
        if (end2 > 0x10FFFF) {
            end2 = 0x10FFFF;
        }
        if (chars2 == null && letters && numbers && start2 <= 48 && end2 >= 123) {
            return RandomStringUtils.random(count2, 0, 0, false, false, ALPHANUMERICAL_CHARS, random);
        }
        if (chars2 == null) {
            if (letters && numbers) {
                start2 = Math.max(48, start2);
                end2 = Math.min(123, end2);
            } else if (numbers) {
                start2 = Math.max(48, start2);
                end2 = Math.min(58, end2);
            } else if (letters) {
                start2 = Math.max(65, start2);
                end2 = Math.min(123, end2);
            }
        }
        int zeroDigitAscii = 48;
        int firstLetterAscii = 65;
        if (chars2 == null && (numbers && end2 <= 48 || letters && end2 <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + end2 + ") must be greater then (" + 48 + ") for generating digits or greater then (" + 65 + ") for generating letters.");
        }
        StringBuilder builder = new StringBuilder(count2);
        int gap = end2 - start2;
        int gapBits = 32 - Integer.numberOfLeadingZeros(gap);
        CachedRandomBits arb = new CachedRandomBits((count2 * gapBits + 3) / 5 + 10, random);
        block3: while (count2-- != 0) {
            int codePoint;
            int randomValue = arb.nextBits(gapBits) + start2;
            if (randomValue >= end2) {
                ++count2;
                continue;
            }
            if (chars2 == null) {
                codePoint = randomValue;
                switch (Character.getType(codePoint)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++count2;
                        continue block3;
                    }
                }
            } else {
                codePoint = chars2[randomValue];
            }
            int numberOfChars = Character.charCount(codePoint);
            if (count2 == 0 && numberOfChars > 1) {
                ++count2;
                continue;
            }
            if (letters && Character.isLetter(codePoint) || numbers && Character.isDigit(codePoint) || !letters && !numbers) {
                builder.appendCodePoint(codePoint);
                if (numberOfChars != 2) continue;
                --count2;
                continue;
            }
            ++count2;
        }
        return builder.toString();
    }

    public static String random(int count2, String chars2) {
        if (chars2 == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, RandomStringUtils.random());
        }
        return RandomStringUtils.random(count2, chars2.toCharArray());
    }

    public static String randomAlphabetic(int count2) {
        return RandomStringUtils.random(count2, true, false);
    }

    public static String randomAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomAlphabetic(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    public static String randomAlphanumeric(int count2) {
        return RandomStringUtils.random(count2, true, true);
    }

    public static String randomAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomAlphanumeric(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    public static String randomAscii(int count2) {
        return RandomStringUtils.random(count2, 32, 127, false, false);
    }

    public static String randomAscii(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomAscii(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    public static String randomGraph(int count2) {
        return RandomStringUtils.random(count2, 33, 126, false, false);
    }

    public static String randomGraph(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomGraph(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    public static String randomNumeric(int count2) {
        return RandomStringUtils.random(count2, false, true);
    }

    public static String randomNumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomNumeric(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    public static String randomPrint(int count2) {
        return RandomStringUtils.random(count2, 32, 126, false, false);
    }

    public static String randomPrint(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomPrint(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    @Deprecated
    public RandomStringUtils() {
    }
}

