/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CharSequenceUtils {
    private static final int NOT_FOUND = -1;
    static final int TO_STRING_LIMIT = 16;

    private static boolean checkLaterThan1(CharSequence cs, CharSequence searchChar, int len2, int start1) {
        int i2 = 1;
        for (int j = len2 - 1; i2 <= j; ++i2, --j) {
            if (cs.charAt(start1 + i2) == searchChar.charAt(i2) && cs.charAt(start1 + j) == searchChar.charAt(j)) continue;
            return false;
        }
        return true;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar.toString(), start2);
        }
        if (cs instanceof StringBuilder) {
            return ((StringBuilder)cs).indexOf(searchChar.toString(), start2);
        }
        if (cs instanceof StringBuffer) {
            return ((StringBuffer)cs).indexOf(searchChar.toString(), start2);
        }
        return cs.toString().indexOf(searchChar.toString(), start2);
    }

    static int indexOf(CharSequence cs, int searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start2);
        }
        int sz = cs.length();
        if (start2 < 0) {
            start2 = 0;
        }
        if (searchChar < 65536) {
            for (int i2 = start2; i2 < sz; ++i2) {
                if (cs.charAt(i2) != searchChar) continue;
                return i2;
            }
            return -1;
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars2 = Character.toChars(searchChar);
            for (int i3 = start2; i3 < sz - 1; ++i3) {
                char high = cs.charAt(i3);
                char low = cs.charAt(i3 + 1);
                if (high != chars2[0] || low != chars2[1]) continue;
                return i3;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        if (searchChar == null || cs == null) {
            return -1;
        }
        if (searchChar instanceof String) {
            if (cs instanceof String) {
                return ((String)cs).lastIndexOf((String)searchChar, start);
            }
            if (cs instanceof StringBuilder) {
                return ((StringBuilder)cs).lastIndexOf((String)searchChar, start);
            }
            if (cs instanceof StringBuffer) {
                return ((StringBuffer)cs).lastIndexOf((String)searchChar, start);
            }
        }
        len1 = cs.length();
        len2 = searchChar.length();
        if (start > len1) {
            start = len1;
        }
        if (start < 0 || len2 > len1) {
            return -1;
        }
        if (len2 == 0) {
            return start;
        }
        if (len2 <= 16) {
            if (cs instanceof String) {
                return ((String)cs).lastIndexOf(searchChar.toString(), start);
            }
            if (cs instanceof StringBuilder) {
                return ((StringBuilder)cs).lastIndexOf(searchChar.toString(), start);
            }
            if (cs instanceof StringBuffer) {
                return ((StringBuffer)cs).lastIndexOf(searchChar.toString(), start);
            }
        }
        if (start + len2 > len1) {
            start = len1 - len2;
        }
        char0 = searchChar.charAt(0);
        i = start;
        do lbl-1000:
        // 3 sources

        {
            block14: {
                if (cs.charAt(i) == char0) break block14;
                if (--i >= 0) ** GOTO lbl-1000
                return -1;
            }
            if (!CharSequenceUtils.checkLaterThan1(cs, searchChar, len2, i)) continue;
            return i;
        } while (--i >= 0);
        return -1;
    }

    static int lastIndexOf(CharSequence cs, int searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).lastIndexOf(searchChar, start2);
        }
        int sz = cs.length();
        if (start2 < 0) {
            return -1;
        }
        if (start2 >= sz) {
            start2 = sz - 1;
        }
        if (searchChar < 65536) {
            for (int i2 = start2; i2 >= 0; --i2) {
                if (cs.charAt(i2) != searchChar) continue;
                return i2;
            }
            return -1;
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars2 = Character.toChars(searchChar);
            if (start2 == sz - 1) {
                return -1;
            }
            for (int i3 = start2; i3 >= 0; --i3) {
                char high = cs.charAt(i3);
                char low = cs.charAt(i3 + 1);
                if (chars2[0] != high || chars2[1] != low) continue;
                return i3;
            }
        }
        return -1;
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start2, int length2) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start2, length2);
        }
        int index1 = thisStart;
        int index2 = start2;
        int tmpLen = length2;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start2;
        if (thisStart < 0 || start2 < 0 || length2 < 0) {
            return false;
        }
        if (srcLen < length2 || otherLen < length2) {
            return false;
        }
        while (tmpLen-- > 0) {
            char u2;
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            char u1 = Character.toUpperCase(c1);
            if (u1 == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static CharSequence subSequence(CharSequence cs, int start2) {
        return cs == null ? null : cs.subSequence(start2, cs.length());
    }

    public static char[] toCharArray(CharSequence source2) {
        int len = StringUtils.length(source2);
        if (len == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        if (source2 instanceof String) {
            return ((String)source2).toCharArray();
        }
        char[] array2 = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = source2.charAt(i2);
        }
        return array2;
    }

    @Deprecated
    public CharSequenceUtils() {
    }
}

