/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.commons.cli.Converter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.TypeHandler;

public class PatternOptionBuilder {
    public static final Class<String> STRING_VALUE = String.class;
    public static final Class<Object> OBJECT_VALUE = Object.class;
    public static final Class<Number> NUMBER_VALUE = Number.class;
    public static final Class<Date> DATE_VALUE = Date.class;
    public static final Class<?> CLASS_VALUE = Class.class;
    public static final Class<FileInputStream> EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class<File> FILE_VALUE = File.class;
    public static final Class<File[]> FILES_VALUE = File[].class;
    public static final Class<URL> URL_VALUE = URL.class;
    private static final Converter<?, UnsupportedOperationException> UNSUPPORTED = s2 -> {
        throw new UnsupportedOperationException("Not yet implemented");
    };

    @Deprecated
    public static Object getValueClass(char ch) {
        return PatternOptionBuilder.getValueType(ch);
    }

    public static Class<?> getValueType(char ch) {
        switch (ch) {
            case '@': {
                return OBJECT_VALUE;
            }
            case ':': {
                return STRING_VALUE;
            }
            case '%': {
                return NUMBER_VALUE;
            }
            case '+': {
                return CLASS_VALUE;
            }
            case '#': {
                return DATE_VALUE;
            }
            case '<': {
                return EXISTING_FILE_VALUE;
            }
            case '>': {
                return FILE_VALUE;
            }
            case '*': {
                return FILES_VALUE;
            }
            case '/': {
                return URL_VALUE;
            }
        }
        return null;
    }

    public static boolean isValueCode(char ch) {
        return ch == '@' || ch == ':' || ch == '%' || ch == '+' || ch == '#' || ch == '<' || ch == '>' || ch == '*' || ch == '/' || ch == '!';
    }

    public static Options parsePattern(String pattern) {
        char opt = ' ';
        boolean required = false;
        Class<?> type2 = null;
        Converter<?, RuntimeException> converter = Converter.DEFAULT;
        Options options2 = new Options();
        for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char ch = pattern.charAt(i2);
            if (!PatternOptionBuilder.isValueCode(ch)) {
                if (opt != ' ') {
                    Option option = Option.builder(String.valueOf(opt)).hasArg(type2 != null).required(required).type(type2).converter(converter).build();
                    options2.addOption(option);
                    required = false;
                    type2 = null;
                    converter = Converter.DEFAULT;
                }
                opt = ch;
                continue;
            }
            if (ch == '!') {
                required = true;
                continue;
            }
            type2 = PatternOptionBuilder.getValueType(ch);
            Map<Class<?>, Converter<?, Throwable>> map2 = TypeHandler.createDefaultMap();
            map2.put(FILES_VALUE, (Converter)PatternOptionBuilder.unsupported());
            converter = new TypeHandler(map2).getConverter(PatternOptionBuilder.getValueType(ch));
        }
        if (opt != ' ') {
            Option option = Option.builder(String.valueOf(opt)).hasArg(type2 != null).required(required).type(type2).build();
            options2.addOption(option);
        }
        return options2;
    }

    static <T> T unsupported() {
        return (T)UNSUPPORTED;
    }
}

