/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

public class DefaultParser
implements CommandLineParser {
    protected CommandLine cmd;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;
    private final boolean allowPartialMatching;
    private final Boolean stripLeadingAndTrailingQuotes;
    private final Consumer<Option> deprecatedHandler;

    public static Builder builder() {
        return new Builder();
    }

    static int indexOfEqual(String token2) {
        return token2.indexOf(61);
    }

    public DefaultParser() {
        this.allowPartialMatching = true;
        this.stripLeadingAndTrailingQuotes = null;
        this.deprecatedHandler = CommandLine.Builder.DEPRECATED_HANDLER;
    }

    public DefaultParser(boolean allowPartialMatching) {
        this.allowPartialMatching = allowPartialMatching;
        this.stripLeadingAndTrailingQuotes = null;
        this.deprecatedHandler = CommandLine.Builder.DEPRECATED_HANDLER;
    }

    private DefaultParser(boolean allowPartialMatching, Boolean stripLeadingAndTrailingQuotes, Consumer<Option> deprecatedHandler) {
        this.allowPartialMatching = allowPartialMatching;
        this.stripLeadingAndTrailingQuotes = stripLeadingAndTrailingQuotes;
        this.deprecatedHandler = deprecatedHandler;
    }

    private void checkRequiredArgs() throws ParseException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            if (this.isJavaProperty(this.currentOption.getKey()) && this.currentOption.getValuesList().size() == 1) {
                return;
            }
            throw new MissingArgumentException(this.currentOption);
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private String getLongPrefix(String token2) {
        String t = Util.stripLeadingHyphens(token2);
        String opt = null;
        for (int i2 = t.length() - 2; i2 > 1; --i2) {
            String prefix = t.substring(0, i2);
            if (!this.options.hasLongOption(prefix)) continue;
            opt = prefix;
            break;
        }
        return opt;
    }

    private List<String> getMatchingLongOptions(String token2) {
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(token2);
        }
        ArrayList<String> matches = new ArrayList<String>(1);
        if (this.options.hasLongOption(token2)) {
            matches.add(this.options.getOption(token2).getLongOpt());
        }
        return matches;
    }

    protected void handleConcatenatedOptions(String token2) throws ParseException {
        for (int i2 = 1; i2 < token2.length(); ++i2) {
            String ch = String.valueOf(token2.charAt(i2));
            if (!this.options.hasOption(ch)) {
                this.handleUnknownToken(this.stopAtNonOption && i2 > 1 ? token2.substring(i2) : token2);
                break;
            }
            this.handleOption(this.options.getOption(ch));
            if (this.currentOption == null || token2.length() == i2 + 1) continue;
            this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(token2.substring(i2 + 1)));
            break;
        }
    }

    private void handleLongOption(String token2) throws ParseException {
        if (DefaultParser.indexOfEqual(token2) == -1) {
            this.handleLongOptionWithoutEqual(token2);
        } else {
            this.handleLongOptionWithEqual(token2);
        }
    }

    private void handleLongOptionWithEqual(String token2) throws ParseException {
        int pos2 = DefaultParser.indexOfEqual(token2);
        String value2 = token2.substring(pos2 + 1);
        String opt = token2.substring(0, pos2);
        List<String> matchingOpts = this.getMatchingLongOptions(opt);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(opt)) {
                throw new AmbiguousOptionException(opt, matchingOpts);
            }
            String key2 = this.options.hasLongOption(opt) ? opt : matchingOpts.get(0);
            Option option = this.options.getOption(key2);
            if (option.acceptsArg()) {
                this.handleOption(option);
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(value2));
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleLongOptionWithoutEqual(String token2) throws ParseException {
        List<String> matchingOpts = this.getMatchingLongOptions(token2);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(token2)) {
                throw new AmbiguousOptionException(token2, matchingOpts);
            }
            String key2 = this.options.hasLongOption(token2) ? token2 : matchingOpts.get(0);
            this.handleOption(this.options.getOption(key2));
        }
    }

    private void handleOption(Option option) throws ParseException {
        this.checkRequiredArgs();
        Option copy2 = (Option)option.clone();
        this.updateRequiredOptions(copy2);
        this.cmd.addOption(copy2);
        this.currentOption = copy2.hasArg() ? copy2 : null;
    }

    private void handleProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option = e.nextElement().toString();
            Option opt = this.options.getOption(option);
            if (opt == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option);
            }
            OptionGroup group2 = this.options.getOptionGroup(opt);
            boolean bl = selected = group2 != null && group2.getSelected() != null;
            if (this.cmd.hasOption(option) || selected) continue;
            String value2 = properties.getProperty(option);
            if (opt.hasArg()) {
                if (Util.isEmpty(opt.getValues())) {
                    opt.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(value2));
                }
            } else if (!"yes".equalsIgnoreCase(value2) && !"true".equalsIgnoreCase(value2) && !"1".equalsIgnoreCase(value2)) continue;
            this.handleOption(opt);
            this.currentOption = null;
        }
    }

    private void handleShortAndLongOption(String hyphenToken) throws ParseException {
        String token2 = Util.stripLeadingHyphens(hyphenToken);
        int pos2 = DefaultParser.indexOfEqual(token2);
        if (token2.length() == 1) {
            if (this.options.hasShortOption(token2)) {
                this.handleOption(this.options.getOption(token2));
            } else {
                this.handleUnknownToken(hyphenToken);
            }
        } else if (pos2 == -1) {
            if (this.options.hasShortOption(token2)) {
                this.handleOption(this.options.getOption(token2));
            } else if (!this.getMatchingLongOptions(token2).isEmpty()) {
                this.handleLongOptionWithoutEqual(hyphenToken);
            } else {
                String opt = this.getLongPrefix(token2);
                if (opt != null && this.options.getOption(opt).acceptsArg()) {
                    this.handleOption(this.options.getOption(opt));
                    this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(token2.substring(opt.length())));
                    this.currentOption = null;
                } else if (this.isJavaProperty(token2)) {
                    this.handleOption(this.options.getOption(token2.substring(0, 1)));
                    this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(token2.substring(1)));
                    this.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(hyphenToken);
                }
            }
        } else {
            String opt = token2.substring(0, pos2);
            String value2 = token2.substring(pos2 + 1);
            if (opt.length() == 1) {
                Option option = this.options.getOption(opt);
                if (option != null && option.acceptsArg()) {
                    this.handleOption(option);
                    this.currentOption.processValue(value2);
                    this.currentOption = null;
                } else {
                    this.handleUnknownToken(hyphenToken);
                }
            } else if (this.isJavaProperty(opt)) {
                this.handleOption(this.options.getOption(opt.substring(0, 1)));
                this.currentOption.processValue(opt.substring(1));
                this.currentOption.processValue(value2);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(hyphenToken);
            }
        }
    }

    private void handleToken(String token2) throws ParseException {
        if (token2 != null) {
            this.currentToken = token2;
            if (this.skipParsing) {
                this.cmd.addArg(token2);
            } else if ("--".equals(token2)) {
                this.skipParsing = true;
            } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(token2)) {
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOn(token2));
            } else if (token2.startsWith("--")) {
                this.handleLongOption(token2);
            } else if (token2.startsWith("-") && !"-".equals(token2)) {
                this.handleShortAndLongOption(token2);
            } else {
                this.handleUnknownToken(token2);
            }
            if (this.currentOption != null && !this.currentOption.acceptsArg()) {
                this.currentOption = null;
            }
        }
    }

    private void handleUnknownToken(String token2) throws ParseException {
        if (token2.startsWith("-") && token2.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + token2, token2);
        }
        this.cmd.addArg(token2);
        if (this.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private boolean isArgument(String token2) {
        return !this.isOption(token2) || this.isNegativeNumber(token2);
    }

    private boolean isJavaProperty(String token2) {
        String opt = token2.isEmpty() ? null : token2.substring(0, 1);
        Option option = this.options.getOption(opt);
        return option != null && (option.getArgs() >= 2 || option.getArgs() == -2);
    }

    private boolean isLongOption(String token2) {
        String t;
        if (token2 == null || !token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos2 = DefaultParser.indexOfEqual(token2);
        String string2 = t = pos2 == -1 ? token2 : token2.substring(0, pos2);
        if (!this.getMatchingLongOptions(t).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token2) != null && !token2.startsWith("--");
    }

    private boolean isNegativeNumber(String token2) {
        try {
            Double.parseDouble(token2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token2) {
        return this.isLongOption(token2) || this.isShortOption(token2);
    }

    private boolean isShortOption(String token2) {
        String optName;
        if (token2 == null || !token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos2 = DefaultParser.indexOfEqual(token2);
        String string2 = optName = pos2 == -1 ? token2.substring(1) : token2.substring(1, pos2);
        if (this.options.hasShortOption(optName)) {
            return true;
        }
        return !optName.isEmpty() && this.options.hasShortOption(String.valueOf(optName.charAt(0)));
    }

    @Override
    public CommandLine parse(Options options2, String[] arguments) throws ParseException {
        return this.parse(options2, arguments, null);
    }

    @Override
    public CommandLine parse(Options options2, String[] arguments, boolean stopAtNonOption) throws ParseException {
        return this.parse(options2, arguments, null, stopAtNonOption);
    }

    public CommandLine parse(Options options2, String[] arguments, Properties properties) throws ParseException {
        return this.parse(options2, arguments, properties, false);
    }

    public CommandLine parse(Options options2, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
        this.options = options2;
        this.stopAtNonOption = stopAtNonOption;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList(options2.getRequiredOptions());
        for (OptionGroup group2 : options2.getOptionGroups()) {
            group2.setSelected(null);
        }
        this.cmd = CommandLine.builder().setDeprecatedHandler(this.deprecatedHandler).build();
        if (arguments != null) {
            for (String argument : arguments) {
                this.handleToken(argument);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    private String stripLeadingAndTrailingQuotesDefaultOff(String token2) {
        if (this.stripLeadingAndTrailingQuotes != null && this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(token2);
        }
        return token2;
    }

    private String stripLeadingAndTrailingQuotesDefaultOn(String token2) {
        if (this.stripLeadingAndTrailingQuotes == null || this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(token2);
        }
        return token2;
    }

    private void updateRequiredOptions(Option option) throws AlreadySelectedException {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup group2 = this.options.getOptionGroup(option);
            if (group2.isRequired()) {
                this.expectedOpts.remove(group2);
            }
            group2.setSelected(option);
        }
    }

    public static final class Builder {
        private boolean allowPartialMatching = true;
        private Consumer<Option> deprecatedHandler = CommandLine.Builder.DEPRECATED_HANDLER;
        private Boolean stripLeadingAndTrailingQuotes;

        private Builder() {
        }

        public DefaultParser build() {
            return new DefaultParser(this.allowPartialMatching, this.stripLeadingAndTrailingQuotes, this.deprecatedHandler);
        }

        public Builder setAllowPartialMatching(boolean allowPartialMatching) {
            this.allowPartialMatching = allowPartialMatching;
            return this;
        }

        public Builder setDeprecatedHandler(Consumer<Option> deprecatedHandler) {
            this.deprecatedHandler = deprecatedHandler;
            return this;
        }

        public Builder setStripLeadingAndTrailingQuotes(Boolean stripLeadingAndTrailingQuotes) {
            this.stripLeadingAndTrailingQuotes = stripLeadingAndTrailingQuotes;
            return this;
        }
    }
}

